/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLParser;
import oracle.xml.xpath.AdditiveExpr;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathItem;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xslt.XSLException;

class RangeExpr
extends XSLExprBase {
    RangeExpr() {
        super.setExprType(34603064);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        XSLExprBase xSLExprBase = AdditiveExpr.parse(xSLParseString);
        if (xSLParseString.peekToken(106)) {
            XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(225, 0);
            }
            RangeExpr rangeExpr = new RangeExpr();
            rangeExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            rangeExpr.leftExpr = xSLExprBase;
            rangeExpr.rightExpr = AdditiveExpr.parse(xSLParseString);
            if (xSLParseString.isCachingExpr() && !((XSLExprBase)rangeExpr).canCacheExpr()) {
                ((XSLExprBase)rangeExpr).cacheSubExpr();
            }
            if (xPathCompileEvents != null) {
                xPathCompileEvents.reportEventsNoParam(225, 1);
            }
            xSLExprBase = rangeExpr;
        }
        return xSLExprBase;
    }

    @Override
    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
        if (this.rightExpr.canCacheExpr()) {
            this.rightExpr = this.rightExpr.createCachedExpr();
        }
    }

    @Override
    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr() && this.rightExpr.canCacheExpr();
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer(this.leftExpr.getNormalizedExpr());
        stringBuffer.append(106);
        stringBuffer.append(this.rightExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        int n2;
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        double d2 = this.leftExpr.getNumberValue(xPathRuntimeContext);
        double d3 = this.rightExpr.getNumberValue(xPathRuntimeContext);
        int n3 = new Double(d2).intValue();
        int n4 = new Double(d3).intValue();
        if ((double)n3 != d2 && !Double.isNaN(d2)) {
            throw new XPathException(1055, new Double(d2).toString());
        }
        if ((double)n4 != d3) {
            throw new XPathException(1055, new Double(d3).toString());
        }
        OXMLSequence oXMLSequence = xPathRuntimeContext.pushExprValue();
        int n5 = n2 = n3 > n4 ? -1 : 1;
        if (n2 == 1) {
            for (int i2 = n3; i2 <= n4; ++i2) {
                XPathItem xPathItem = xPathRuntimeContext.allocItem();
                xPathItem.setInt(OXMLSequenceType.TINTEGER, i2);
                oXMLSequence.appendItem(xPathItem);
            }
        } else if (XMLParser.getIs1010Compatible()) {
            for (int i3 = n3; i3 >= n4; --i3) {
                XPathItem xPathItem = xPathRuntimeContext.allocItem();
                xPathItem.setInt(OXMLSequenceType.TINTEGER, i3);
                oXMLSequence.appendItem(xPathItem);
            }
        } else {
            oXMLSequence.setKnownType(OXMLSequenceType.EMPTY_SEQUENCE);
        }
    }
}

