/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLParser;
import oracle.xml.xpath.AdditiveExpr;
import oracle.xml.xpath.RangeExpr;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;

class ComparisonExpr
extends XSLExprBase {
    short compType;
    static short GENERALCOMP = 1;
    static short VALUECOMP = (short)2;
    static short NODECOMP = (short)3;
    static short ORDERCOMP = (short)4;

    ComparisonExpr() {
        super.setExprType(4);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        boolean bl = XSLExpr.isXPath20Compatible(xSLParseString);
        XSLExprBase xSLExprBase = bl ? RangeExpr.parse(xSLParseString) : AdditiveExpr.parse(xSLParseString);
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        int n2 = 0;
        int n3 = 0;
        if (xSLParseString.peekToken() == 105) {
            if (xPathCompileEvents != null) {
                n2 = 224;
                xPathCompileEvents.reportEventsNoParam(n2, 0);
            }
            ComparisonExpr comparisonExpr = new ComparisonExpr();
            comparisonExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            n3 = xSLParseString.getOperator();
            if (xPathCompileEvents != null) {
                if (ComparisonExpr.isEqualityOp(n3)) {
                    n2 = 106;
                    xPathCompileEvents.reportEventsNoParam(n2, 0);
                } else if (ComparisonExpr.isRelationalOp(n3)) {
                    n2 = 116;
                    xPathCompileEvents.reportEventsNoParam(n2, 0);
                }
                if (n2 != 0) {
                    xPathCompileEvents.reportEventsWithIntParam(n2, 1, n3, 0);
                }
            }
            if (ComparisonExpr.isGeneralCompOp(n3)) {
                comparisonExpr.compType = GENERALCOMP;
                if (xPathCompileEvents != null) {
                    n2 = 227;
                    xPathCompileEvents.reportEventsWithIntParam(n2, 2, n3, 0);
                }
            } else if (ComparisonExpr.isValueCompOp(n3)) {
                comparisonExpr.compType = VALUECOMP;
                if (xPathCompileEvents != null) {
                    n2 = 228;
                    xPathCompileEvents.reportEventsWithIntParam(n2, 2, n3, 0);
                }
            } else if (ComparisonExpr.isNodeCompOp(n3)) {
                comparisonExpr.compType = NODECOMP;
                if (xPathCompileEvents != null) {
                    n2 = 229;
                    xPathCompileEvents.reportEventsWithIntParam(n2, 2, n3, 0);
                }
            } else if (ComparisonExpr.isOrderCompOp(n3)) {
                comparisonExpr.compType = ORDERCOMP;
            } else {
                return xSLExprBase;
            }
            xSLParseString.nextToken();
            comparisonExpr.operator = n3;
            comparisonExpr.leftExpr = xSLExprBase;
            comparisonExpr.rightExpr = bl ? RangeExpr.parse(xSLParseString) : ComparisonExpr.parse(xSLParseString);
            XSLExprBase xSLExprBase2 = comparisonExpr.rightExpr;
            if (xSLExprBase2 instanceof ComparisonExpr) {
                xSLExprBase = xSLExprBase2;
                while (xSLExprBase2.leftExpr instanceof ComparisonExpr) {
                    xSLExprBase2 = xSLExprBase2.leftExpr;
                }
                comparisonExpr.rightExpr = xSLExprBase2.leftExpr;
                xSLExprBase2.leftExpr = comparisonExpr;
            } else {
                xSLExprBase = comparisonExpr;
            }
            if (xSLParseString.isCachingExpr() && !xSLExprBase.canCacheExpr()) {
                xSLExprBase.cacheSubExpr();
            }
        }
        if (xPathCompileEvents != null) {
            if (n2 != 0) {
                xPathCompileEvents.reportEventsWithIntParam(n2, 1, n3, 0);
            }
            if (xSLExprBase instanceof ComparisonExpr && n3 != 0) {
                xPathCompileEvents.reportEventsWithIntParam(224, 1, n3, 0);
            }
        }
        return xSLExprBase;
    }

    static boolean isEqualityOp(int n2) {
        return n2 == 216 || n2 == 217;
    }

    static boolean isRelationalOp(int n2) {
        return n2 == 218 || n2 == 219 || n2 == 220 || n2 == 221;
    }

    static boolean isGeneralCompOp(int n2) {
        return n2 == 216 || n2 == 217 || n2 == 218 || n2 == 219 || n2 == 220 || n2 == 221;
    }

    static boolean isValueCompOp(int n2) {
        return n2 == 210 || n2 == 211 || n2 == 212 || n2 == 213 || n2 == 214 || n2 == 215;
    }

    static boolean isNodeCompOp(int n2) {
        if (XMLParser.getIs1010Compatible()) {
            return n2 == 208 || n2 == 209;
        }
        return n2 == 208;
    }

    static boolean isOrderCompOp(int n2) {
        return n2 == 222 || n2 == 223;
    }

    @Override
    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
        if (this.rightExpr.canCacheExpr()) {
            this.rightExpr = this.rightExpr.createCachedExpr();
        }
    }

    @Override
    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr() && this.rightExpr.canCacheExpr();
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer(this.leftExpr.getNormalizedExpr());
        stringBuffer.append(this.operator);
        stringBuffer.append(this.rightExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        xPathRuntimeContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.leftExpr.evaluate(xPathRuntimeContext);
        OXMLSequence oXMLSequence = xPathRuntimeContext.peekExprValue();
        this.rightExpr.evaluate(xPathRuntimeContext);
        if (this.compType == GENERALCOMP) {
            boolean bl = this.getXSLTVersion() == 10 && !this.isForwardCompatibilityMode() || this.getXSLTVersion() == 20 && this.isBackwardCompatibilityMode();
            XPathSequence.compareGeneral(oXMLSequence, xPathRuntimeContext.popExprValue(), this.operator, bl);
        }
        if (this.compType == VALUECOMP) {
            XPathSequence.compareValue(oXMLSequence, xPathRuntimeContext.popExprValue(), this.operator);
        } else if (this.compType == NODECOMP || this.compType == ORDERCOMP) {
            XPathSequence.compareNodeAndOrder(oXMLSequence, xPathRuntimeContext.popExprValue(), this.operator);
        }
    }
}

