/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import java.util.ArrayList;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.xml.scalable.InfosetReader2;
import oracle.xml.xpath.XPathStep;

public class StreamingXPath {
    ArrayList stepList;
    StepNode[] result;
    int length;
    InfosetReader2 reader;

    private StreamingXPath(ArrayList arrayList, InfosetReader2 infosetReader2) {
        this.stepList = arrayList;
        this.length = this.stepList.size();
        this.result = new StepNode[this.length + 1];
        this.reader = infosetReader2;
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.result[i2 + 1] = new StepNode((XPathStep)this.stepList.get(i2));
        }
        this.result[0] = new StepNode(null);
        this.result[0].setOffset(this.reader.getOffset());
    }

    public static StreamingXPath evaluate(InfosetReader2 infosetReader2, ArrayList arrayList) {
        return new StreamingXPath(arrayList, infosetReader2);
    }

    public boolean next() {
        if (this.result[0].getOffset() == null) {
            return false;
        }
        this.getNext(this.length);
        return this.result[this.length].getOffset() != null;
    }

    private void getNext(int n2) {
        if (n2 == 0) {
            this.result[0].reset();
            return;
        }
        while (this.getOffset(n2 - 1) != null) {
            StepNode stepNode = this.result[n2];
            if (stepNode.getNext(this.reader, this.getOffset(n2 - 1))) {
                return;
            }
            this.getNext(n2 - 1);
            stepNode.reset();
        }
    }

    public Object getOffset(int n2) {
        return this.result[n2].getOffset();
    }

    public Object getOffset() {
        return this.result[this.length].getOffset();
    }

    class StepNode {
        XPathStep step;
        Object offset;
        Stack ancestors;
        int count;
        boolean desc;

        StepNode(XPathStep xPathStep) {
            this.step = xPathStep;
            this.offset = null;
            this.count = 0;
            if (this.step != null) {
                this.desc = this.step.isDescendantStep();
            }
            if (this.desc) {
                this.ancestors = new Stack();
            }
        }

        void setOffset(Object object) {
            this.offset = object;
        }

        Object getOffset() {
            return this.offset;
        }

        void reset() {
            this.offset = null;
            this.count = 0;
            if (this.desc) {
                this.ancestors.clear();
            }
        }

        boolean getNext(InfosetReader2 infosetReader2, Object object) {
            if (this.offset == null) {
                this.count = 0;
                infosetReader2.seekFromObject(object);
                infosetReader2.next();
            } else {
                infosetReader2.seekFromObject(this.offset);
                infosetReader2.skip();
            }
            int n2 = infosetReader2.getEventType();
            this.offset = null;
            while (n2 != 2) {
                if (n2 == 1 && this.matchNode()) {
                    this.offset = infosetReader2.getOffset();
                    return true;
                }
                infosetReader2.skip();
                n2 = infosetReader2.getEventType();
            }
            return false;
        }

        boolean matchNode() {
            QName qName = StreamingXPath.this.reader.getQName();
            if (this.step.matchQName(qName.getNamespaceURI(), qName.getLocalPart())) {
                ++this.count;
            } else {
                return false;
            }
            return this.step.filter(this.count, StreamingXPath.this.reader.getAttributes());
        }
    }
}

