/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import oracle.xml.comp.CXMLReader;
import oracle.xml.scalable.BinaryIndex;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.IntArrayIndex;

class ShortArrayIndex
extends BinaryIndex {
    short[][] index = new short[64][];
    short[][] children = new short[64][];
    int[] length = new int[64];
    boolean[] child = new boolean[64];
    int depth = 0;
    int level = 0;
    static final short EMPTY_FLAG = Short.MIN_VALUE;

    ShortArrayIndex() {
    }

    @Override
    public BinaryIndex enlargeIndex() {
        IntArrayIndex intArrayIndex = new IntArrayIndex();
        intArrayIndex.depth = this.depth;
        intArrayIndex.level = this.level;
        for (int i2 = 0; i2 < 64 && this.index[i2] != null; ++i2) {
            short[] sArray = this.index[i2];
            short[] sArray2 = this.children[i2];
            int n2 = this.length[i2];
            int[] nArray = new int[sArray.length];
            int[] nArray2 = new int[sArray.length];
            for (int i3 = 0; i3 < n2; ++i3) {
                nArray[i3] = sArray[i3];
                int n3 = sArray2[i3];
                if (n3 < 0) {
                    n3 = n3 & Short.MAX_VALUE | Integer.MIN_VALUE;
                }
                nArray2[i3] = n3;
            }
            intArrayIndex.index[i2] = nArray;
            intArrayIndex.children[i2] = nArray2;
        }
        System.arraycopy(this.child, 0, intArrayIndex.child, 0, 64);
        System.arraycopy(this.length, 0, intArrayIndex.length, 0, 64);
        return intArrayIndex;
    }

    @Override
    public boolean startElement(long l2) {
        if (l2 >= 32767L) {
            return false;
        }
        this.write(l2, this.level, false);
        this.child[this.level] = false;
        if (this.level > 0 && !this.child[this.level - 1]) {
            int n2 = this.length[this.level];
            this.write(n2, this.level - 1, true);
            this.child[this.level - 1] = true;
        }
        int n3 = this.level++;
        this.length[n3] = this.length[n3] + 1;
        return true;
    }

    @Override
    public void endElement() {
        int n2 = this.length[this.level] | Short.MIN_VALUE;
        if (n2 == 0) {
            n2 = -1;
        }
        --this.level;
        if (this.level >= 0 && !this.child[this.level]) {
            this.write(n2, this.level, true);
            this.child[this.level] = true;
        }
    }

    @Override
    public final void buildIndex(InfosetReader infosetReader) throws Exception {
        this.level = 0;
        ((CXMLReader)infosetReader).init();
        this.index[0] = new short[1];
        this.children[0] = new short[1];
        while (infosetReader.hasNext()) {
            infosetReader.next();
            int n2 = infosetReader.getEventType();
            switch (n2) {
                case 1: {
                    int n3;
                    this.write(infosetReader.offsetToLong(), this.level, false);
                    this.child[this.level] = false;
                    if (this.level > 0 && !this.child[this.level - 1]) {
                        n3 = this.length[this.level];
                        this.write(n3, this.level - 1, true);
                        this.child[this.level - 1] = true;
                    }
                    int n4 = this.level++;
                    this.length[n4] = this.length[n4] + 1;
                    break;
                }
                case 2: {
                    int n3 = this.length[this.level] | Short.MIN_VALUE;
                    if (n3 == 0) {
                        n3 = -1;
                    }
                    --this.level;
                    if (this.level < 0 || this.child[this.level]) break;
                    this.write(n3, this.level, true);
                    this.child[this.level] = true;
                    break;
                }
            }
        }
        long l2 = 0L;
        for (int i2 = 1; i2 < 64; ++i2) {
            short[] sArray;
            short[] sArray2 = this.index[i2];
            if (sArray2 == null) {
                this.depth = i2;
                break;
            }
            int n5 = this.length[i2];
            l2 += (long)this.length[i2];
            if (sArray2.length - n5 > 1024) {
                sArray = new short[n5];
                System.arraycopy(sArray2, 0, sArray, 0, n5);
                this.index[i2] = sArray;
            }
            if ((sArray2 = this.children[i2]) == null || sArray2.length - n5 <= 1024) continue;
            sArray = new short[n5];
            System.arraycopy(sArray2, 0, sArray, 0, n5);
            this.children[i2] = sArray;
        }
    }

    private void write(long l2, int n2, boolean bl) {
        short[][] sArray = bl ? this.children : this.index;
        short[] sArray2 = sArray[n2];
        if (sArray2 == null) {
            sArray2 = n2 == 0 ? new short[1] : new short[1024];
            sArray[n2] = sArray2;
            if (!bl) {
                ++this.depth;
            }
        }
        int n3 = this.length[n2];
        if (bl) {
            --n3;
        }
        if (n3 >= sArray2.length) {
            short[] sArray3 = sArray2;
            sArray2 = new short[n3 * 2];
            System.arraycopy(sArray3, 0, sArray2, 0, sArray3.length);
            sArray[n2] = sArray2;
        }
        sArray2[n3] = (short)l2;
    }

    @Override
    long getLocator(int n2, int n3) {
        return this.index[n2][n3];
    }

    @Override
    int getChildStart(int n2, int n3) {
        short s2 = this.children[n2][n3];
        if (s2 < 0) {
            return -1;
        }
        return s2 & 0xFFFF;
    }

    @Override
    int getChildEnd(int n2, int n3) {
        if (++n3 >= this.length[n2]) {
            return this.length[n2 + 1];
        }
        int n4 = this.children[n2][n3] & Short.MAX_VALUE;
        return n4;
    }

    @Override
    int getIndexDepth() {
        return this.depth;
    }
}

