/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import oracle.xml.comp.CXMLReader;
import oracle.xml.scalable.BinaryIndex;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.LongArrayIndex;

class IntArrayIndex
extends BinaryIndex {
    int[][] index = new int[64][];
    int[][] children = new int[64][];
    int[] length = new int[64];
    boolean[] child = new boolean[64];
    int depth = 0;
    int level = 0;
    static final int EMPTY_FLAG = Integer.MIN_VALUE;

    IntArrayIndex() {
    }

    @Override
    public BinaryIndex enlargeIndex() {
        LongArrayIndex longArrayIndex = new LongArrayIndex();
        longArrayIndex.depth = this.depth;
        longArrayIndex.level = this.level;
        for (int i2 = 0; i2 < this.depth; ++i2) {
            int[] nArray = this.index[i2];
            int[] nArray2 = this.children[i2];
            int n2 = nArray.length;
            long[] lArray = new long[n2 * 2];
            int[] nArray3 = new int[n2 * 2];
            for (int i3 = 0; i3 < n2; ++i3) {
                lArray[i3] = nArray[i3];
                nArray3[i3] = nArray2[i3];
            }
            longArrayIndex.index[i2] = lArray;
            longArrayIndex.children[i2] = nArray3;
        }
        System.arraycopy(this.child, 0, longArrayIndex.child, 0, 64);
        System.arraycopy(this.length, 0, longArrayIndex.length, 0, 64);
        return longArrayIndex;
    }

    @Override
    public boolean startElement(long l2) {
        if (l2 >= Integer.MAX_VALUE) {
            return false;
        }
        this.write(l2, this.level, false);
        this.child[this.level] = false;
        if (this.level > 0 && !this.child[this.level - 1]) {
            int n2 = this.length[this.level];
            this.write(n2, this.level - 1, true);
            this.child[this.level - 1] = true;
        }
        int n3 = this.level++;
        this.length[n3] = this.length[n3] + 1;
        return true;
    }

    @Override
    public void endElement() {
        int n2 = this.length[this.level] | Integer.MIN_VALUE;
        if (n2 == 0) {
            n2 = -1;
        }
        --this.level;
        if (this.level >= 0 && !this.child[this.level]) {
            this.write(n2, this.level, true);
            this.child[this.level] = true;
        }
    }

    @Override
    public final void buildIndex(InfosetReader infosetReader) throws Exception {
        this.level = 0;
        ((CXMLReader)infosetReader).init();
        this.index[0] = new int[1];
        this.children[0] = new int[1];
        while (infosetReader.hasNext()) {
            infosetReader.next();
            int n2 = infosetReader.getEventType();
            switch (n2) {
                case 1: {
                    int n3;
                    this.write(infosetReader.offsetToLong(), this.level, false);
                    this.child[this.level] = false;
                    if (this.level > 0 && !this.child[this.level - 1]) {
                        n3 = this.length[this.level];
                        this.write(n3, this.level - 1, true);
                        this.child[this.level - 1] = true;
                    }
                    int n4 = this.level++;
                    this.length[n4] = this.length[n4] + 1;
                    break;
                }
                case 2: {
                    int n3 = this.length[this.level] | Integer.MIN_VALUE;
                    if (n3 == 0) {
                        n3 = -1;
                    }
                    --this.level;
                    if (this.level < 0 || this.child[this.level]) break;
                    this.write(n3, this.level, true);
                    this.child[this.level] = true;
                    break;
                }
            }
        }
        long l2 = 0L;
        for (int i2 = 1; i2 < 64; ++i2) {
            int[] nArray;
            int[] nArray2 = this.index[i2];
            if (nArray2 == null) {
                this.depth = i2;
                break;
            }
            int n5 = this.length[i2];
            l2 += (long)this.length[i2];
            if (nArray2.length - n5 > 1024) {
                nArray = new int[n5];
                System.arraycopy(nArray2, 0, nArray, 0, n5);
                this.index[i2] = nArray;
            }
            if ((nArray2 = this.children[i2]) == null || nArray2.length - n5 <= 1024) continue;
            nArray = new int[n5];
            System.arraycopy(nArray2, 0, nArray, 0, n5);
            this.children[i2] = nArray;
        }
    }

    private void write(long l2, int n2, boolean bl) {
        int[][] nArray = bl ? this.children : this.index;
        int[] nArray2 = nArray[n2];
        if (nArray2 == null) {
            nArray2 = n2 == 0 ? new int[1] : new int[1024];
            nArray[n2] = nArray2;
            if (!bl) {
                ++this.depth;
            }
        }
        int n3 = this.length[n2];
        if (bl) {
            --n3;
        }
        if (n3 >= nArray2.length) {
            int[] nArray3 = nArray2;
            nArray2 = new int[n3 * 2];
            System.arraycopy(nArray3, 0, nArray2, 0, nArray3.length);
            nArray[n2] = nArray2;
        }
        nArray2[n3] = (int)l2;
    }

    public long getIndex(long l2) {
        int[] nArray;
        int n2 = (int)l2;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < this.depth && n2 < (nArray = this.index[i2])[n4]; ++i2) {
            while (n3 < n4) {
                int n5 = (n3 + n4) / 2;
                int n6 = n2 - nArray[n5];
                if (n6 == 0) {
                    return (long)i2 << 32 | (long)n4;
                }
                if (n6 > 0) {
                    n3 = n3 == n5 ? n4 : n5;
                    continue;
                }
                n4 = n5;
            }
            if (n2 == nArray[n4]) {
                return (long)i2 << 32 | (long)n4;
            }
            n3 = this.children[i2][n4];
            n4 = this.getChildEnd(i2, n4);
        }
        return -1L;
    }

    @Override
    long getLocator(int n2, int n3) {
        return this.index[n2][n3];
    }

    @Override
    int getChildStart(int n2, int n3) {
        int n4 = this.children[n2][n3];
        if (n4 < 0) {
            return -1;
        }
        return n4 & 0xFFFFFFFF;
    }

    @Override
    int getChildEnd(int n2, int n3) {
        if (++n3 >= this.length[n2]) {
            return this.length[n2 + 1];
        }
        int n4 = this.children[n2][n3] & Integer.MAX_VALUE;
        return n4;
    }

    @Override
    int getIndexDepth() {
        return this.depth;
    }
}

