/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import javax.xml.namespace.QName;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.scalable.BinaryIndex;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.util.QxName;

public class BinaryNav {
    InfosetReader reader;
    BinaryIndex index;
    int depth;
    int curLevel;
    int offset;
    int firstChild;
    long locator;
    int[] nodePath;
    int[] childEnd;
    boolean sync = false;
    short nodeType;
    boolean doc;
    public static final long DOC_IDX = -1L;
    public static final long NULL_IDX = -2L;

    public BinaryNav(BinaryIndex binaryIndex) {
        this.index = binaryIndex;
        this.depth = 64;
        this.curLevel = 0;
        this.offset = 0;
        this.locator = this.index.getLocator(0, 0);
        this.nodePath = new int[this.depth];
        this.childEnd = new int[this.depth];
        this.doc = false;
        this.reader = binaryIndex.getStream().getInfosetReader();
        this.reader.seek(this.locator);
    }

    public Object clone() {
        BinaryNav binaryNav = new BinaryNav(this.index);
        binaryNav.reader = (InfosetReader)this.reader.clone();
        binaryNav.index = this.index;
        binaryNav.curLevel = this.curLevel;
        binaryNav.offset = this.offset;
        binaryNav.locator = this.locator;
        binaryNav.nodePath = new int[this.depth];
        binaryNav.childEnd = new int[this.depth];
        System.arraycopy(this.nodePath, 0, binaryNav.nodePath, 0, this.depth);
        System.arraycopy(this.childEnd, 0, binaryNav.childEnd, 0, this.depth);
        binaryNav.reader.seek(this.locator);
        binaryNav.doc = this.doc;
        return binaryNav;
    }

    public InfosetReader getReader() {
        return this.reader;
    }

    public long getLocator() {
        return this.locator;
    }

    public int currentLevel() {
        return this.curLevel;
    }

    public QName getQName() {
        return this.reader.getQName();
    }

    public String getNamespace() {
        return this.reader.getQName().getNamespaceURI();
    }

    public String getTagName() {
        if (this.doc) {
            return "#DOCUMENT";
        }
        return ((QxName)this.reader.getQName()).getQName();
    }

    public boolean document() {
        this.doc = true;
        this.offset = -1;
        this.curLevel = -1;
        this.locator = -1L;
        return true;
    }

    public boolean root() {
        this.doc = false;
        this.offset = 0;
        this.curLevel = 0;
        this.locator = this.index.getLocator(this.curLevel, this.offset);
        this.reader.seek(this.locator);
        return true;
    }

    public boolean parent() {
        if (this.doc) {
            return false;
        }
        if (this.curLevel == 0) {
            this.document();
            return true;
        }
        --this.curLevel;
        this.offset = this.nodePath[this.curLevel];
        this.locator = this.index.getLocator(this.curLevel, this.offset);
        this.reader.seek(this.locator);
        return true;
    }

    public boolean nextSibling() {
        if (this.doc) {
            return false;
        }
        if (this.childEnd[this.curLevel] == 0) {
            this.childEnd[this.curLevel] = this.childEnd();
        }
        if (this.offset + 1 >= this.childEnd[this.curLevel]) {
            return false;
        }
        ++this.offset;
        this.locator = this.index.getLocator(this.curLevel, this.offset);
        this.nodePath[this.curLevel] = this.offset;
        this.reader.seek(this.locator);
        return true;
    }

    public boolean prevSibling() {
        if (this.doc || this.offset <= this.firstChild) {
            return false;
        }
        --this.offset;
        this.locator = this.index.getLocator(this.curLevel, this.offset);
        this.nodePath[this.curLevel] = this.offset;
        return true;
    }

    public boolean firstChild() {
        if (this.doc) {
            return this.root();
        }
        int n2 = this.index.getChildStart(this.curLevel, this.offset);
        if (n2 < 0) {
            return false;
        }
        ++this.curLevel;
        this.offset = n2;
        this.locator = this.index.getLocator(this.curLevel, this.offset);
        this.nodePath[this.curLevel] = this.offset;
        this.childEnd[this.curLevel] = 0;
        this.firstChild = this.offset;
        this.reader.seek(this.locator);
        return true;
    }

    public boolean lastChild() {
        if (this.doc) {
            return this.root();
        }
        int n2 = this.index.getChildStart(this.curLevel, this.offset);
        if (n2 < 0) {
            return false;
        }
        ++this.curLevel;
        this.offset = n2;
        this.locator = this.index.getLocator(this.curLevel, this.offset);
        this.nodePath[this.curLevel] = this.offset;
        this.childEnd[this.curLevel] = 0;
        this.firstChild = this.offset;
        this.reader.seek(this.locator);
        return true;
    }

    private int childEnd() {
        if (this.doc) {
            return -1;
        }
        if (this.curLevel == 0) {
            return 1;
        }
        return this.index.getChildEnd(this.curLevel - 1, this.nodePath[this.curLevel - 1]);
    }

    public SAXAttrList getAttributes() {
        return (SAXAttrList)this.reader.getAttributes();
    }

    public String getAttribute(String string) {
        return this.reader.getAttributes().getValue(string);
    }

    public String getAttributeNS(String string, String string2) {
        return this.reader.getAttributes().getValue(string, string2);
    }

    public String getNodeValue() {
        int n2 = 0;
        String string = null;
        while (n2 >= 0) {
            this.reader.next();
            int n3 = this.reader.getEventType();
            switch (n3) {
                case 1: {
                    ++n2;
                    break;
                }
                case 2: {
                    --n2;
                    break;
                }
                case 4: {
                    if (string == null) {
                        string = this.reader.getValue();
                        break;
                    }
                    string.concat(this.reader.getValue());
                }
            }
        }
        return string;
    }

    public boolean nextSiblingByQName(QName qName) {
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        long l2 = this.locator;
        int n2 = this.offset;
        while (this.nextSibling()) {
            QxName qxName = (QxName)this.reader.getQName();
            if (string != qxName.getNamespaceURI() || string2 != qxName.getLocalPart()) continue;
            return true;
        }
        this.locator = l2;
        this.nodePath[this.curLevel] = this.offset = n2;
        this.reader.seek(this.locator);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean nextElementByQName(QName var1_1) {
        var2_2 = var1_1.getNamespaceURI();
        var3_3 = var1_1.getLocalPart();
        var4_4 = this.locator;
        var6_5 = this.offset;
        var7_6 = new int[this.depth];
        System.arraycopy(this.nodePath, 0, var7_6, 0, this.depth);
        block0: while (true) lbl-1000:
        // 3 sources

        {
            block3: {
                if (!this.firstChild()) break block3;
                var8_7 = (QxName)this.reader.getQName();
                if (var2_2 != var8_7.getNamespaceURI() || var3_3 != var8_7.getLocalPart()) ** GOTO lbl-1000
                return true;
            }
            while (this.curLevel > 0) {
                if (this.nextSibling()) {
                    var8_7 = (QxName)this.reader.getQName();
                    if (var2_2 != var8_7.getNamespaceURI() || var3_3 != var8_7.getLocalPart()) continue block0;
                    return true;
                }
                --this.curLevel;
                this.offset = this.nodePath[this.curLevel];
            }
            break;
        }
        this.locator = var4_4;
        this.offset = var6_5;
        this.nodePath = var7_6;
        this.reader.seek(this.locator);
        return false;
    }

    public boolean seekToIndex(long l2) {
        if (l2 == -1L) {
            this.document();
            return true;
        }
        if (l2 <= -2L) {
            return false;
        }
        this.curLevel = (int)(l2 >>> 32);
        this.nodePath[this.curLevel] = this.offset = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        this.locator = this.index.getLocator(this.curLevel, this.offset);
        this.reader.seek(this.locator);
        return true;
    }

    public long getCurrentIndex() {
        if (this.doc) {
            return -1L;
        }
        long l2 = this.curLevel;
        return l2 << 32 | (long)this.offset;
    }

    public BinaryIndex getBinaryIndex() {
        return this.index;
    }
}

