/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import java.io.IOException;
import oracle.xml.scalable.PageManager;

abstract class AbstractPageManager
implements PageManager {
    static final int TABLE_DEFAULT = 100;
    int currentPage;
    int lastPage;
    long currentOffset;
    long lastOffset;
    long[] pageOffset;
    int[] pageLength;
    int tableSize;

    AbstractPageManager() {
    }

    public void init() {
        this.currentOffset = 0L;
        this.currentPage = 0;
        this.tableSize = 100;
        this.pageOffset = new long[this.tableSize];
        this.pageLength = new int[this.tableSize];
        this.lastPage = this.currentPage;
        this.lastOffset = this.currentOffset;
    }

    @Override
    public PageManager.PageId writePage(byte[] byArray, int n2, int n3) {
        int n4 = this.lastPage;
        if (n3 == 0) {
            return null;
        }
        try {
            if (this.currentOffset != this.lastOffset) {
                this.seek(this.lastOffset);
                this.currentOffset = this.lastOffset;
                this.currentPage = this.lastPage;
            }
            this.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            return null;
        }
        if (this.currentPage >= this.tableSize) {
            this.appendPageTable();
        }
        this.pageOffset[this.currentPage] = this.currentOffset;
        this.pageLength[this.currentPage] = n3;
        ++this.currentPage;
        this.currentOffset += (long)n3;
        this.lastPage = this.currentPage;
        this.lastOffset = this.currentOffset;
        return new PageId(n4);
    }

    @Override
    public PageManager.PageId writePage(PageManager.PageId pageId, byte[] byArray, int n2, int n3) {
        PageId pageId2 = (PageId)pageId;
        int n4 = pageId2.getId();
        long l2 = this.pageOffset(pageId2);
        int n5 = this.pageLength(pageId2);
        try {
            if (n5 != n3) {
                long l3;
                long l4 = l2 + (long)n5;
                long l5 = this.lastOffset;
                int n6 = 4096;
                byte[] byArray2 = new byte[n6];
                long l6 = n3 - n5;
                if (l6 > 0L) {
                    l3 = l5;
                    while (l3 > l4) {
                        if (l3 - (long)n6 < l4) {
                            n6 = (int)(l3 - l4);
                            l3 = l4;
                        } else {
                            l3 -= (long)n6;
                        }
                        this.seek(l3);
                        this.read(byArray2, 0, n6);
                        this.seek(l3 + l6);
                        this.write(byArray2, 0, n6);
                    }
                } else if (l6 < 0L) {
                    for (l3 = l4; l3 < l5; l3 += (long)n6) {
                        if (l3 + (long)n6 > l5) {
                            n6 = (int)(l5 - l3);
                        }
                        this.seek(l3);
                        this.read(byArray2, 0, n6);
                        this.seek(l3 + l6);
                        this.write(byArray2, 0, n6);
                    }
                }
                int n7 = n4 + 1;
                while (n7 < this.lastPage) {
                    int n8 = n7++;
                    this.pageOffset[n8] = this.pageOffset[n8] + l6;
                }
                this.lastOffset += l6;
            }
            if (this.currentOffset != l2) {
                this.currentOffset = l2;
                this.currentPage = n4;
            }
            this.seek(l2);
            this.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            return null;
        }
        this.pageLength[this.currentPage] = n3;
        ++this.currentPage;
        this.currentOffset += (long)n3;
        return new PageId(n4);
    }

    @Override
    public int readPage(PageManager.PageId pageId, byte[] byArray, int n2) {
        int n3 = 0;
        try {
            PageId pageId2 = (PageId)pageId;
            int n4 = pageId2.getId();
            long l2 = this.pageOffset(pageId2);
            if (this.currentOffset != l2) {
                this.currentOffset = l2;
                this.currentPage = n4;
                this.seek(this.currentOffset);
            }
            n3 = this.read(byArray, n2, this.pageLength(pageId2));
            this.currentOffset += (long)n3;
            ++this.currentPage;
        }
        catch (IOException iOException) {
            n3 = 0;
        }
        return n3;
    }

    @Override
    public void deletePage(PageManager.PageId pageId) {
        int n2;
        this.pageLength[n2] = -1;
        if (this.lastPage == n2 + 1) {
            for (n2 = ((PageId)pageId).getId(); n2 >= 0 && this.pageLength[n2] == -1; --n2) {
                this.pageLength[n2] = 0;
                this.pageOffset[n2] = 0L;
            }
            this.lastPage = n2 + 1;
        }
        this.lastOffset = 0L;
        for (int i2 = 0; i2 < this.lastPage; ++i2) {
            long l2 = this.pageOffset[i2] + (long)this.pageLength[i2];
            if (l2 <= this.lastOffset) continue;
            this.lastOffset = l2;
        }
        if (this.currentPage > this.lastPage) {
            this.currentPage = this.lastPage;
            this.currentOffset = this.lastOffset;
        }
    }

    @Override
    public int pageLength(PageManager.PageId pageId) {
        PageId pageId2 = (PageId)pageId;
        int n2 = pageId2.getId();
        try {
            return this.pageLength[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    @Override
    public byte pageIdToBytes(PageManager.PageId pageId, byte[] byArray, int n2) {
        int n3 = ((PageId)pageId).getId();
        if (n2 + 4 > byArray.length) {
            return -1;
        }
        byArray[n2++] = (byte)(n3 >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n3 >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n3 >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n3 >>> 0 & 0xFF);
        return 4;
    }

    @Override
    public PageManager.PageId pageIdFromBytes(byte[] byArray, int n2) {
        if (n2 + 4 > byArray.length) {
            return null;
        }
        int n3 = byArray[n2++] & 0xFF;
        int n4 = byArray[n2++] & 0xFF;
        int n5 = byArray[n2++] & 0xFF;
        int n6 = byArray[n2++] & 0xFF;
        int n7 = (n3 << 24) + (n4 << 16) + (n5 << 8) + n6;
        return new PageId(n7);
    }

    private long pageOffset(PageManager.PageId pageId) {
        PageId pageId2 = (PageId)pageId;
        int n2 = pageId2.getId();
        try {
            return this.pageOffset[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0L;
        }
    }

    public abstract void seek(long var1) throws IOException;

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public abstract void close();

    private void appendPageTable() {
        long[] lArray = this.pageOffset;
        this.pageOffset = new long[this.tableSize + 100];
        System.arraycopy(lArray, 0, this.pageOffset, 0, this.tableSize);
        int[] nArray = this.pageLength;
        this.pageLength = new int[this.tableSize + 100];
        System.arraycopy(nArray, 0, this.pageLength, 0, this.tableSize);
        this.tableSize += 100;
    }

    class PageId
    implements PageManager.PageId {
        int id;

        PageId(int n2) {
            this.id = n2;
        }

        int getId() {
            return this.id;
        }

        public String toString() {
            return "ID" + this.id;
        }

        public int compareTo(Object object) {
            PageId pageId = (PageId)object;
            return this.id - pageId.id;
        }
    }
}

