/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLConstants;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.ContentManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XMLAttrList
implements NamedNodeMap,
Serializable,
XMLConstants {
    XMLElement parent;
    long cstate;
    int flags;

    native int xdbGetNumAttrs(long var1, long var3);

    native long xdbGetAttributeNode(long var1, long var3, String var5, String var6);

    native long xdbSetAttributeNode(long var1, long var3, long var5);

    native long xdbRemoveAttributeNode(long var1, long var3, String var5, String var6);

    native long xdbGetNodeItemAt(long var1, long var3, long var5);

    public XMLAttrList(XMLElement xMLElement) {
        switch (xMLElement.flags & 7) {
            case 1: {
                this.flags |= 1;
                break;
            }
            case 4: {
                this.flags |= 4;
                break;
            }
            case 2: {
                this.flags |= 2;
            }
        }
        this.parent = xMLElement;
    }

    @Override
    public int getLength() {
        switch (this.flags & 7) {
            case 1: {
                int n2 = 0;
                for (XMLNode xMLNode = (XMLNode)this.parent.xdkGetFirstAttr(); xMLNode != null; xMLNode = xMLNode.xdkGetNextNode()) {
                    ++n2;
                }
                return n2;
            }
            case 4: {
                int n3 = 0;
                ContentManager contentManager = this.parent.getContentMgr();
                Object object = this.parent.data[2];
                contentManager.seek(object);
                Object object2 = contentManager.getFirstAttribute();
                while (object2 != null) {
                    ++n3;
                    contentManager.seek(object2);
                    object2 = contentManager.getNextSibling();
                }
                return n3;
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                return this.xdbGetNumAttrs(this.parent.xdbGetCtx(), this.cstate);
            }
        }
        return 0;
    }

    @Override
    public Node getNamedItem(String string) {
        switch (this.flags & 7) {
            case 1: 
            case 4: {
                return this.parent.getAttributeNode(string);
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l2 = this.xdbGetAttributeNode(this.parent.xdbGetCtx(), this.cstate, null, string);
                return this.parent.xdbGetNodeFromId(l2, (short)2);
            }
        }
        return null;
    }

    @Override
    public Node setNamedItem(Node node) throws DOMException {
        switch (this.flags & 7) {
            case 1: 
            case 4: {
                this.parent.checkDocument((XMLNode)node);
                if (node.getNodeType() == 2) {
                    return this.parent.setAttributeNode((XMLAttr)node);
                }
                throw new XMLDOMException(3, 21005, this.parent.getXMLError(), node.getClass().getCanonicalName());
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l2 = this.xdbSetAttributeNode(this.parent.xdbGetCtx(), this.cstate, ((XMLNode)node).nodeId);
                return this.parent.xdbGetNodeFromId(l2, (short)2);
            }
        }
        return null;
    }

    @Override
    public Node removeNamedItem(String string) throws DOMException {
        switch (this.flags & 7) {
            case 1: {
                XMLAttr xMLAttr = (XMLAttr)this.parent.getAttributeNode(string);
                if (xMLAttr != null) {
                    if (!this.parent.xdkSetAttributeDefault(xMLAttr)) {
                        this.parent.xdkRemoveAttr(xMLAttr);
                    }
                    xMLAttr.resetNodeFlag(65536);
                    if (this.parent.isScalable()) {
                        this.parent.xdkKeepNode();
                    }
                } else {
                    throw new XMLDOMException(8, 21011, this.parent.getXMLError());
                }
                return xMLAttr;
            }
            case 4: {
                XMLAttr xMLAttr = (XMLAttr)this.parent.getAttributeNode(string);
                if (xMLAttr == null) {
                    throw new XMLDOMException(8, 21011, this.parent.getXMLError());
                }
                this.parent.xtiRemoveAttr(xMLAttr);
                return xMLAttr;
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l2 = this.xdbRemoveAttributeNode(this.parent.xdbGetCtx(), this.cstate, null, string);
                return this.parent.xdbGetNodeFromId(l2, (short)2);
            }
        }
        return null;
    }

    @Override
    public Node item(int n2) {
        switch (this.flags & 7) {
            case 1: {
                for (XMLNode xMLNode = (XMLNode)this.parent.xdkGetFirstAttr(); xMLNode != null; xMLNode = xMLNode.xdkGetNextNode()) {
                    if (n2 == 0) {
                        return xMLNode;
                    }
                    --n2;
                }
                break;
            }
            case 4: {
                ContentManager contentManager = this.parent.getContentMgr();
                Object object = this.parent.data[2];
                contentManager.seek(object);
                Object object2 = contentManager.getFirstAttribute();
                while (object2 != null) {
                    if (n2 == 0) {
                        return this.parent.getDocument().createNodeFromAddress(object2, contentManager);
                    }
                    --n2;
                    contentManager.seek(object2);
                    object2 = contentManager.getNextSibling();
                }
                break;
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l2 = this.xdbGetNodeItemAt(this.parent.xdbGetCtx(), this.cstate, n2);
                return this.parent.xdbGetNodeFromId(l2, (short)2);
            }
        }
        return null;
    }

    @Override
    public Node getNamedItemNS(String string, String string2) {
        switch (this.flags & 7) {
            case 1: 
            case 4: {
                return this.parent.getAttributeNodeNS(string, string2);
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l2 = this.xdbGetAttributeNode(this.parent.xdbGetCtx(), this.cstate, string, string2);
                return this.parent.xdbGetNodeFromId(l2, (short)2);
            }
        }
        return null;
    }

    @Override
    public Node setNamedItemNS(Node node) throws DOMException {
        switch (this.flags & 7) {
            case 1: 
            case 4: {
                return this.parent.setAttributeNodeNS((XMLAttr)node);
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l2 = this.xdbSetAttributeNode(this.parent.xdbGetCtx(), this.cstate, ((XMLNode)node).nodeId);
                return this.parent.xdbGetNodeFromId(l2, (short)2);
            }
        }
        return null;
    }

    @Override
    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        switch (this.flags & 7) {
            case 1: {
                XMLAttr xMLAttr = (XMLAttr)this.parent.getAttributeNodeNS(string, string2);
                this.parent.checkReadOnly();
                if (xMLAttr != null) {
                    if (!this.parent.xdkSetAttributeDefault(xMLAttr)) {
                        this.parent.xdkRemoveAttr(xMLAttr);
                    }
                    xMLAttr.resetNodeFlag(65536);
                    if (this.parent.isScalable()) {
                        this.parent.xdkKeepNode();
                    }
                } else {
                    throw new XMLDOMException(8, 21011, this.parent.getXMLError());
                }
                return xMLAttr;
            }
            case 4: {
                XMLAttr xMLAttr = (XMLAttr)this.parent.getAttributeNodeNS(string, string2);
                if (xMLAttr != null) {
                    ContentManager contentManager = xMLAttr.getContentMgr();
                    Object object = xMLAttr.data[2];
                    contentManager.seek(object);
                    Object object2 = contentManager.getNextSibling();
                    Object object3 = contentManager.getPreviousSibling();
                    contentManager.setParent(0);
                    contentManager.setNextSibling(0);
                    contentManager.setPreviousSibling(0);
                    if (object3 != null) {
                        contentManager.seek(object3);
                        contentManager.setNextSibling(object2);
                    }
                    if (object2 != null) {
                        contentManager.seek(object2);
                        contentManager.setPreviousSibling(object3);
                    }
                } else {
                    throw new XMLDOMException(8, 21011, this.parent.getXMLError());
                }
                return xMLAttr;
            }
            case 2: {
                this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
                if (this.cstate == 0L) break;
                long l2 = this.xdbRemoveAttributeNode(this.parent.xdbGetCtx(), this.cstate, string, string2);
                return this.parent.xdbGetNodeFromId(l2, (short)2);
            }
        }
        return null;
    }

    XMLAttr xdbGetNextAttr(XMLAttr xMLAttr) {
        this.cstate = this.parent.xdbGetAttributes(this.parent.xdbGetCtx(), this.parent.xdbGetNodeId());
        if (this.cstate != 0L) {
            int n2 = this.xdbGetNumAttrs(this.parent.xdbGetCtx(), this.cstate);
            long l2 = 0L;
            long l3 = xMLAttr.xdbGetNodeId();
            for (int i2 = 0; i2 < n2; ++i2) {
                long l4 = this.xdbGetNodeItemAt(this.parent.xdbGetCtx(), this.cstate, i2);
                if (l2 == l3) {
                    return (XMLAttr)this.parent.xdbGetNodeFromId(l4, (short)2);
                }
                l2 = l4;
            }
        }
        return null;
    }
}

