/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.ArrayList;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLUtil;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetReader2;
import oracle.xml.scalable.PageManager;
import oracle.xml.util.ArrayPool;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLSort;
import oracle.xml.xslt.XSLTContext;
import org.w3c.dom.Node;

public class PagedNodeList {
    InfosetReader2 reader;
    PageManager pageMgr;
    XMLElement parent;
    ArrayList<XMLElement> parentList;
    ArrayList pageIds;
    int pageNo;
    int startPage;
    int nodeListLen;
    int[] idxList;
    int idxLen;
    XMLNode currentNode;
    byte[] buf;
    int bufindex;
    int bufsize;
    byte[] sortbuf1;
    byte[] sortbuf2;
    Object[] keyArray;
    int keyIndex;
    XSLSort sort;
    XSLTContext context;
    Object[] keyOffset;
    boolean addParent;
    private static final ArrayPool arrPool = new ArrayPool(65536);

    public PagedNodeList(PageManager pageManager, InfosetReader2 infosetReader2, XMLElement xMLElement) {
        this.pageMgr = pageManager;
        this.reader = infosetReader2;
        this.pageIds = new ArrayList();
        this.buf = arrPool.allocByteArr();
        this.bufindex = 0;
        this.nodeListLen = 0;
        this.startPage = 0;
        this.parent = xMLElement;
        this.parentList = null;
        this.addParent = true;
    }

    public void setSort(XSLTContext xSLTContext, XSLSort xSLSort) {
        this.sort = xSLSort;
        this.context = xSLTContext;
        this.keyIndex = 0;
        this.keyArray = new Object[this.buf.length / 8];
        this.keyOffset = new Object[this.buf.length / 8];
    }

    public void addNode(XMLNode xMLNode) {
        byte by;
        Object object = xMLNode.xdkGetOffset();
        XMLElement xMLElement = (XMLElement)xMLNode.getParentNode();
        if (this.addParent && xMLElement != this.parent) {
            if (this.parentList == null) {
                this.parentList = new ArrayList();
                this.parentList.add(this.parent);
            }
            this.parentList.add(xMLElement);
            this.parent = xMLElement;
        }
        if ((by = this.reader.offsetObjectToBytes(object, this.buf, this.bufindex + 1)) == -1) {
            this.flushPage();
            by = this.reader.offsetObjectToBytes(object, this.buf, this.bufindex + 1);
        }
        this.buf[this.bufindex] = by;
        this.bufindex += by + 1;
        ++this.nodeListLen;
    }

    public void addNode(XMLNode xMLNode, Object object) {
        int n2;
        if (this.keyIndex >= this.keyArray.length) {
            int n3;
            for (n3 = 0; n3 < this.keyIndex && (n2 = this.reader.offsetObjectToBytes(this.keyOffset[n3], this.buf, this.bufindex + 1)) != -1; ++n3) {
                this.buf[this.bufindex] = n2;
                this.bufindex += n2 + 1;
            }
            this.flushPage();
            if (n3 < this.keyIndex) {
                this.keyIndex -= n3;
                System.arraycopy(this.keyArray, n3, this.keyArray, 0, this.keyIndex);
                System.arraycopy(this.keyOffset, n3, this.keyOffset, 0, this.keyIndex);
            } else {
                this.keyIndex = 0;
            }
        }
        XMLElement xMLElement = (XMLElement)xMLNode.getParentNode();
        if (this.addParent && xMLElement != this.parent) {
            if (this.parentList == null) {
                this.parentList = new ArrayList();
                this.parentList.add(this.parent);
            }
            this.parentList.add(xMLElement);
            this.parent = xMLElement;
        }
        n2 = 0;
        int n4 = 0;
        int n5 = this.keyIndex;
        while (n4 < n5) {
            n2 = (n4 + n5) / 2;
            int n6 = this.sort.compareObjects(this.keyArray[n2], object);
            if (n6 > 0) {
                n5 = n2;
                continue;
            }
            n4 = n2 + 1;
        }
        if (n5 < this.keyIndex) {
            System.arraycopy(this.keyArray, n5, this.keyArray, n5 + 1, this.keyIndex - n5);
            System.arraycopy(this.keyOffset, n5, this.keyOffset, n5 + 1, this.keyIndex - n5);
        }
        this.keyArray[n5] = object;
        this.keyOffset[n5] = xMLNode.xdkGetOffset();
        ++this.keyIndex;
        ++this.nodeListLen;
    }

    public void finishSort() throws XSLException {
        int n2;
        this.addParent = false;
        if (this.keyIndex > 0) {
            for (int i2 = 0; i2 < this.keyIndex; ++i2) {
                n2 = this.reader.offsetObjectToBytes(this.keyOffset[i2], this.buf, this.bufindex + 1);
                if (n2 == -1) {
                    this.flushPage();
                    n2 = this.reader.offsetObjectToBytes(this.keyOffset[i2], this.buf, this.bufindex + 1);
                }
                this.buf[this.bufindex] = n2;
                this.bufindex += n2 + 1;
            }
            this.flushPage();
            this.keyIndex = 0;
        }
        this.sortbuf1 = arrPool.allocByteArr();
        this.sortbuf2 = arrPool.allocByteArr();
        this.idxLen = this.pageIds.size();
        this.idxList = new int[this.idxLen + 1];
        for (n2 = 0; n2 < this.idxLen; ++n2) {
            this.idxList[n2] = n2 + 1;
        }
        this.startPage = 0;
        this.pageSort();
        arrPool.freeByteArr(this.sortbuf1);
        arrPool.freeByteArr(this.sortbuf2);
    }

    void pageSort() throws XSLException {
        int n2 = 0;
        int n3 = this.startPage;
        this.startPage = this.pageIds.size();
        for (int i2 = 0; i2 < this.idxLen; i2 += 2) {
            int n4 = this.idxList[i2];
            int n5 = n4 - n3;
            int n6 = 0;
            if (i2 < this.idxLen - 1) {
                n6 = this.idxList[i2 + 1] - n4;
                this.sortPages(n3, n4, n5, n6);
            } else {
                while (n3 < n4) {
                    this.pageIds.add(this.pageIds.get(n3++));
                }
            }
            this.idxList[n2] = this.pageIds.size();
            ++n2;
            n3 = this.idxList[i2 + 1];
        }
        this.idxLen = n2;
        if (n2 > 1) {
            this.pageSort();
        }
    }

    void sortPages(int n2, int n3, int n4, int n5) throws XSLException {
        block11: {
            InfosetReader.Offset offset;
            byte by;
            XMLNode xMLNode;
            int n6;
            int n7;
            block10: {
                n7 = 0;
                int n8 = 0;
                n6 = 0;
                int n9 = 0;
                xMLNode = null;
                XMLNode xMLNode2 = null;
                String string = null;
                String string2 = null;
                PageManager.PageId pageId = (PageManager.PageId)this.pageIds.get(n2++);
                n6 = this.pageMgr.readPage(pageId, this.sortbuf1, 0);
                by = this.sortbuf1[n7];
                offset = this.reader.offsetFromBytes(this.sortbuf1, n7 + 1);
                this.parent = this.getParent(offset);
                xMLNode = this.parent.createChildFromOffset(offset);
                string = this.sort.getKeyValue(this.context, xMLNode);
                --n4;
                pageId = (PageManager.PageId)this.pageIds.get(n3++);
                n9 = this.pageMgr.readPage(pageId, this.sortbuf2, 0);
                byte by2 = this.sortbuf2[n8];
                offset = this.reader.offsetFromBytes(this.sortbuf2, n8 + 1);
                this.parent = this.getParent(offset);
                xMLNode2 = this.parent.createChildFromOffset(offset);
                string2 = this.sort.getKeyValue(this.context, xMLNode2);
                --n5;
                while (true) {
                    if (this.sort.compareObjects(string, string2) <= 0) {
                        this.addNode(xMLNode);
                        if ((n7 += by + 1) >= n6) {
                            if (n4 == 0) {
                                n4 = -1;
                                break;
                            }
                            pageId = (PageManager.PageId)this.pageIds.get(n2++);
                            n6 = this.pageMgr.readPage(pageId, this.sortbuf1, 0);
                            n7 = 0;
                            --n4;
                        }
                        by = this.sortbuf1[n7];
                        offset = this.reader.offsetFromBytes(this.sortbuf1, n7 + 1);
                        this.parent = this.getParent(offset);
                        xMLNode = this.parent.createChildFromOffset(offset);
                        string = this.sort.getKeyValue(this.context, xMLNode);
                        continue;
                    }
                    this.addNode(xMLNode2);
                    if ((n8 += by2 + 1) >= n9) {
                        if (n5 == 0) {
                            n5 = -1;
                            break;
                        }
                        pageId = (PageManager.PageId)this.pageIds.get(n3++);
                        n9 = this.pageMgr.readPage(pageId, this.sortbuf2, 0);
                        n8 = 0;
                        --n5;
                    }
                    by2 = this.sortbuf2[n8];
                    offset = this.reader.offsetFromBytes(this.sortbuf2, n8 + 1);
                    this.parent = this.getParent(offset);
                    xMLNode2 = this.parent.createChildFromOffset(offset);
                    string2 = this.sort.getKeyValue(this.context, xMLNode2);
                }
                if (n4 != -1) break block10;
                while (true) {
                    this.addNode(xMLNode2);
                    if ((n8 += by2 + 1) >= n9) break;
                    by2 = this.sortbuf2[n8];
                    offset = this.reader.offsetFromBytes(this.sortbuf2, n8 + 1);
                    this.parent = this.getParent(offset);
                    xMLNode2 = this.parent.createChildFromOffset(offset);
                }
                this.flushPage();
                for (int i2 = n5; i2 > 0; --i2) {
                    this.pageIds.add(this.pageIds.get(n3));
                    ++n3;
                }
                break block11;
            }
            if (n5 != -1) break block11;
            while (true) {
                this.addNode(xMLNode);
                if ((n7 += by + 1) >= n6) break;
                by = this.sortbuf1[n7];
                offset = this.reader.offsetFromBytes(this.sortbuf1, n7 + 1);
                this.parent = this.getParent(offset);
                xMLNode = this.parent.createChildFromOffset(offset);
            }
            this.flushPage();
            for (int i3 = n4; i3 > 0; --i3) {
                this.pageIds.add(this.pageIds.get(n2));
                ++n2;
            }
        }
    }

    public void flushPage() {
        if (this.bufindex != 0) {
            PageManager.PageId pageId = this.pageMgr.writePage(this.buf, 0, this.bufindex);
            this.pageIds.add(pageId);
            this.bufindex = 0;
        }
    }

    public void start() {
        this.pageNo = this.startPage;
        this.readPage();
    }

    public void reset() {
        this.pageIds = null;
        arrPool.freeByteArr(this.buf);
    }

    void readPage() {
        PageManager.PageId pageId = (PageManager.PageId)this.pageIds.get(this.pageNo);
        this.bufsize = this.pageMgr.readPage(pageId, this.buf, 0);
        this.bufindex = 0;
    }

    private XMLElement getParent(Object object) {
        if (this.parentList == null) {
            return this.parent;
        }
        int n2 = this.parentList.size();
        int n3 = 0;
        int n4 = n2 / 2;
        XMLElement xMLElement = null;
        while (n4 != n3) {
            xMLElement = this.parentList.get(n4);
            Object object2 = xMLElement.xdkGetOffset();
            int n5 = 0;
            if (object instanceof InfosetReader.Offset) {
                n5 = ((InfosetReader.Offset)object).compareTo((InfosetReader.Offset)object2);
            } else if (object instanceof Node) {
                n5 = XMLUtil.compareDocOrder((Node)object, (Node)object2);
            }
            if (n5 > 0) {
                n3 = n4;
                n4 += (n2 - n3) / 2;
                continue;
            }
            n2 = n4;
            n4 = n3 + (n2 - n3) / 2;
        }
        return this.parentList.get(n4);
    }

    public boolean next() {
        if (this.bufindex >= this.bufsize) {
            ++this.pageNo;
            if (this.pageNo >= this.pageIds.size()) {
                this.currentNode = null;
                return false;
            }
            this.readPage();
        }
        byte by = this.buf[this.bufindex++];
        InfosetReader.Offset offset = this.reader.offsetFromBytes(this.buf, this.bufindex);
        this.bufindex += by;
        this.currentNode = this.getParent(offset).createChildFromOffset(offset);
        return true;
    }

    public XMLNode getNode() {
        return this.currentNode;
    }

    public int getLength() {
        return this.nodeListLen;
    }
}

