/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLException;

public class XSDIdentity
extends XSDNode {
    String refer;
    String selector;
    String expandedName;
    String[] fields;
    int nfields;
    XSLExprBase[] fieldExprs;
    XSLExprBase selectorExpr;

    XSDIdentity() {
        this.init();
    }

    private void init() {
        this.nodeType = 22;
        this.fields = new String[10];
        this.nfields = 0;
    }

    void setExpandedName(String string) {
        this.expandedName = string;
    }

    String getExpandedName() {
        if (this.expandedName == null) {
            this.expandedName = this.getTargetNS() + ":" + this.name;
        }
        return this.expandedName;
    }

    XSLExprBase getFieldExpr(int n2) {
        return this.fieldExprs[n2];
    }

    XSLExprBase getSelectorExpr() {
        return this.selectorExpr;
    }

    boolean compileExpr(XMLElement xMLElement) {
        try {
            this.selectorExpr = XSLExprBase.createExpression(this.selector, (NSResolver)xMLElement, null);
            this.fieldExprs = new XSLExprBase[this.nfields];
            for (int i2 = 0; i2 < this.nfields; ++i2) {
                this.fieldExprs[i2] = XSLExprBase.createExpression(this.fields[i2], (NSResolver)xMLElement, null);
            }
        }
        catch (XSLException xSLException) {
            return false;
        }
        catch (XQException xQException) {
            return false;
        }
        return true;
    }

    void setNodeType(int n2) {
        this.nodeType = n2;
    }

    void setRefer(String string) {
        this.refer = string;
    }

    void setSelector(String string) {
        this.selector = string;
    }

    void addField(String string) {
        if (string == null) {
            return;
        }
        if (this.nfields >= this.fields.length) {
            String[] stringArray = new String[this.fields.length + 10];
            System.arraycopy(this.fields, 0, stringArray, 0, this.fields.length);
            this.fields = stringArray;
        }
        this.fields[this.nfields++] = string;
    }

    @Override
    public int getNodeType() {
        return this.nodeType;
    }

    public String getRefer() {
        return this.refer;
    }

    public String getSelector() {
        return this.selector;
    }

    public String[] getFields() {
        return this.fields;
    }

    int getnFields() {
        return this.nfields;
    }

    @Override
    void print(int n2) {
        this.printSTag(n2);
        if (this.refer != null) {
            System.out.println(XSDIdentity.indent(n2) + "refer =" + this.refer);
        }
        if (this.selector != null) {
            System.out.println(XSDIdentity.indent(n2) + "selector =" + this.selector);
        }
        for (int i2 = 0; i2 < this.nfields; ++i2) {
            System.out.println(XSDIdentity.indent(n2) + "field  =" + this.fields[i2]);
        }
        this.printSTagEnd(n2);
        this.printETag(n2);
    }
}

