/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.schema;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSchemaDefaults;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.util.FastVector;

public class XSDComplexType
extends XSDNode {
    private XSDSchemaDefaults defaults;
    XSDGroup group;
    XSDGroup typeGroup;
    XSDAttrGroup attrGroup;
    XSDSimpleType simpleType;
    BitSet properties;
    boolean simpleContent;
    int content;
    String derivedBy;
    String refNamespace;
    String refLocalname;
    String includingNS;
    XSDNode base;
    int refState;
    boolean parsed;
    static XSDComplexType urType;
    static BitSet BlockAll;
    static BitSet FinalAll;
    static BitSet BFNONE;

    public static XSDComplexType getUrType() {
        return urType;
    }

    public static void init() throws XSDException {
    }

    XSDComplexType() {
        this.nodeType = 1;
        this.base = null;
        this.derivedBy = "#undef";
        this.refState = 6;
        this.content = 21;
        this.attrGroup = new XSDAttrGroup(6);
        this.attrGroup.parent = this;
        this.properties = new BitSet(8);
        this.parsed = true;
    }

    void setSchemaDefaults(XSDSchemaDefaults xSDSchemaDefaults) {
        this.defaults = xSDSchemaDefaults;
    }

    XSDSchemaDefaults getSchemaDefaults() {
        return this.defaults;
    }

    void initTypeGroup(int n2) {
        this.typeGroup = new XSDGroup();
        this.typeGroup.order = n2;
        if (n2 == 0) {
            this.typeGroup.minOccurs = 1;
            this.typeGroup.maxOccurs = 1;
        } else if (n2 == 1) {
            this.typeGroup.minOccurs = 0;
            this.typeGroup.maxOccurs = 0x7FFFFFF8;
        }
        this.typeGroup.parent = this;
    }

    void setTypeGroup(XSDGroup xSDGroup) {
        this.typeGroup = xSDGroup;
        this.typeGroup.parent = this;
    }

    public XSDSimpleType getSimpleType() {
        return this.simpleType;
    }

    @Override
    public XSDNode getNamedBaseType() {
        if (this.name != null || this == urType) {
            return this;
        }
        if (this.base != null) {
            return this.base.getNamedBaseType();
        }
        return null;
    }

    @Override
    int postProcess(FastVector fastVector, Hashtable hashtable, XMLSchema xMLSchema) throws Exception {
        if (this == urType) {
            return 0;
        }
        if (this.group == null) {
            this.group = new XSDGroup();
            this.group.topGroup = true;
            this.group.parent = this;
            this.group.order = 0;
            this.group.minOccurs = 1;
            this.group.maxOccurs = 1;
            if (this.typeGroup == null) {
                if (this.simpleType != null) {
                    this.simpleType.parseDerivation(xMLSchema);
                    this.group.nodeVector.add(this.simpleType);
                    this.group.vectorSize = this.group.nodeVector.size();
                }
            } else {
                this.group.addParticleNode(this.typeGroup);
            }
        }
        this.resolveAttrGroup(xMLSchema);
        if (this.derivedBy == "restriction" && this.base != null && !this.isValidRestriction((XSDComplexType)this.base)) {
            throw new XSDException(24226, this.base.name, this.domNode);
        }
        this.group.postProcess(fastVector, hashtable, xMLSchema);
        return 0;
    }

    @Override
    int getSQLTableSize(int n2) {
        if (this.contentSize > 0) {
            return this.contentSize;
        }
        if (this.contentSize < 0) {
            return 1;
        }
        this.contentSize = -1;
        XMLElement xMLElement = this.domNode;
        XSDNode xSDNode = null;
        if (this.isTopLevel()) {
            this.inUsed = true;
            xSDNode = this.getBaseType();
            if (xSDNode.isTopLevel() && xSDNode instanceof XSDComplexType) {
                xSDNode.getSQLTableSize(n2);
            }
        }
        int n3 = this.attrGroup.getVectorSize();
        if (this.simpleContent) {
            ++n3;
        } else if (this.group != null && this.group.elemList != null) {
            int n4;
            FastVector fastVector = this.group.elemList;
            int n5 = fastVector.size();
            XSDNode[] xSDNodeArray = new XSDNode[n5];
            int n6 = 0;
            int n7 = -1;
            for (n4 = 0; n4 < n5; ++n4) {
                xSDNodeArray[n4] = (XSDNode)fastVector.elementAt(n4);
                if (xSDNodeArray[n4] instanceof XSDElement) {
                    String string;
                    XSDNode xSDNode2;
                    XSDElement xSDElement = (XSDElement)xSDNodeArray[n4];
                    XSDNode[] xSDNodeArray2 = xSDElement.getChildElements();
                    XMLSchema xMLSchema = this.getOwnerSchema();
                    if (xSDElement.refState == 0) {
                        xSDNode2 = (XSDElement)xMLSchema.getComponent(xSDElement.refNamespace, xSDElement.refLocalname, 3);
                        ((XSDElement)xSDNode2).inUsed = true;
                        int n8 = xSDElement.getContent();
                        if (xMLSchema.annoFlag >= 2 && n8 != 11 && n8 != 10) {
                            xMLElement = ((XSDElement)xSDNode2).domNode;
                            XMLDocument xMLDocument = (XMLDocument)xMLElement.getOwnerDocument();
                            string = xMLElement.getAttributeNS("http://xmlns.oracle.com/xdb", "defaultTable");
                            if (string == null || string.equals("")) {
                                string = xMLSchema.newTableName(xSDElement.refLocalname) + "_TAB";
                                xMLElement.setAttributeNS("http://xmlns.oracle.com/xdb", "xdb:defaultTable", string);
                            }
                            xMLElement = xSDElement.domNode;
                            if (xMLSchema.annoFlag >= 4 || xMLElement.getOwnerDocument() == xMLDocument) {
                                xMLElement.setAttributeNS("http://xmlns.oracle.com/xdb", "xdb:SQLInline", "false");
                                xMLElement.setAttributeNS("http://xmlns.oracle.com/xdb", "xdb:defaultTable", string);
                                xSDElement.contentSize = 1;
                            }
                        }
                    } else if (xSDElement.isTopLevel()) {
                        xSDElement.inUsed = true;
                        xMLElement = xSDElement.domNode;
                        string = xMLElement.getAttributeNS("http://xmlns.oracle.com/xdb", "defaultTable");
                        if (string == null || string.equals("")) {
                            string = xMLSchema.newTableName(xSDElement.getName()) + "_TAB";
                            xMLElement.setAttributeNS("http://xmlns.oracle.com/xdb", "xdb:defaultTable", string);
                        }
                    }
                    xSDNode2 = xSDElement.getType();
                    if (xSDNode2 instanceof XSDComplexType && xSDNode2 != urType && xSDNode2.isTopLevel()) {
                        xSDNode2.getSQLTableSize(n2);
                    }
                }
                int n9 = xSDNodeArray[n4].getSQLTableSize(n2);
                n3 += n9;
                if (n9 <= n6) continue;
                n6 = n9;
                n7 = n4;
            }
            while (n3 > n2) {
                xMLElement = xSDNodeArray[n7].domNode;
                if (xMLElement != null) {
                    xMLElement.setAttributeNS("http://xmlns.oracle.com/xdb", "xdb:SQLInline", "false");
                    xSDNodeArray[n7].contentSize = 1;
                }
                xSDNodeArray[n7] = null;
                n3 -= n6;
                ++n3;
                n6 = 0;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (xSDNodeArray[n4] == null || xSDNodeArray[n4].getSQLTableSize(n2) <= n6) continue;
                    n7 = n4;
                    n6 = xSDNodeArray[n4].getSQLTableSize(n2);
                }
            }
        }
        this.contentSize = n3;
        return this.contentSize;
    }

    boolean isValidRestriction(XSDComplexType xSDComplexType) {
        if (xSDComplexType == urType) {
            return true;
        }
        if (!this.attrGroup.isValidRestriction(xSDComplexType.attrGroup)) {
            return false;
        }
        if (this.simpleContent && xSDComplexType.simpleContent) {
            return this.simpleType.isDerivedFrom(xSDComplexType.simpleType, BFNONE);
        }
        if (this.content == 10 && !xSDComplexType.isEmptiable()) {
            return false;
        }
        return this.content != 13 || xSDComplexType.content == 13;
    }

    public XSDGroup getGroup() {
        return this.group;
    }

    public XSDNode[] getChildElements() {
        FastVector fastVector = this.group.elemList;
        if (fastVector == null) {
            return null;
        }
        int n2 = fastVector.size();
        XSDNode[] xSDNodeArray = new XSDNode[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            xSDNodeArray[i2] = (XSDNode)fastVector.elementAt(i2);
        }
        return xSDNodeArray;
    }

    void resolveAttrGroup(XMLSchema xMLSchema) throws XSDException {
        this.attrGroup.resolveGroup(xMLSchema);
    }

    public XSDGroup getTypeGroup() {
        return this.typeGroup;
    }

    XSDAttrGroup getAttrGroup() {
        return this.attrGroup;
    }

    void setBaseRef(String string, String string2) {
        this.refLocalname = string2;
        this.refNamespace = string;
        this.refState = 7;
    }

    void setBaseType(XSDNode xSDNode) {
        this.base = xSDNode;
        this.refState = 6;
    }

    public XSDNode getBaseType() {
        return this.base;
    }

    @Override
    public String getRefLocalname() {
        return this.refLocalname;
    }

    void setDerivedBy(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 != "restriction" && string2 != "extension") {
            throw new XSDException();
        }
        this.derivedBy = string2;
        this.attrGroup.restriction = string2 == "restriction";
    }

    void setContent(String string) throws XSDException {
        String string2 = string.intern();
        if (string2 == "textOnly") {
            this.content = 11;
        } else if (string2 == "mixed") {
            this.content = 13;
        } else if (string2 == "elementOnly") {
            this.content = 12;
        } else if (string2 == "empty") {
            this.content = 10;
        } else {
            throw new XSDException();
        }
    }

    void setMixedContent(boolean bl) {
        this.content = bl ? 13 : 12;
    }

    public int getContent() {
        return this.content;
    }

    @Override
    BitSet getProperties() {
        return this.properties;
    }

    void setAbstract(boolean bl) {
        if (bl) {
            this.properties.set(7);
        }
    }

    void setSimpleContent(boolean bl) {
        this.simpleContent = bl;
    }

    @Override
    boolean isParsed() {
        return this.parsed;
    }

    public boolean isAbstract() {
        return this.properties.get(7);
    }

    public boolean isSimpleContent() {
        return this.simpleContent;
    }

    boolean isEmptiable() {
        if (this.simpleContent) {
            return true;
        }
        if (this.content == 10) {
            return true;
        }
        if (this.typeGroup != null) {
            return this.typeGroup.isEmptiable();
        }
        return true;
    }

    public XSDNode[] getElementSet() {
        if (this.typeGroup != null) {
            Vector vector = this.typeGroup.getNodeVector();
            Object[] objectArray = new XSDNode[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public XSDNode[] getBaseElementSet() {
        if (this.base != null && this.base instanceof XSDComplexType) {
            Vector vector = ((XSDComplexType)this.base).getTypeGroup().getNodeVector();
            Object[] objectArray = new XSDNode[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public XSDNode[] getAttributeSet() {
        int n2 = this.attrGroup.length();
        if (this.attrGroup.wildcard != null) {
            ++n2;
        }
        XSDNode[] xSDNodeArray = new XSDNode[n2];
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                xSDNodeArray[i2] = new XSDElement((XSDAttribute)this.attrGroup.item(i2));
            }
            xSDNodeArray[n2 - 1] = this.attrGroup.wildcard != null ? this.attrGroup.wildcard : new XSDElement((XSDAttribute)this.attrGroup.item(n2 - 1));
        }
        return xSDNodeArray;
    }

    public XSDAttribute[] getAttributeDeclarations() {
        int n2 = this.attrGroup.length();
        XSDAttribute[] xSDAttributeArray = new XSDAttribute[n2];
        System.arraycopy(this.attrGroup.nodeVector, 0, xSDAttributeArray, 0, n2);
        return xSDAttributeArray;
    }

    public XSDAttribute getAttributeDeclaration(String string, String string2) {
        if (string == null) {
            string = "";
        }
        return this.attrGroup.getAttributeDeclaration(string, string2);
    }

    public XSDAny getAttributeWildcard() {
        return this.attrGroup.wildcard;
    }

    public XSDNode[] getBaseAttributeSet() {
        if (this.base == this) {
            return null;
        }
        if (this.base != null && this.base instanceof XSDComplexType) {
            return ((XSDComplexType)this.base).getAttributeSet();
        }
        return null;
    }

    public short getDerivationMethod() {
        if (this.derivedBy == "restriction") {
            return 2;
        }
        if (this.derivedBy == "extension") {
            return 1;
        }
        return 0;
    }

    public String getDerivedMethod() {
        return this.derivedBy;
    }

    public boolean isUrType() {
        return this == urType;
    }

    @Override
    boolean isDerivedFrom(XSDNode xSDNode, BitSet bitSet) {
        boolean bl = false;
        boolean bl2 = false;
        XSDComplexType xSDComplexType = this;
        while (xSDComplexType != null) {
            if (xSDComplexType == xSDNode) {
                return !(bl && bitSet.get(2) || bl2 && bitSet.get(1));
            }
            XSDNode xSDNode2 = xSDComplexType.getBaseType();
            if (xSDNode2 instanceof XSDSimpleType) {
                return ((XSDSimpleType)xSDNode2).isDerivedFrom(xSDNode, bitSet);
            }
            if (this.derivedBy == "restriction") {
                bl = true;
            }
            if (this.derivedBy == "extension") {
                bl2 = true;
            }
            if (xSDNode2 == null || xSDComplexType == xSDNode2) break;
            xSDComplexType = (XSDComplexType)xSDNode2;
            bitSet.or(xSDComplexType.getProperties());
        }
        return false;
    }

    @Override
    boolean isSubstitutableFor(XSDNode xSDNode, boolean bl, boolean bl2) {
        if (this == xSDNode) {
            return true;
        }
        if (bl && this.derivedBy == "restriction") {
            return false;
        }
        if (bl2 && this.derivedBy == "extension") {
            return false;
        }
        if (this.base == null || this == urType) {
            return false;
        }
        return this.base.isSubstitutableFor(xSDNode, bl, bl2);
    }

    String getBlockString() {
        if (this.properties.get(1)) {
            if (this.properties.get(2)) {
                return "#all";
            }
            return "extension";
        }
        if (this.properties.get(2)) {
            return "restriction";
        }
        return "";
    }

    String getFinalString() {
        if (this.properties.get(3)) {
            if (this.properties.get(4)) {
                return "extension restriction";
            }
            return "extension";
        }
        if (this.properties.get(4)) {
            return "restriction";
        }
        return "";
    }

    @Override
    void print(int n2) {
        String string;
        this.printSTag(n2);
        if (this.isAbstract()) {
            System.out.println(XSDComplexType.indent(n2) + "abstract = true");
        } else {
            System.out.println(XSDComplexType.indent(n2) + "abstract = false");
        }
        switch (this.content) {
            case 12: {
                System.out.println(XSDComplexType.indent(n2) + "content = " + "elementOnly");
                break;
            }
            case 13: {
                System.out.println(XSDComplexType.indent(n2) + "content = " + "mixed");
                break;
            }
            case 10: {
                System.out.println(XSDComplexType.indent(n2) + "content = " + "empty");
                break;
            }
            case 11: {
                System.out.println(XSDComplexType.indent(n2) + "content = " + "textOnly");
                break;
            }
        }
        if (this.derivedBy != "#undef") {
            System.out.println(XSDComplexType.indent(n2) + "derivedBy = " + this.derivedBy);
        }
        if (!(string = this.getBlockString()).equals("")) {
            System.out.println(XSDComplexType.indent(n2) + "block =" + string);
        }
        if (!(string = this.getFinalString()).equals("")) {
            System.out.println(XSDComplexType.indent(n2) + "final =" + string);
        }
        if (this.refLocalname != null) {
            System.out.print(XSDComplexType.indent(n2) + "ref = " + this.refNamespace);
            System.out.println(":" + this.refLocalname);
        }
        this.printSTagEnd(n2);
        super.printAnnotation();
        if (this.attrGroup != null) {
            this.attrGroup.print(n2 + 3);
        }
        if (this.typeGroup != null) {
            this.typeGroup.print(n2 + 3);
        }
        if (this.simpleType != null) {
            this.simpleType.print(n2 + 3);
        }
        this.printETag(n2);
    }

    static {
        try {
            XSDComplexType xSDComplexType = new XSDComplexType();
            xSDComplexType.initTypeGroup(0);
            xSDComplexType.name = "anyType";
            xSDComplexType.targetNS = "http://www.w3.org/2001/XMLSchema";
            XSDAny xSDAny = new XSDAny();
            xSDAny.setMaxOccurs(0x7FFFFFF8);
            xSDAny.setMinOccurs(0);
            xSDAny.setProcessContents("lax");
            xSDComplexType.typeGroup.addParticleNode(xSDAny);
            xSDAny = new XSDAny(7);
            xSDAny.setProcessContents("lax");
            xSDComplexType.attrGroup.setWildcard(xSDAny);
            xSDComplexType.setContent("mixed");
            xSDComplexType.postProcess(new FastVector(4), new Hashtable(10), null);
            xSDComplexType.group.buildPathTable(null, null, 0);
            xSDComplexType.defaults = null;
            urType = xSDComplexType;
            BlockAll = new BitSet(8);
            FinalAll = new BitSet(8);
            BFNONE = new BitSet(8);
            BlockAll.set(0);
            BlockAll.set(1);
            BlockAll.set(2);
            FinalAll.set(3);
            FinalAll.set(4);
            FinalAll.set(5);
            FinalAll.set(6);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

