/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPDebugger;
import oracle.xml.jdwp.XSLJDWPPacket;

class XSLJDWPSocketConn
implements XSLJDWPConstants {
    Object receiveLock = new Object();
    Object sendLock = new Object();
    Socket socket;
    BufferedInputStream socketIn;
    BufferedOutputStream socketOut;

    XSLJDWPSocketConn(Socket socket) throws IOException {
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
        this.socket.setSoTimeout(300);
        this.socketIn = new BufferedInputStream(this.socket.getInputStream());
        this.socketOut = new BufferedOutputStream(this.socket.getOutputStream());
    }

    void close() throws IOException {
        this.socketOut.flush();
        this.socketOut.close();
        this.socketIn.close();
        this.socket.close();
    }

    String receiveHandshake() throws IOException, InterruptedException {
        int n2 = "JDWP-Handshake".length();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.socketIn.read(byArray, i2, 1);
        }
        return new String(byArray, "US-ASCII");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XSLJDWPPacket receivePacket(boolean bl) throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            int n2;
            XSLJDWPPacket xSLJDWPPacket = new XSLJDWPPacket();
            int n3 = this.socketIn.read();
            int n4 = this.socketIn.read();
            int n5 = this.socketIn.read();
            int n6 = this.socketIn.read();
            if (n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0) {
                throw new EOFException();
            }
            int n7 = (n3 << 24) + (n4 << 16) + (n5 << 8) + n6;
            n3 = this.socketIn.read();
            n4 = this.socketIn.read();
            n5 = this.socketIn.read();
            n6 = this.socketIn.read();
            if (n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0) {
                throw new EOFException();
            }
            xSLJDWPPacket.id = (n3 << 24) + (n4 << 16) + (n5 << 8) + n6;
            xSLJDWPPacket.flags = (short)this.socketIn.read();
            if (xSLJDWPPacket.flags < 0) {
                throw new EOFException();
            }
            if ((xSLJDWPPacket.flags & 0x80) == 0) {
                xSLJDWPPacket.cmdSet = (short)this.socketIn.read();
                xSLJDWPPacket.cmd = (short)this.socketIn.read();
                if (xSLJDWPPacket.cmdSet < 0 || xSLJDWPPacket.cmd < 0) {
                    throw new EOFException();
                }
            } else {
                n3 = this.socketIn.read();
                n4 = this.socketIn.read();
                if (n3 < 0 || n4 < 0) {
                    throw new EOFException();
                }
                xSLJDWPPacket.errorCode = (short)((n3 << 8) + n4);
            }
            if ((n7 -= 11) < 0) {
                System.err.println(new StringBuffer("length is ").append(n7).toString());
                System.err.println(new StringBuffer("Read is ").append(this.socketIn.read()).toString());
            }
            xSLJDWPPacket.data = new byte[n7];
            for (int i2 = 0; i2 < xSLJDWPPacket.data.length; i2 += n2) {
                n2 = this.socketIn.read(xSLJDWPPacket.data, i2, xSLJDWPPacket.data.length - i2);
                if (n2 >= 0) continue;
                throw new EOFException();
            }
            if (bl) {
                XSLJDWPDebugger.dumpPacket(xSLJDWPPacket, false);
            }
            return xSLJDWPPacket;
        }
    }

    void sendHandshake() throws IOException {
        this.socketOut.write("JDWP-Handshake".getBytes(), 0, "JDWP-Handshake".length());
        this.socketOut.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(XSLJDWPPacket xSLJDWPPacket, boolean bl) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            if (bl) {
                XSLJDWPDebugger.dumpPacket(xSLJDWPPacket, true);
            }
            int n2 = xSLJDWPPacket.data.length + 11;
            this.socketOut.write(n2 >>> 24 & 0xFF);
            this.socketOut.write(n2 >>> 16 & 0xFF);
            this.socketOut.write(n2 >>> 8 & 0xFF);
            this.socketOut.write(n2 & 0xFF);
            this.socketOut.write(xSLJDWPPacket.id >>> 24 & 0xFF);
            this.socketOut.write(xSLJDWPPacket.id >>> 16 & 0xFF);
            this.socketOut.write(xSLJDWPPacket.id >>> 8 & 0xFF);
            this.socketOut.write(xSLJDWPPacket.id & 0xFF);
            this.socketOut.write(xSLJDWPPacket.flags);
            if ((xSLJDWPPacket.flags & 0x80) == 0) {
                this.socketOut.write(xSLJDWPPacket.cmdSet);
                this.socketOut.write(xSLJDWPPacket.cmd);
            } else {
                this.socketOut.write(xSLJDWPPacket.errorCode >>> 8 & 0xFF);
                this.socketOut.write(xSLJDWPPacket.errorCode & 0xFF);
            }
            this.socketOut.write(xSLJDWPPacket.data);
            this.socketOut.flush();
        }
    }
}

