/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.util.Hashtable;
import oracle.xml.jdwp.LineTable;
import oracle.xml.jdwp.VariableTable;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;

public class XSLJDWPMethod
extends XSLJDWPCommandSet {
    Hashtable variableTables = new Hashtable();
    Hashtable lineTables = new Hashtable();

    @Override
    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.cmd.cmd) {
            case 1: {
                xSLJDWPPacket2 = this.lineTableCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.variableTableCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    XSLJDWPPacket lineTableCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        LineTable lineTable = this.getLineTable(this.cmdStrm.readReferenceType(), this.cmdStrm.readMethodID());
        xSLJDWPPacketStream.writeLong(lineTable.getStart());
        xSLJDWPPacketStream.writeLong(lineTable.getEnd());
        int n2 = lineTable.getLines();
        xSLJDWPPacketStream.writeInt(n2);
        long[] lArray = lineTable.getLineCodeIndex();
        int[] nArray = lineTable.getLineNumber();
        for (int i2 = 0; i2 < n2; ++i2) {
            xSLJDWPPacketStream.writeLong(lArray[i2]);
            xSLJDWPPacketStream.writeInt(nArray[i2]);
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket variableTableCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            VariableTable variableTable = this.getVariableTable(this.cmdStrm.readReferenceType(), this.cmdStrm.readMethodID());
            xSLJDWPPacketStream.writeInt(variableTable.getArgCnt());
            int n2 = variableTable.getSlots();
            xSLJDWPPacketStream.writeInt(n2);
            long[] lArray = variableTable.getCodeIndex();
            String[] stringArray = variableTable.getName();
            String[] stringArray2 = variableTable.getSignature();
            int[] nArray = variableTable.getLength();
            int[] nArray2 = variableTable.getSlot();
            for (int i2 = 0; i2 < n2; ++i2) {
                xSLJDWPPacketStream.writeLong(lArray[i2]);
                xSLJDWPPacketStream.writeString(stringArray[i2]);
                xSLJDWPPacketStream.writeString(stringArray2[i2]);
                xSLJDWPPacketStream.writeInt(nArray[i2]);
                xSLJDWPPacketStream.writeInt(nArray2[i2]);
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    public synchronized void makeLineTable(LineTable lineTable) {
        int n2 = lineTable.getClassID();
        int n3 = lineTable.getMethodID();
        long l2 = (long)n2 << 32;
        Long l3 = new Long(l2 += (long)n3);
        this.lineTables.put(l3, lineTable);
    }

    LineTable getLineTable(int n2, int n3) {
        long l2 = (long)n2 << 32;
        Long l3 = new Long(l2 += (long)n3);
        LineTable lineTable = (LineTable)this.lineTables.get(l3);
        return lineTable;
    }

    public synchronized void makeVariableTable(VariableTable variableTable) {
        int n2 = variableTable.getClassID();
        int n3 = variableTable.getMethodID();
        long l2 = (long)n2 << 32;
        Long l3 = new Long(l2 += (long)n3);
        this.variableTables.put(l3, variableTable);
    }

    VariableTable getVariableTable(int n2, int n3) {
        long l2 = (long)n2 << 32;
        Long l3 = new Long(l2 += (long)n3);
        VariableTable variableTable = (VariableTable)this.variableTables.get(l3);
        if (variableTable != null) {
            variableTable.setSignaturesAndArgCnt();
        }
        return variableTable;
    }

    void clearVariableTable() {
        this.variableTables.clear();
    }
}

