/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPObjectReference;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPPacketValue;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLNodeList;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.datamodel.OXMLSequence;

class XSLJDWPArrayReference
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    XSLJDWPObjectReference or;

    XSLJDWPArrayReference(XSLJDWPObjectReference xSLJDWPObjectReference) {
        this.or = xSLJDWPObjectReference;
    }

    @Override
    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.getCommand()) {
            case 1: {
                xSLJDWPPacket2 = this.lengthCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.getValuesCmd();
                break;
            }
            case 3: {
                xSLJDWPPacket2 = this.setValuesCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    XSLJDWPPacket lengthCmd() {
        int n2 = this.cmdStrm.readArrayID();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(this.generateLengthData(n2));
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket setValuesCmd() {
        int n2 = this.cmdStrm.readArrayID();
        int n3 = this.cmdStrm.readInt();
        int n4 = this.cmdStrm.readInt();
        Integer n5 = new Integer(n2);
        Object v2 = this.or.getIds2Objs().get(n5);
        String string = XSLJDWPUtil.toString(v2);
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2;
            cArray[i2 + n3] = c2 = this.cmdStrm.readChar();
        }
        String string2 = new String(cArray);
        XPathSequence.setStringValue((OXMLSequence)v2, string2);
        this.or.getIds2Objs().put(n5, v2);
        this.or.getObjs2Ids().put(v2, n5);
        return this.cmd.createReply();
    }

    XSLJDWPPacket getValuesCmd() {
        int n2 = this.cmdStrm.readArrayID();
        int n3 = this.cmdStrm.readInt();
        int n4 = this.cmdStrm.readInt();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            XSLJDWPPacketValue[] xSLJDWPPacketValueArray = this.generateGetValuesData(n2, n3, n4);
            XSLJDWPObjectReference xSLJDWPObjectReference = this.jdwpvm.xsl.getJDWPObjectReference();
            xSLJDWPObjectReference.generateArrayElementData(xSLJDWPPacketValueArray);
            if (xSLJDWPPacketValueArray.length > 0) {
                if (xSLJDWPPacketValueArray[0].getType() == 67) {
                    xSLJDWPPacketStream.writeArrayRegion((byte)67, xSLJDWPPacketValueArray);
                } else {
                    xSLJDWPPacketStream.writeArrayRegion((byte)76, xSLJDWPPacketValueArray);
                }
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    private int generateLengthData(int n2) {
        byte by = (byte)(n2 >> 24);
        int n3 = 0;
        if (by == 6) {
            String string = null;
            string = XSLJDWPUtil.toString(this.or.getIds2Objs().get(new Integer(n2)));
            if (string != null) {
                n3 = string.length();
            }
        } else {
            XMLNodeList xMLNodeList = null;
            xMLNodeList = (XMLNodeList)this.or.getIds2Objs().get(new Integer(n2));
            if (xMLNodeList != null) {
                xMLNodeList.setDebugFlag();
                n3 = xMLNodeList.getLength();
            }
        }
        return n3;
    }

    private XSLJDWPPacketValue[] generateGetValuesData(int n2, int n3, int n4) {
        byte by = (byte)(n2 >> 24);
        if (by == 6) {
            String string = null;
            string = XSLJDWPUtil.toString(this.or.getIds2Objs().get(new Integer(n2)));
            if (string == null) {
                return new XSLJDWPPacketValue[0];
            }
            int n5 = string.length();
            int n6 = 0;
            if (n4 > 0) {
                n6 = n3 + n4;
            }
            if (n6 > n5) {
                n6 = n5;
            }
            XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n6 - n3];
            for (int i2 = n3; i2 < n6; ++i2) {
                XSLJDWPPacketValue xSLJDWPPacketValue;
                char c2 = string.charAt(i2);
                xSLJDWPPacketValueArray[i2 - n3] = xSLJDWPPacketValue = new XSLJDWPPacketValue(67, new Character(c2));
            }
            return xSLJDWPPacketValueArray;
        }
        XMLNodeList xMLNodeList = null;
        xMLNodeList = (XMLNodeList)this.or.getIds2Objs().get(new Integer(n2));
        if (xMLNodeList == null) {
            return new XSLJDWPPacketValue[0];
        }
        int n7 = xMLNodeList.getLength();
        int n8 = 0;
        if (n4 > 0) {
            n8 = n3 + n4;
        }
        if (n8 > n7) {
            n8 = n7;
        }
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n8 - n3];
        for (int i3 = n3; i3 < n8; ++i3) {
            XSLJDWPPacketValue xSLJDWPPacketValue;
            XMLNode xMLNode = (XMLNode)xMLNodeList.item(i3);
            xSLJDWPPacketValueArray[i3 - n3] = xSLJDWPPacketValue = new XSLJDWPPacketValue(76, xMLNode);
        }
        return xSLJDWPPacketValueArray;
    }
}

