/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.xdb.XMLType;
import oracle.xdb.dom.XDBDocument;

public class RealInputStream
extends InputStream {
    private long c_state_;
    private long c_errhp_;
    private long m_gp_;
    private int m_type_;
    private int m_stream_offset = 0;
    private boolean m_isClosed = false;
    public static final int OCISTREAM = 1;
    public static final int KGHSSTREAM = 2;

    private native int readNative(long var1, long var3, byte[] var5, int var6, int var7, int var8, long var9, int var11);

    private native void closeNative(long var1, long var3, int var5, long var6);

    private native boolean isCStateValidNative(long var1, int var3);

    public RealInputStream(Connection conn, long c_state, int type) throws SQLException {
        if (type != 1 && type != 2) {
            this.m_isClosed = true;
            return;
        }
        if (!this.isCStateValidNative(c_state, type)) {
            this.m_isClosed = true;
            return;
        }
        if (type == 1) {
            int conntype = XMLType.getConnType(conn);
            this.c_errhp_ = XMLType.getErrorHandle(conn, conntype);
            this.c_state_ = c_state;
            this.m_type_ = 1;
            this.m_gp_ = 0L;
        } else if (type == 2) {
            this.c_errhp_ = 0L;
            this.c_state_ = c_state;
            this.m_type_ = 2;
            this.m_gp_ = XDBDocument.getGP(conn);
        }
    }

    @Override
    public int read(byte[] b2) {
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read() {
        byte[] b2 = new byte[1];
        if (this.read(b2, 0, 1) != -1) {
            return b2[0];
        }
        return -1;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b2, int off, int len) {
        if (this.m_isClosed) {
            return -1;
        }
        if (off < 0 || len < 0 || b2.length < len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int nread = this.readNative(this.c_errhp_, this.c_state_, b2, off, len, this.m_type_, this.m_gp_, this.m_stream_offset);
        this.m_stream_offset += nread;
        return nread;
    }

    @Override
    public void close() {
        if (!this.m_isClosed) {
            this.closeNative(this.c_errhp_, this.c_state_, this.m_type_, this.m_gp_);
            this.m_isClosed = true;
        }
    }

    boolean isClosed() {
        return this.m_isClosed;
    }
}

