/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ResourceBundle;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;

public class OracleSecretStoreTextUI {
    private static char[] a = null;
    private static ResourceBundle b = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    public static void main(String[] stringArray) {
        Object object;
        int n2;
        String string = null;
        boolean bl = false;
        int n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!stringArray[n2].equals("-nologo") && !stringArray[n2].equals("-use_jce") && !stringArray[n2].equals("-jsafe") && !stringArray[n2].equals("-use_jce_only") && !stringArray[n2].equals("-fips140_mode")) continue;
            if (stringArray[n2].equals("-nologo")) {
                bl = true;
            } else if (stringArray[n2].equals("-use_jce")) {
                TransitionMode.enableJCEUse();
            } else if (stringArray[n2].equals("-jsafe")) {
                TransitionMode.enableJCEUse();
                try {
                    JCEUtil.registerJsafeJCE();
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    System.out.println("Unable to register Crypto-J JsafeJCE provider");
                    n3 = 1;
                    System.exit(n3);
                }
            } else if (stringArray[n2].equals("-use_jce_only")) {
                TransitionMode.disableOSDTCrypto();
            } else if (stringArray[n2].equals("-fips140_mode")) {
                TransitionMode.enableFIPS140Mode();
            }
            int n4 = stringArray.length - (n2 + 1);
            object = new String[stringArray.length - 1];
            if (stringArray.length > 1) {
                System.arraycopy(stringArray, 0, object, 0, n2);
                System.arraycopy(stringArray, n2 + 1, object, n2, n4);
            }
            stringArray = object;
            --n2;
        }
        if (!bl) {
            System.out.println(OraclePKIGenFunc.copyrightVersionBanner("Oracle Secret Store Tool"));
            System.out.println();
        }
        if (stringArray.length == 0 || stringArray[0].equals("-help")) {
            System.out.println(b.getString("USE_STRING"));
            if (stringArray.length < 2) {
                System.exit(0);
            }
        }
        if (TransitionMode.isFIPS140ModeEnabled()) {
            try {
                JCEUtil.getJCEProvider();
            }
            catch (GeneralSecurityException generalSecurityException) {
                System.out.println("Unable to get FIPS 140 cryptographic module: " + generalSecurityException.getMessage());
                n3 = 1;
                System.exit(n3);
            }
            try {
                if (!JCEUtil.isUnlimitedStrengthCryptoEnabled()) {
                    System.out.println("Unlimited Strength policy files are not installed; they are required in FIPS 140 mode");
                    n3 = 1;
                    System.exit(n3);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("Unable to perform crypto operations " + noSuchAlgorithmException.getMessage());
                n3 = 1;
                System.exit(n3);
            }
        }
        n2 = 0;
        try {
            for (n2 = 0; n2 < stringArray.length && !stringArray[n2].equals("-wrl"); ++n2) {
            }
            if (n2 + 1 >= stringArray.length) {
                System.out.println(b.getString("NO_WRL_ERROR"));
                System.out.println(b.getString("USE_STRING"));
                System.exit(-1);
            }
            string = stringArray[n2 + 1];
            OraclePKIDebug.a("main: Using wallet in " + string);
            OracleWallet oracleWallet = new OracleWallet();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                OracleSecretStore oracleSecretStore;
                Object object2;
                Object object3;
                Object object4;
                if (stringArray[n2].equals("-wrl")) {
                    ++n2;
                    continue;
                }
                if (stringArray[n2].equals("-create")) {
                    a = OraclePKIGenFunc.getCreatePassword();
                    OraclePKIDebug.a("main: Creating wallet in " + string);
                    oracleWallet.create(a);
                    if (oracleWallet.exists(string)) {
                        System.out.println(b.getString("PKI-02001") + string);
                        continue;
                    }
                    oracleWallet.saveAs(string);
                    oracleWallet.saveSSO();
                    continue;
                }
                if (stringArray[n2].equals("-createSSO")) {
                    OracleSecretStoreTextUI.a();
                    OraclePKIDebug.a("main: Creating SSO wallet in " + string);
                    oracleWallet.open(string, a);
                    oracleWallet.saveSSO();
                    continue;
                }
                if (stringArray[n2].equals("-createLSSO")) {
                    OracleSecretStoreTextUI.a();
                    OraclePKIDebug.a("main: Creating LSSO wallet in " + string);
                    oracleWallet.open(string, a);
                    oracleWallet.saveLSSO();
                    continue;
                }
                if (stringArray[n2].equals("-createALO")) {
                    OraclePKIDebug.a("main: Creating ALO wallet in " + string);
                    oracleWallet.createSSO();
                    oracleWallet.saveAs(string);
                    continue;
                }
                if (stringArray[n2].equals("-deleteSSO")) {
                    OracleSecretStoreTextUI.a();
                    OraclePKIDebug.a("main: Deleting SSO wallet for " + string);
                    oracleWallet.open(string, a);
                    oracleWallet.deleteSSOWallet();
                    continue;
                }
                if (stringArray[n2].equals("-delete")) {
                    OracleSecretStoreTextUI.a();
                    OraclePKIDebug.a("main: Deleting  wallet in " + string);
                    oracleWallet.open(string, a);
                    oracleWallet.deleteWallet();
                    continue;
                }
                if (stringArray[n2].equals("-list")) {
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    OraclePKIDebug.a("main: Listing Identifiers in " + string);
                    object = oracleWallet.getSecretStore().a();
                    System.out.println(b.getString("ENTRIES_LIST"));
                    while (object.hasMoreElements()) {
                        System.out.println(object.nextElement());
                    }
                    continue;
                }
                if (stringArray[n2].equals("-listUnsorted")) {
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    OraclePKIDebug.a("main: Listing Identifiers in " + string);
                    object = oracleWallet.getSecretStore().internalAliasesU();
                    System.out.println(b.getString("ENTRIES_LIST"));
                    while (object.hasMoreElements()) {
                        System.out.println(object.nextElement());
                    }
                    continue;
                }
                if (stringArray[n2].equals("-viewEntry")) {
                    object = stringArray[++n2];
                    OraclePKIDebug.a("main: Contents of entry " + (String)object + " in " + string);
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object4 = oracleWallet.getSecretStore();
                    object3 = ((OracleSecretStore)object4).getSecret((String)object);
                    if (object3 == null) {
                        throw new OracleSecretStoreException(b.getString("PKI-03002") + (String)object);
                    }
                    System.out.println((String)object + " = " + new String((char[])object3));
                    continue;
                }
                if (stringArray[n2].equals("-createEntry")) {
                    object = stringArray[++n2];
                    try {
                        object4 = stringArray[n2 + 1].toCharArray();
                        ++n2;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object4 = OracleSecretStoreTextUI.b();
                    }
                    OraclePKIDebug.a("main: Create entry " + (String)object + " in " + string);
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object3 = oracleWallet.getSecretStore();
                    if (((OracleSecretStore)object3).containsAlias((String)object)) {
                        throw new OracleSecretStoreException(b.getString("PKI-03001") + (String)object);
                    }
                    ((OracleSecretStore)object3).setSecret((String)object, (char[])object4);
                    oracleWallet.setSecretStore((OracleSecretStore)object3);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n2].equals("-modifyEntry")) {
                    object = stringArray[++n2];
                    try {
                        object4 = stringArray[n2 + 1].toCharArray();
                        ++n2;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object4 = OracleSecretStoreTextUI.b();
                    }
                    OraclePKIDebug.a("main: Modify entry " + (String)object + " in " + string);
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object3 = oracleWallet.getSecretStore();
                    if (!((OracleSecretStore)object3).containsAlias((String)object)) {
                        throw new OracleSecretStoreException(b.getString("PKI-03002") + (String)object);
                    }
                    ((OracleSecretStore)object3).setSecret((String)object, (char[])object4);
                    oracleWallet.setSecretStore((OracleSecretStore)object3);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n2].equals("-deleteEntry")) {
                    object = stringArray[++n2];
                    OraclePKIDebug.a("main: Contents of entry " + (String)object + " in " + string);
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object4 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object4).deleteSecret((String)object);
                    oracleWallet.setSecretStore((OracleSecretStore)object4);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n2].equals("-createCredential")) {
                    object = stringArray[++n2].toCharArray();
                    object4 = stringArray[n2 + 1].toCharArray();
                    try {
                        object3 = stringArray[n2 + 2].toCharArray();
                        n2 += 2;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        ++n2;
                        object3 = OracleSecretStoreTextUI.b();
                    }
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Create credential " + new String((char[])object) + " in " + string);
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object2 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object2).createCredential((char[])object, (char[])object4, (char[])object3);
                    oracleWallet.setSecretStore((OracleSecretStore)object2);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n2].equals("-modifyCredential")) {
                    object = stringArray[++n2].toCharArray();
                    object4 = stringArray[n2 + 1].toCharArray();
                    try {
                        object3 = stringArray[n2 + 2].toCharArray();
                        n2 += 2;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        ++n2;
                        object3 = OracleSecretStoreTextUI.b();
                    }
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Modify credential " + new String((char[])object) + " in " + string);
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object2 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object2).modifyCredential((char[])object, (char[])object4, (char[])object3);
                    oracleWallet.setSecretStore((OracleSecretStore)object2);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n2].equals("-deleteCredential")) {
                    object = stringArray[++n2].toCharArray();
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Delete credential " + new String((char[])object) + " in " + string);
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object4 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object4).deleteCredential((char[])object);
                    oracleWallet.setSecretStore((OracleSecretStore)object4);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n2].equals("-listCredential")) {
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    OraclePKIDebug.a("main: List credential  in " + string);
                    object = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object).listCredential();
                    continue;
                }
                if (stringArray[n2].equals("-createUserCredential")) {
                    object = stringArray[++n2];
                    object4 = stringArray[++n2];
                    object3 = stringArray[++n2];
                    try {
                        object2 = stringArray[++n2].toCharArray();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object2 = OracleSecretStoreTextUI.b();
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    oracleSecretStore = oracleWallet.getSecretStore();
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Create credential for map " + (String)object + "key" + (String)object4 + " in " + string);
                    }
                    oracleSecretStore.createUserCredential((String)object, (String)object4, (String)object3, (char[])object2);
                    oracleWallet.setSecretStore(oracleSecretStore);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n2].equals("-modifyUserCredential")) {
                    object = stringArray[++n2];
                    object4 = stringArray[++n2];
                    object3 = stringArray[++n2];
                    try {
                        object2 = stringArray[++n2].toCharArray();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object2 = OracleSecretStoreTextUI.b();
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    oracleSecretStore = oracleWallet.getSecretStore();
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Modify credential for map " + (String)object + "key" + (String)object4 + " in " + string);
                    }
                    oracleSecretStore.modifyUserCredential((String)object, (String)object4, (String)object3, (char[])object2);
                    oracleWallet.setSecretStore(oracleSecretStore);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n2].equals("-deleteUserCredential")) {
                    object = stringArray[++n2];
                    object4 = stringArray[++n2];
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Delete credential  for map " + (String)object + "key" + (String)object4 + " in " + string);
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object3 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object3).deleteUserCredential((String)object, (String)object4);
                    oracleWallet.setSecretStore((OracleSecretStore)object3);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n2].equals("-help")) {
                    System.out.println(b.getString("USE_STRING"));
                    continue;
                }
                System.out.println("test invalid");
                System.out.println(b.getString("INVALID_COMMAND_ERROR") + stringArray[n2]);
                n3 = -1;
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null) {
                System.out.println(iOException.getMessage());
                n3 = -1;
            } else {
                System.out.println(b.getString("UNKNOWN_ERROR") + iOException);
                n3 = -1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b.getString("PKI-01001") + stringArray[n2 - 1]);
            n3 = -1;
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            System.out.println(b.getString("SECRET_STORE_ERROR") + oracleSecretStoreException);
            n3 = -1;
        }
        System.exit(n3);
    }

    private static void a(String string, OracleWallet oracleWallet) throws OracleSecretStoreException, IOException {
        boolean bl = false;
        try {
            oracleWallet.open(string, null);
            bl = oracleWallet.isAutoLoginOnly();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!bl) {
            OracleSecretStoreTextUI.a();
            oracleWallet.open(string, a);
        }
    }

    private static void a() {
        if (a == null) {
            a = OraclePKIGenFunc.getPassword("WALLET_PASSWORD_PROMPT");
        }
    }

    private static char[] b() {
        System.out.print(b.getString("SECRET_MISSING") + "\n");
        return OraclePKIGenFunc.getSecret();
    }
}

