/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.IOException;
import java.io.OutputStream;
import oracle.security.crypto.fips.FIPS_140_2;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    private static final int c = 64;
    protected byte[] a;
    protected int b;
    private boolean d;

    public UnsyncByteArrayOutputStream() {
        this(64);
    }

    public UnsyncByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.a = new byte[n2];
    }

    @Override
    public void write(int n2) throws IOException {
        this.a();
        if (this.b == this.a.length) {
            byte[] byArray = new byte[this.a.length << 1];
            System.arraycopy(this.a, 0, byArray, 0, this.b);
            this.a = byArray;
        }
        this.a[this.b++] = (byte)n2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.a();
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.b + n3;
        if (n4 > this.a.length) {
            byte[] byArray2 = new byte[Math.max(this.a.length << 1, n4)];
            System.arraycopy(this.a, 0, byArray2, 0, this.b);
            this.a = byArray2;
        }
        System.arraycopy(byArray, n2, this.a, this.b, n3);
        this.b = n4;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.a, 0, this.b);
    }

    public void reset() throws IOException {
        this.a();
        this.b = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.b];
        System.arraycopy(this.a, 0, byArray, 0, this.b);
        return byArray;
    }

    public int size() {
        return this.b;
    }

    public String toString() {
        return new String(this.a, 0, this.b);
    }

    @Override
    public void close() throws IOException {
        this.d = true;
    }

    private void a() throws IOException {
        if (this.d) {
            throw new IOException("output stream closed");
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

