/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core.math;

import java.math.BigInteger;
import java.util.Random;

public class BigInt
extends Number
implements Comparable {
    private BigInteger a;
    public static final BigInt ZERO = BigInt.valueOf(0L);
    public static final BigInt ONE = BigInt.valueOf(1L);
    public static final BigInt TWO = BigInt.valueOf(2L);

    public static BigInt getInstance(BigInteger bigInteger) {
        return new BigInt(bigInteger);
    }

    public static BigInt getInstance(BigInt bigInt) {
        return new BigInt(bigInt.a());
    }

    private BigInt() {
    }

    private BigInt(BigInteger bigInteger) {
        this.a = bigInteger;
    }

    public BigInt(String string, int n2) {
        this.a = new BigInteger(string, n2);
    }

    public BigInt(String string) {
        this.a = new BigInteger(string);
    }

    public BigInt(byte[] byArray) {
        this.a = new BigInteger(byArray);
    }

    public BigInt(int n2, byte[] byArray) {
        this.a = new BigInteger(n2, byArray);
    }

    public BigInt(int n2, Random random) {
        this.a = new BigInteger(n2, random);
    }

    private BigInteger a() {
        return this.a;
    }

    public void erase() {
    }

    public BigInt(int n2, int n3, Random random) {
        this.a = new BigInteger(n2, n3, random);
    }

    public static BigInt valueOf(long l2) {
        return new BigInt(BigInteger.valueOf(l2));
    }

    public int signum() {
        return this.a.signum();
    }

    public int compareTo(Object object) {
        if (!(object instanceof BigInt)) {
            throw new ClassCastException("The Object is not a BigInt");
        }
        return this.compareTo((BigInt)object);
    }

    public int compareTo(BigInt bigInt) {
        return this.a.compareTo(bigInt.a());
    }

    public BigInt min(BigInt bigInt) {
        return new BigInt(this.a.min(bigInt.a()));
    }

    public BigInt max(BigInt bigInt) {
        return new BigInt(this.a.max(bigInt.a()));
    }

    public BigInt add(BigInt bigInt) {
        return new BigInt(this.a.add(bigInt.a()));
    }

    public BigInt subtract(BigInt bigInt) {
        return new BigInt(this.a.subtract(bigInt.a()));
    }

    public BigInt multiply(BigInt bigInt) {
        return new BigInt(this.a.multiply(bigInt.a()));
    }

    public BigInt divide(BigInt bigInt) {
        return new BigInt(this.a.divide(bigInt.a()));
    }

    public BigInt remainder(BigInt bigInt) {
        return new BigInt(this.a.remainder(bigInt.a()));
    }

    public BigInt[] divideAndRemainder(BigInt bigInt) {
        BigInteger[] bigIntegerArray = this.a.divideAndRemainder(bigInt.a());
        BigInt[] bigIntArray = new BigInt[]{new BigInt(bigIntegerArray[0]), new BigInt(bigIntegerArray[1])};
        return bigIntArray;
    }

    public BigInt mod(BigInt bigInt) {
        return new BigInt(this.a.mod(bigInt.a()));
    }

    public BigInt pow(int n2) {
        return new BigInt(this.a.pow(n2));
    }

    public BigInt modInverse(BigInt bigInt) {
        return new BigInt(this.a.modInverse(bigInt.a()));
    }

    public BigInt modPow(BigInt bigInt, BigInt bigInt2) {
        return new BigInt(this.a.modPow(bigInt.a(), bigInt2.a()));
    }

    public BigInt gcd(BigInt bigInt) {
        return new BigInt(this.a.gcd(bigInt.a()));
    }

    public boolean isProbablePrime(int n2) {
        return this.a.isProbablePrime(n2);
    }

    public BigInt shiftLeft(int n2) {
        return new BigInt(this.a.shiftLeft(n2));
    }

    public BigInt shiftRight(int n2) {
        return new BigInt(this.a.shiftRight(n2));
    }

    public String toString() {
        return this.a.toString();
    }

    public String toString(int n2) {
        return this.a.toString(n2);
    }

    @Override
    public int intValue() {
        return this.a.intValue();
    }

    @Override
    public long longValue() {
        return this.a.longValue();
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigInt)) {
            return false;
        }
        return this.a.equals(((BigInt)object).a());
    }

    @Override
    public double doubleValue() {
        return this.a.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.a.floatValue();
    }

    public BigInt abs() {
        return new BigInt(this.a.abs());
    }

    public BigInt negate() {
        return new BigInt(this.a.negate());
    }

    public int bitLength() {
        return this.a.bitLength();
    }

    public byte[] toByteArray() {
        return this.a.toByteArray();
    }

    public BigInt and(BigInt bigInt) {
        return new BigInt(this.a.and(bigInt.a()));
    }

    public BigInt or(BigInt bigInt) {
        return new BigInt(this.a.or(bigInt.a()));
    }

    public BigInt xor(BigInt bigInt) {
        return new BigInt(this.a.xor(bigInt.a()));
    }

    public BigInt not() {
        return new BigInt(this.a.not());
    }

    public BigInt andNot(BigInt bigInt) {
        return new BigInt(this.a.andNot(bigInt.a()));
    }

    public BigInt clearBit(int n2) {
        return new BigInt(this.a.clearBit(n2));
    }

    public BigInt setBit(int n2) {
        return new BigInt(this.a.setBit(n2));
    }

    public boolean testBit(int n2) {
        return this.a.testBit(n2);
    }

    public BigInt flipBit(int n2) {
        return new BigInt(this.a.flipBit(n2));
    }

    public int getLowestSetBit() {
        return this.a.getLowestSetBit();
    }

    public int bitCount() {
        return this.a.bitCount();
    }
}

