/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1Boolean;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRLDistPointName;
import oracle.security.crypto.cert.CRLReason;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class IssuingDistPointExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_issuingDistributionPoint;
    private CRLDistPointName distPointName = null;
    private boolean onlyContainsUserCerts = false;
    private boolean onlyContainsCACerts = false;
    private boolean[] reasons;
    private int reasonsCount;
    private boolean indirectCRL = false;

    public IssuingDistPointExtension() {
        super(TYPE);
    }

    public IssuingDistPointExtension(boolean critical) {
        super(TYPE, critical);
        this.setValue(this.toByteArray());
    }

    public IssuingDistPointExtension(InputStream is) throws IOException {
        super(is);
    }

    public CRLDistPointName getDistPointName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.distPointName;
    }

    public void setDistPointName(CRLDistPointName distPointName) {
        this.distPointName = distPointName;
        this.setValue(this.toByteArray());
    }

    public boolean onlyContainsUserCerts() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.onlyContainsUserCerts;
    }

    public void setOnlyContainsUserCerts(boolean value) {
        this.onlyContainsUserCerts = value;
        this.setValue(this.toByteArray());
    }

    public boolean onlyContainsCACerts() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.onlyContainsCACerts;
    }

    public void setOnlyContainsCACerts(boolean value) {
        this.onlyContainsCACerts = value;
        this.setValue(this.toByteArray());
    }

    public boolean isIndirectCRL() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.indirectCRL;
    }

    public void setIsIndirectCRL(boolean value) {
        this.indirectCRL = value;
        this.setValue(this.toByteArray());
    }

    public boolean hasReasonFlag(CRLReason reason) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        int i2 = reason.getValue();
        return this.reasons != null && i2 < this.reasons.length ? this.reasons[i2] : false;
    }

    public void setReasonFlag(CRLReason reason) {
        this.doSetReasonFlag(reason);
        this.setValue(this.toByteArray());
    }

    public void setReasonFlags(CRLReason[] crlReasons) {
        int len = crlReasons.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.doSetReasonFlag(crlReasons[i2]);
        }
        this.setValue(this.toByteArray());
    }

    public void clearReasonFlag(CRLReason reason) {
        int i2 = reason.getValue();
        if (this.reasons != null && i2 < this.reasons.length) {
            this.reasons[i2] = false;
        }
        this.setValue(this.toByteArray());
    }

    public void clearAllReasonFlags() {
        if (this.reasons != null) {
            int len = this.reasons.length;
            for (int i2 = 0; i2 < len; ++i2) {
                this.reasons[i2] = false;
            }
            this.setValue(this.toByteArray());
        }
    }

    private void doSetReasonFlag(CRLReason reason) {
        if (this.reasons == null || this.reasons.length < CRLReason.LIST.length) {
            boolean[] newReasons = new boolean[CRLReason.LIST.length];
            if (this.reasons != null) {
                System.arraycopy(this.reasons, 0, newReasons, 0, this.reasons.length);
            }
            this.reasons = newReasons;
        }
        this.reasons[reason.getValue()] = true;
        ++this.reasonsCount;
    }

    private byte[] toByteArray() {
        Object b2;
        ASN1Sequence seq = new ASN1Sequence();
        if (this.distPointName != null) {
            seq.addElement(new ASN1GenericConstructed(this.distPointName, 0));
        }
        if (this.onlyContainsUserCerts) {
            seq.addElement(new ASN1GenericPrimitive(new ASN1Boolean(true), 1));
        }
        if (this.onlyContainsCACerts) {
            seq.addElement(new ASN1GenericPrimitive(new ASN1Boolean(true), 2));
        }
        if (this.reasons != null && this.reasonsCount > 0) {
            b2 = new ASN1BitString(this.reasons.length);
            for (int i2 = 0; i2 < this.reasons.length; ++i2) {
                if (!this.reasons[i2]) continue;
                ((ASN1BitString)b2).setBit(i2);
            }
            seq.addElement(new ASN1GenericPrimitive((ASN1Object)b2, 3));
        }
        if (this.indirectCRL) {
            seq.addElement(new ASN1GenericPrimitive(new ASN1Boolean(true), 4));
        }
        b2 = Utils.toBytes(seq);
        this.isDecoded = true;
        return b2;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is;
            ASN1SequenceInputStream sis;
            if (this.getValue() == null) {
                this.setValue(this.toByteArray());
            }
            if ((sis = new ASN1SequenceInputStream(is = new UnsyncByteArrayInputStream(this.getValue()))).hasMoreData() && sis.getCurrentTag() == 0) {
                ASN1ConstructedInputStream cis = new ASN1ConstructedInputStream((InputStream)sis, 0);
                this.distPointName = new CRLDistPointName(cis);
                cis.terminate();
            } else {
                this.distPointName = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
                sis.setCurrentTag(1);
                this.onlyContainsUserCerts = ASN1Boolean.inputValue(sis);
            } else {
                this.onlyContainsUserCerts = false;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 2) {
                sis.setCurrentTag(1);
                this.onlyContainsCACerts = ASN1Boolean.inputValue(sis);
            } else {
                this.onlyContainsCACerts = false;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 3) {
                int i2;
                sis.setCurrentTag(3);
                ASN1BitString b2 = new ASN1BitString(sis);
                this.reasons = new boolean[b2.bitLength()];
                try {
                    for (i2 = 0; i2 < this.reasons.length; ++i2) {
                        this.reasons[i2] = b2.testBit(i2);
                        ++this.reasonsCount;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    throw new ASN1FormatException("Unknown reasons flag: " + i2);
                }
            } else {
                this.reasons = null;
                this.reasonsCount = 0;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 4) {
                sis.setCurrentTag(1);
                this.indirectCRL = ASN1Boolean.inputValue(sis);
            } else {
                this.indirectCRL = false;
            }
            sis.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s2 = new StringBuffer("issuingDistPointExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean began = false;
        if (this.getDistPointName() != null) {
            s2.append("distPointName = " + this.getDistPointName());
            began = true;
        }
        if (began) {
            s2.append(", ");
        }
        s2.append("onlyContainsUserCerts = " + this.onlyContainsUserCerts());
        s2.append(", onlyContainsCACerts = " + this.onlyContainsCACerts());
        s2.append(", onlySomeReasons = {");
        if (this.reasons != null) {
            boolean mid = false;
            for (int i2 = 0; i2 < this.reasons.length; ++i2) {
                if (mid) {
                    s2.append(", ");
                }
                if (this.reasons[i2]) {
                    s2.append(CRLReason.LIST[i2]);
                }
                mid = true;
            }
        } else {
            s2.append("null");
        }
        s2.append("}");
        s2.append(", indirectCRL = " + this.isIndirectCRL());
        s2.append("]}");
        return s2.toString();
    }
}

