/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class AuthorityKeyIDExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_authorityKeyIdentifier;
    private byte[] keyID = null;
    private ArrayList<GeneralName> issuer = null;
    private BigInteger serialNo = null;

    public AuthorityKeyIDExtension() {
        super(TYPE);
    }

    public AuthorityKeyIDExtension(byte[] keyID) {
        this(keyID, false);
    }

    public AuthorityKeyIDExtension(byte[] keyID, boolean critical) {
        super(TYPE, critical);
        this.keyID = keyID;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(GeneralName issuer, BigInteger serialNo) {
        this(issuer, serialNo, false);
    }

    public AuthorityKeyIDExtension(GeneralName issuer, BigInteger serialNo, boolean critical) {
        super(TYPE, critical);
        this.issuer = new ArrayList();
        this.issuer.add(issuer);
        this.serialNo = serialNo;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(Vector<GeneralName> issuer, BigInteger serialNo) {
        this((List<GeneralName>)issuer, serialNo);
    }

    public AuthorityKeyIDExtension(List<GeneralName> issuer, BigInteger serialNo) {
        this(issuer, serialNo, false);
    }

    public AuthorityKeyIDExtension(Vector<GeneralName> issuer, BigInteger serialNo, boolean critical) {
        this((List<GeneralName>)issuer, serialNo, critical);
    }

    public AuthorityKeyIDExtension(List<GeneralName> issuer, BigInteger serialNo, boolean critical) {
        super(TYPE, critical);
        this.issuer = issuer == null ? null : (issuer instanceof ArrayList ? (ArrayList<Object>)issuer : new ArrayList<GeneralName>(issuer));
        this.serialNo = serialNo;
        this.setValue(this.toByteArray());
    }

    public AuthorityKeyIDExtension(InputStream is) throws IOException {
        super(is);
    }

    public byte[] getAuthorityKeyID() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyID;
    }

    public Enumeration<GeneralName> authorityCertIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuer != null ? new VectorOverArrayList<GeneralName>(this.issuer).elements() : null;
    }

    public ArrayList<GeneralName> getAuthorityCertIssuer() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuer;
    }

    public BigInteger getAuthorityCertSerialNo() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.serialNo;
    }

    private byte[] toByteArray() {
        ASN1Sequence seq = new ASN1Sequence();
        if (this.keyID != null) {
            seq.addElement(new ASN1GenericPrimitive(this.keyID, 0));
        }
        if (this.issuer != null && this.serialNo != null) {
            seq.addElement(new ASN1GenericConstructed(this.issuer, 1));
            seq.addElement(new ASN1GenericPrimitive(new ASN1Integer(this.serialNo), 2));
        }
        byte[] b2 = Utils.toBytes(seq);
        this.isDecoded = true;
        return b2;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
            if (sis.getCurrentTag() == 0) {
                sis.setCurrentTag(4);
                this.keyID = ASN1OctetString.inputValue(sis);
            } else {
                this.keyID = null;
            }
            if (this.keyID == null || sis.hasMoreData()) {
                if (sis.getCurrentTag() == 1) {
                    sis.setCurrentTag(16);
                    ASN1SequenceInputStream names = new ASN1SequenceInputStream(sis);
                    this.issuer = new ArrayList();
                    while (names.hasMoreData()) {
                        this.issuer.add(new GeneralName(names));
                    }
                    names.terminate();
                } else {
                    this.issuer = null;
                }
                if (sis.getCurrentTag() == 2) {
                    sis.setCurrentTag(2);
                    this.serialNo = ASN1Integer.inputValue(sis);
                } else {
                    this.serialNo = null;
                }
            } else {
                this.issuer = null;
                this.serialNo = null;
            }
            sis.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s2 = new StringBuffer("authorityKeyIDExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean began = false;
        if (this.getAuthorityKeyID() != null) {
            s2.append("keyID = " + Utils.toHexString(this.getAuthorityKeyID()));
            began = true;
        }
        if (this.getAuthorityCertSerialNo() != null) {
            if (began) {
                s2.append(", ");
            }
            s2.append("serialNo = " + this.getAuthorityCertSerialNo());
            began = true;
        }
        if (this.issuer != null) {
            if (began) {
                s2.append(", ");
            }
            s2.append("issuer = {");
            boolean mid = false;
            int size = this.issuer.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (mid) {
                    s2.append(", ");
                }
                s2.append(this.issuer.get(i2).toString());
                mid = true;
            }
            s2.append("}");
        }
        s2.append("]}");
        return s2.toString();
    }
}

