/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.Certificate;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.Entity;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.SPKAC;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.cert.ext.ExtKeyUsageExtension;
import oracle.security.crypto.cert.ext.IssuerAltNameExtension;
import oracle.security.crypto.cert.ext.KeyUsageExtension;
import oracle.security.crypto.cert.ext.SubjectAltNameExtension;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509
extends Certificate
implements ASN1Object {
    private ASN1Sequence tbsCert;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private BigInteger serialNo;
    private X500Name issuer;
    private Date notBeforeDate;
    private Date notAfterDate;
    private X509ExtensionSet extensions = null;
    private PrivateKey issuerPrivateKey;
    private CRL issuerCRL;
    private X509Certificate issuerCertificate;
    protected boolean isDecoded = false;
    private int version = 3;
    private boolean[] issuerID;
    private boolean[] subjectID;
    private ASN1Sequence contents = null;
    X509CertificateImpl certImpl = new X509CertificateImpl();

    public X509() {
    }

    public X509(InputStream is) throws IOException {
        this.input(is);
    }

    public X509(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        this.input(is);
        ((InputStream)is).close();
    }

    public X509(URL url) throws IOException {
        InputStream is = url.openStream();
        this.input(is);
        is.close();
    }

    public static X509 toX509(X509Certificate cert) {
        if (cert instanceof X509CertificateImpl) {
            return ((X509CertificateImpl)cert).toX509();
        }
        try {
            return new X509(cert.getEncoded());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (CertificateEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public X509(byte[] data) throws IOException {
        this(new UnsyncByteArrayInputStream(data));
    }

    public X509(CertificateRequest cr, X509 issuerCertificate, oracle.security.crypto.core.PrivateKey issuerPrivateKey, BigInteger serial, int days) throws SignatureException {
        this(cr, issuerCertificate, issuerPrivateKey, serial, days, null);
    }

    public X509(CertificateRequest cr, X509 issuerCertificate, oracle.security.crypto.core.PrivateKey issuerPrivateKey, BigInteger serial, int days, AlgorithmIdentifier signAlg) throws SignatureException {
        this();
        this.holder = cr.getSubject();
        this.key = cr.getPublicKey();
        this.setIssuerCertificate(issuerCertificate);
        this.issuer = (X500Name)issuerCertificate.getHolder();
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.setValidity(days);
        if (signAlg != null) {
            this.setSigAlgID(signAlg);
        }
        this.sign();
    }

    public X509(X500Name subject, SPKAC spkac, X509 issuerCertificate, oracle.security.crypto.core.PrivateKey issuerPrivateKey, BigInteger serial, int days) throws SignatureException {
        this();
        this.holder = subject;
        this.key = spkac.getPublicKey();
        this.setIssuerCertificate(issuerCertificate);
        this.issuer = (X500Name)issuerCertificate.getHolder();
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.setValidity(days);
        this.sign();
    }

    public X509(X500Name subject, oracle.security.crypto.core.PublicKey subjectKey, X500Name issuer, oracle.security.crypto.core.PrivateKey issuerPrivateKey, BigInteger serial, int days) throws SignatureException {
        this(subject, subjectKey, issuer, issuerPrivateKey, serial, days, (AlgorithmIdentifier)null);
    }

    public X509(X500Name subject, oracle.security.crypto.core.PublicKey subjectKey, X500Name issuer, oracle.security.crypto.core.PrivateKey issuerPrivateKey, BigInteger serial, int days, AlgorithmIdentifier signAlg) throws SignatureException {
        this();
        this.holder = subject;
        this.key = subjectKey;
        this.issuer = issuer;
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.setValidity(days);
        if (signAlg != null) {
            this.setSigAlgID(signAlg);
        }
        this.sign();
    }

    public X509(X500Name subject, PublicKey subjectKey, X500Name issuer, PrivateKey issuerPrivateKey, BigInteger serial, int days, AlgorithmIdentifier signAlg) throws SignatureException {
        this();
        this.holder = subject;
        this.key = CryptoUtils.fromJCEPublicKey(subjectKey);
        this.issuer = issuer;
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.setValidity(days);
        if (signAlg != null) {
            this.setSigAlgID(signAlg);
        }
        this.sign();
    }

    public X509(X500Name subject, oracle.security.crypto.core.PublicKey subjectKey, X500Name issuer, oracle.security.crypto.core.PrivateKey issuerPrivateKey, BigInteger serial, Date notBefore, Date notAfter) throws SignatureException {
        this(subject, subjectKey, issuer, issuerPrivateKey, serial, notBefore, notAfter, (AlgorithmIdentifier)null);
    }

    public X509(X500Name subject, oracle.security.crypto.core.PublicKey subjectKey, X500Name issuer, oracle.security.crypto.core.PrivateKey issuerPrivateKey, BigInteger serial, Date notBefore, Date notAfter, AlgorithmIdentifier signAlg) throws SignatureException {
        this();
        this.holder = subject;
        this.key = subjectKey;
        this.issuer = issuer;
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.notBeforeDate = notBefore;
        this.notAfterDate = notAfter;
        if (signAlg != null) {
            this.setSigAlgID(signAlg);
        }
        this.sign();
    }

    public X509(X500Name subject, PublicKey subjectKey, X500Name issuer, PrivateKey issuerPrivateKey, BigInteger serial, Date notBefore, Date notAfter, AlgorithmIdentifier signAlg) throws SignatureException {
        this();
        this.holder = subject;
        this.key = CryptoUtils.fromJCEPublicKey(subjectKey);
        this.issuer = issuer;
        this.issuerPrivateKey = issuerPrivateKey;
        this.serialNo = serial;
        this.notBeforeDate = notBefore;
        this.notAfterDate = notAfter;
        if (signAlg != null) {
            this.setSigAlgID(signAlg);
        }
        this.sign();
    }

    protected void decode() {
        this.isDecoded = true;
    }

    public void sign() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerPrivateKey == null) {
            throw new SignatureException("Cannot sign certificate, no issuer private key set");
        }
        ASN1Sequence tbs = this.getTBSCert();
        try {
            if (this.sigAlgID == null) {
                throw new SignatureException("Cannot sign certificate, no signature algorithm set");
            }
            if (this.issuerPrivateKey.getAlgorithm().equals("RSA") && CryptoUtils.getSignatureAlg(this.sigAlgID).contains("ECDSA")) {
                throw new SignatureException("Cannot create ECDSA signature using RSA keys");
            }
            Signature sig = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.sigAlgID));
            sig.initSign(this.issuerPrivateKey);
            sig.update(Utils.toBytes(tbs));
            this.sigBytes = sig.sign();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex);
        }
        catch (java.security.SignatureException ex) {
            throw new SignatureException(ex);
        }
        this.reset();
    }

    public void sign(RandomBitsSource rbs) throws SignatureException {
        this.sign();
    }

    public byte[] getSigBytes() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    @Override
    public void input(InputStream is) throws IOException {
        int i2;
        int size;
        ASN1BitString bs;
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.tbsCert = new ASN1Sequence(sis);
        this.sigAlgID = new AlgorithmIdentifier(sis);
        this.sigBytes = ASN1BitString.inputValue(sis);
        sis.terminate();
        ASN1SequenceInputStream tbs = new ASN1SequenceInputStream(Utils.toStream(this.tbsCert));
        if (tbs.getCurrentTag() == 0) {
            ASN1ConstructedInputStream ver = new ASN1ConstructedInputStream(tbs);
            BigInteger v2 = ASN1Integer.inputValue(ver);
            this.version = v2.intValue() + 1;
            ver.terminate();
        }
        this.serialNo = ASN1Integer.inputValue(tbs);
        AlgorithmIdentifier tbsSigAlgID = new AlgorithmIdentifier(tbs);
        if (!tbsSigAlgID.equals(this.sigAlgID)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name issuer2 = new X500Name(tbs);
        if (this.issuer == null) {
            this.issuer = issuer2;
        } else if (!this.issuer.equals(issuer2)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + issuer2 + "}");
        }
        ASN1SequenceInputStream val = new ASN1SequenceInputStream(tbs);
        this.notBeforeDate = ASN1Date.inputValue(val);
        this.notAfterDate = ASN1Date.inputValue(val);
        val.terminate();
        this.holder = new X500Name(tbs);
        this.key = CryptoUtils.inputSPKI(tbs);
        if (tbs.getCurrentTag() == 1) {
            bs = new ASN1BitString(tbs);
            this.issuerID = new boolean[bs.bitLength()];
            size = bs.bitLength();
            for (i2 = 0; i2 < size; ++i2) {
                this.issuerID[i2] = bs.testBit(i2);
            }
        }
        if (tbs.getCurrentTag() == 2) {
            tbs.setCurrentTag(3);
            bs = new ASN1BitString(tbs);
            this.subjectID = new boolean[bs.bitLength()];
            size = bs.bitLength();
            for (i2 = 0; i2 < size; ++i2) {
                this.subjectID[i2] = bs.testBit(i2);
            }
        }
        if (tbs.getCurrentTag() == 3) {
            ASN1ConstructedInputStream ext = new ASN1ConstructedInputStream(tbs);
            this.extensions = new X509ExtensionSet(ext);
            ext.terminate();
        } else {
            this.extensions = null;
        }
        tbs.terminate();
        this.reset();
    }

    private ASN1Sequence getTBSCert() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.tbsCert == null) {
            ASN1Sequence s2 = new ASN1Sequence();
            if (this.extensions != null && this.extensions.size() > 0) {
                s2.addElement(new ASN1GenericConstructed(new ASN1Integer(2L), 0));
            }
            s2.addElement(new ASN1Integer(this.serialNo));
            if (this.sigAlgID == null && this.issuerPrivateKey != null) {
                if (this.issuerPrivateKey.getAlgorithm().equals("RSA")) {
                    this.sigAlgID = AlgID.sha256WithRSAEncryption;
                } else if (this.issuerPrivateKey.getAlgorithm().equals("DSA")) {
                    this.sigAlgID = AlgID.dsaWithSHA1;
                } else if (this.issuerPrivateKey.getAlgorithm().equals("EC")) {
                    int bit = ((ECPrivateKey)this.issuerPrivateKey).getParams().getCurve().getField().getFieldSize();
                    switch (bit) {
                        case 256: {
                            this.sigAlgID = AlgID.ecdsaWithSHA256;
                            break;
                        }
                        case 384: {
                            this.sigAlgID = AlgID.ecdsaWithSHA384;
                            break;
                        }
                        case 512: {
                            this.sigAlgID = AlgID.ecdsaWithSHA512;
                            break;
                        }
                        default: {
                            this.sigAlgID = AlgID.ecdsaWithSHA1;
                        }
                    }
                }
            }
            if (this.sigAlgID == null) {
                throw new SignatureException("Cannot build to-be-signed certificate, no signature algorithm set");
            }
            s2.addElement(this.sigAlgID);
            s2.addElement(this.issuer);
            ASN1Sequence v2 = new ASN1Sequence();
            Calendar bef = Calendar.getInstance();
            bef.setTime(this.notBeforeDate);
            Calendar aft = Calendar.getInstance();
            aft.setTime(this.notAfterDate);
            v2.addElement(new ASN1Date(this.notBeforeDate, bef.get(1) > 2049));
            v2.addElement(new ASN1Date(this.notAfterDate, aft.get(1) > 2049));
            s2.addElement(v2);
            s2.addElement((X500Name)this.holder);
            s2.addElement(CryptoUtils.subjectPublicKeyInfo(this.key));
            if (this.extensions != null && this.extensions.size() > 0) {
                s2.addElement(new ASN1GenericConstructed(this.extensions, 3));
            }
            this.tbsCert = s2;
        }
        return this.tbsCert;
    }

    private ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement(this.getTBSCert());
            seq.addElement(this.sigAlgID);
            seq.addElement(new ASN1BitString(this.getSigBytes()));
            this.contents = seq;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    private void resetAll() {
        this.reset();
        this.tbsCert = null;
        this.sigBytes = null;
    }

    @Override
    public void output(OutputStream os) throws IOException {
        try {
            this.toASN1Sequence().output(os);
        }
        catch (SignatureException ex) {
            throw new OutputGenerationException(ex);
        }
    }

    @Override
    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException ex) {
            throw new StreamableOutputException(ex);
        }
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes(this.toASN1Sequence());
        }
        catch (SignatureException ex) {
            throw new StreamableOutputException(ex);
        }
    }

    @Override
    public boolean verify() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyCertDate()) {
            return false;
        }
        if (this.issuerCertificate != null) {
            if (!this.verifyCertSigner()) {
                return false;
            }
            if (!this.issuer.equals(this.issuerCertificate.getSubjectX500Principal())) {
                return false;
            }
            if (!this.verifyCertSignature()) {
                return false;
            }
        }
        return this.issuerCRL == null || this.verifyCertCRL();
    }

    private boolean verifyCertSigner() {
        if (!this.isDecoded) {
            this.decode();
        }
        int bc = this.issuerCertificate.getBasicConstraints();
        boolean[] ku = this.issuerCertificate.getKeyUsage();
        return ku == null || ku[5];
    }

    public boolean verifyCertDate() {
        Date now;
        if (!this.isDecoded) {
            this.decode();
        }
        return !(now = new Date()).before(this.notBeforeDate) && !now.after(this.notAfterDate);
    }

    public boolean verifyCertSignature() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerCertificate == null) {
            throw new IllegalStateException("Issuer certificate not set");
        }
        try {
            Signature sigObj = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.sigAlgID));
            sigObj.initVerify(this.issuerCertificate.getPublicKey());
            sigObj.update(Utils.toBytes(this.getTBSCert()));
            return sigObj.verify(this.getSigBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex);
        }
        catch (java.security.SignatureException ex) {
            throw new AuthenticationException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException(ex);
        }
        catch (StreamableOutputException ex) {
            throw new AuthenticationException(ex);
        }
        catch (SignatureException ex) {
            throw new AuthenticationException(ex);
        }
    }

    public boolean verifyCertCRL() {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerCRL == null) {
            throw new IllegalStateException("Issuer CRL not set");
        }
        return !this.issuerCRL.isRevoked(this.serialNo);
    }

    @Override
    public Entity getHolder() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.holder;
    }

    public void setHolder(X500Name holder) {
        this.holder = holder;
        this.resetAll();
    }

    @Override
    public oracle.security.crypto.core.PublicKey getPublicKey() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.key;
    }

    public void setPublicKey(oracle.security.crypto.core.PublicKey key) {
        this.setPublicKey((PublicKey)key);
    }

    public void setPublicKey(PublicKey key) {
        this.key = CryptoUtils.fromJCEPublicKey(key);
        this.resetAll();
    }

    public Date getNotBeforeDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.notBeforeDate;
    }

    public void setNotBeforeDate(Date nbd) {
        this.notBeforeDate = nbd;
        this.resetAll();
    }

    public Date getNotAfterDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.notAfterDate;
    }

    public void setNotAfterDate(Date nad) {
        this.notAfterDate = nad;
        this.resetAll();
    }

    public void setValidity(int days) {
        this.notBeforeDate = new Date();
        this.notAfterDate = Utils.daysFrom(this.notBeforeDate, days);
        this.resetAll();
    }

    public X500Name getSubject() {
        if (!this.isDecoded) {
            this.decode();
        }
        return (X500Name)this.holder;
    }

    public void setSubject(X500Name subject) {
        this.holder = subject;
        this.resetAll();
    }

    public X500Name getIssuer() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.issuer;
    }

    public void setIssuer(X500Name issuer) {
        this.issuer = issuer;
        if (this.issuerCRL != null && !issuer.equals(this.issuerCRL.getIssuer())) {
            throw new IllegalStateException("Certificate issuer does not match CRL issuer");
        }
        this.resetAll();
    }

    public void setIssuerCertificate(X509 ic) {
        this.setIssuerCertificate(ic.toX509Certificate());
    }

    public void setIssuerCertificate(X509Certificate ic) {
        this.issuerCertificate = ic;
        if (this.issuer == null) {
            if (ic instanceof X509CertificateImpl) {
                this.setIssuer(((X509CertificateImpl)ic).toX509().getIssuer());
            } else {
                this.setIssuer(X500Name.toX500Name(ic.getIssuerX500Principal()));
            }
        }
    }

    public void setIssuerPrivateKey(oracle.security.crypto.core.PrivateKey ik) {
        this.setIssuerPrivateKey((PrivateKey)ik, null);
    }

    public void setIssuerPrivateKey(oracle.security.crypto.core.PrivateKey ik, AlgorithmIdentifier sigAlgID) {
        this.setIssuerPrivateKey((PrivateKey)ik, null);
    }

    public void setIssuerPrivateKey(PrivateKey ik, AlgorithmIdentifier sigAlgID) {
        this.issuerPrivateKey = ik;
        this.setSigAlgID(sigAlgID);
    }

    public void setSigAlgID(AlgorithmIdentifier sigAlgID) {
        this.sigAlgID = sigAlgID;
        this.resetAll();
    }

    public void setIssuerCRL(CRL crl) {
        if (!this.isDecoded) {
            this.decode();
        }
        this.issuerCRL = crl;
        if (this.issuer != null && !this.issuer.equals(crl.getIssuer())) {
            throw new IllegalStateException("CRL issuer does not match certificate issuer");
        }
    }

    public BigInteger getSerialNo() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.serialNo;
    }

    public void setSerialNo(BigInteger sn) {
        this.serialNo = sn;
        this.resetAll();
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions != null && this.extensions.hasUnrecognizedCriticalExtension();
    }

    public X509ExtensionSet getExtensionSet() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions;
    }

    public X509Extension getExtension(ASN1ObjectID oid) {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions != null ? this.extensions.getExtension(oid) : null;
    }

    public void setExtensions(X509ExtensionSet exts) {
        this.extensions = exts;
        this.resetAll();
    }

    public void addExtension(X509Extension ext) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(ext);
        this.resetAll();
    }

    public byte[] getFingerprint() {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            String alg = TransitionMode.isFIPS140ModeEnabled() ? "SHA-256" : "MD5";
            MessageDigest md = JCEUtil.getMessageDigestInstance(alg);
            return md.digest(Utils.toBytes(this.toASN1Sequence()));
        }
        catch (NoSuchAlgorithmException algEx) {
            throw new IllegalStateException("MessageDigest algorithm not available.", algEx);
        }
        catch (SignatureException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static byte[] getCertID(X500Name issuer, BigInteger serial, oracle.security.crypto.core.MessageDigest md) {
        md.init();
        md.updateASCII(issuer.toString());
        md.updateASCII(serial.toString());
        md.computeCurrent();
        return md.getDigestBits();
    }

    public byte[] getCertID(oracle.security.crypto.core.MessageDigest md) {
        if (!this.isDecoded) {
            this.decode();
        }
        return X509.getCertID(this.issuer, this.serialNo, md);
    }

    public byte[] getCertID(String messageDigestAlg) {
        try {
            MessageDigest md = JCEUtil.getMessageDigestInstance(messageDigestAlg);
            if (!this.isDecoded) {
                this.decode();
            }
            md.update(this.issuer.toString().getBytes("ASCII"));
            md.update(this.serialNo.toString().getBytes("ASCII"));
            return md.digest();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ASN1ObjectID getSigAlgOID() {
        try {
            this.getTBSCert();
        }
        catch (SignatureException ex) {
            throw new IllegalStateException(ex);
        }
        if (this.sigAlgID != null) {
            return this.sigAlgID.getOID();
        }
        throw new IllegalStateException("Signature algorithm not defined");
    }

    public String getSigAlgString() {
        String algName = null;
        algName = CryptoUtils.getSignatureAlg(new AlgorithmIdentifier(this.getSigAlgOID()));
        if (algName == null) {
            algName = this.getSigAlgOID().toStringCompact();
        }
        return algName;
    }

    public boolean verifySignature(byte[] docBytes, byte[] sigBytes, AlgorithmIdentifier sigAlgID) throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            Signature sig = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(sigAlgID));
            sig.initVerify(this.key);
            sig.update(docBytes);
            return sig.verify(sigBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException(ex);
        }
        catch (java.security.SignatureException ex) {
            throw new AuthenticationException(ex);
        }
    }

    public boolean equals(Object o2) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (o2 == null) {
            return false;
        }
        if (o2 instanceof X509) {
            return Utils.areEqual(Utils.toBytes(this), Utils.toBytes((X509)o2));
        }
        if (o2 instanceof X509Certificate) {
            try {
                return Utils.areEqual(Utils.toBytes(this), ((X509Certificate)o2).getEncoded());
            }
            catch (CertificateEncodingException ex) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        if (!this.isDecoded) {
            this.decode();
        }
        return Arrays.hashCode(Utils.toBytes(this));
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decode();
        }
        String s2 = "";
        s2 = s2 + "{ fingerprint = " + Utils.toHexString(this.getFingerprint());
        s2 = s2 + ", notBefore = " + this.notBeforeDate;
        s2 = s2 + ", notAfter = " + this.notAfterDate;
        s2 = s2 + ", holder = " + this.holder;
        s2 = s2 + ", issuer = " + this.issuer;
        s2 = s2 + ", serialNo = " + this.serialNo;
        s2 = s2 + ", sigAlgOID = " + this.getSigAlgString();
        s2 = s2 + ", key = " + this.key;
        if (this.extensions != null && this.extensions.size() > 0) {
            s2 = s2 + ", extensions = {";
            boolean mid = false;
            Iterator<X509Extension> e2 = this.extensions.getExtensionsAsList().iterator();
            while (e2.hasNext()) {
                if (mid) {
                    s2 = s2 + ", ";
                }
                s2 = s2 + e2.next();
                mid = true;
            }
            s2 = s2 + " }";
        }
        s2 = s2 + " }";
        return s2;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }

    public X509Certificate toX509Certificate() {
        return this.certImpl;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.before(this.notBeforeDate)) {
            throw new CertificateNotYetValidException("Certificate not yet valid");
        }
        if (date.after(this.notAfterDate)) {
            throw new CertificateExpiredException("Certificate expired");
        }
    }

    public int getBasicConstraints() {
        BasicConstraintsExtension ext = (BasicConstraintsExtension)this.extensions.getExtension(PKIX.id_ce_basicConstraints);
        if (ext == null) {
            return -1;
        }
        if (!ext.getCA()) {
            return 0;
        }
        if (ext.getPathLen() == null) {
            return Integer.MAX_VALUE;
        }
        return ext.getPathLen().intValue();
    }

    public Principal getIssuerDN() {
        return this.getIssuer().toX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        return this.getIssuer().toX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        return this.getSubject().toX500Principal();
    }

    public boolean[] getIssuerUniqueID() {
        return this.issuerID;
    }

    public boolean[] getKeyUsage() {
        KeyUsageExtension ext = (KeyUsageExtension)this.extensions.getExtension(PKIX.id_ce_keyUsage);
        return ext.getKeyUsage();
    }

    public Date getNotAfter() {
        return this.getNotAfterDate();
    }

    public Date getNotBefore() {
        return this.getNotBeforeDate();
    }

    public BigInteger getSerialNumber() {
        return this.getSerialNo();
    }

    public String getSigAlgName() {
        return CryptoUtils.getSignatureAlg(this.sigAlgID);
    }

    public byte[] getSigAlgParams() {
        return Utils.toBytes(this.sigAlgID.getParameters());
    }

    public byte[] getSignature() {
        try {
            return this.getSigBytes();
        }
        catch (SignatureException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public boolean[] getSubjectUniqueID() {
        return this.subjectID;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return Utils.toBytes(this.getTBSCert());
        }
        catch (SignatureException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        Signature sigObj = sigProvider != null && !TransitionMode.isFIPS140ModeEnabled() ? Signature.getInstance(this.getSigAlgName(), sigProvider) : JCEUtil.getSignatureInstance(this.getSigAlgName());
        sigObj.initVerify(key);
        sigObj.update(this.getTBSCertificate());
        boolean result = sigObj.verify(this.getSignature());
        if (!result) {
            throw new java.security.SignatureException("Public key does not match");
        }
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        this.verify(key, null);
    }

    public Set<String> getCriticalExtensionOIDs() {
        return this.extensions.getCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String oid) {
        return this.extensions.getExtensionValue(oid);
    }

    public Set<String> getNonCriticalExtensionOIDs() {
        return this.extensions.getNonCriticalExtensionOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.extensions.hasUnsupportedCriticalExtension();
    }

    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        ExtKeyUsageExtension ext = (ExtKeyUsageExtension)this.extensions.getExtension(PKIX.id_ce_extKeyUsage);
        if (ext == null) {
            return null;
        }
        ArrayList<ASN1ObjectID> keyPurposes = ext.getKeyPurposesAsList();
        ArrayList<String> keyPurposesStr = new ArrayList<String>();
        for (ASN1ObjectID oid : keyPurposes) {
            keyPurposesStr.add(oid.toStringCompact());
        }
        return keyPurposesStr;
    }

    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        IssuerAltNameExtension ext = (IssuerAltNameExtension)this.extensions.getExtension(PKIX.id_ce_issuerAltName);
        if (ext == null) {
            return null;
        }
        ArrayList names = new ArrayList();
        for (GeneralName gName : ext.getIssuerAltName()) {
            names.add(gName.getTypeAndValue());
        }
        return names;
    }

    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        SubjectAltNameExtension ext = (SubjectAltNameExtension)this.extensions.getExtension(PKIX.id_ce_subjectAltName);
        if (ext == null) {
            return null;
        }
        ArrayList names = new ArrayList();
        for (GeneralName gName : ext.getSubjectAltName()) {
            names.add(gName.getTypeAndValue());
        }
        return names;
    }

    class X509CertificateImpl
    extends X509Certificate {
        X509CertificateImpl() {
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            X509.this.checkValidity();
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            X509.this.checkValidity(date);
        }

        @Override
        public int getBasicConstraints() {
            return X509.this.getBasicConstraints();
        }

        @Override
        public Principal getIssuerDN() {
            return X509.this.getIssuerDN();
        }

        @Override
        public X500Principal getIssuerX500Principal() {
            return X509.this.getIssuerX500Principal();
        }

        @Override
        public X500Principal getSubjectX500Principal() {
            return X509.this.getSubjectX500Principal();
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return X509.this.getIssuerUniqueID();
        }

        @Override
        public boolean[] getKeyUsage() {
            return X509.this.getKeyUsage();
        }

        @Override
        public Date getNotAfter() {
            return X509.this.getNotAfter();
        }

        @Override
        public Date getNotBefore() {
            return X509.this.getNotBefore();
        }

        @Override
        public BigInteger getSerialNumber() {
            return X509.this.getSerialNumber();
        }

        @Override
        public String getSigAlgName() {
            return X509.this.getSigAlgName();
        }

        @Override
        public String getSigAlgOID() {
            return X509.this.getSigAlgOID().toStringCompact();
        }

        @Override
        public byte[] getSigAlgParams() {
            return X509.this.getSigAlgParams();
        }

        @Override
        public byte[] getSignature() {
            return X509.this.getSignature();
        }

        @Override
        public Principal getSubjectDN() {
            return X509.this.getSubjectDN();
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return X509.this.getSubjectUniqueID();
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            return X509.this.getTBSCertificate();
        }

        @Override
        public int getVersion() {
            return X509.this.getVersion();
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            return X509.this.getEncoded();
        }

        @Override
        public PublicKey getPublicKey() {
            return X509.this.getPublicKey();
        }

        @Override
        public String toString() {
            return X509.this.toString();
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
            X509.this.verify(key, sigProvider);
        }

        @Override
        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
            X509.this.verify(key);
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return X509.this.getCriticalExtensionOIDs();
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return X509.this.getExtensionValue(oid);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return X509.this.getNonCriticalExtensionOIDs();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return X509.this.hasUnsupportedCriticalExtension();
        }

        @Override
        public List<String> getExtendedKeyUsage() throws CertificateParsingException {
            return X509.this.getExtendedKeyUsage();
        }

        @Override
        public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
            return X509.this.getIssuerAlternativeNames();
        }

        @Override
        public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
            return X509.this.getSubjectAlternativeNames();
        }

        @Override
        public boolean equals(Object other) {
            return X509.this.equals(other);
        }

        @Override
        public int hashCode() {
            return X509.this.hashCode();
        }

        public X509 toX509() {
            return X509.this;
        }
    }
}

