/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1ConstructedInputStream;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.DigestInfo;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class PKCS12
implements ASN1Object,
Externalizable {
    private ArrayList<PKCS12Safe> authSafes = new ArrayList();
    private char[] passwd;
    private byte[] toBeMacedData;
    private AlgorithmIdentifier macAlg;
    private byte[] macBytes;
    private byte[] macSalt;
    private BigInteger iterations;
    private ASN1Sequence contents;

    public PKCS12() {
    }

    public PKCS12(InputStream is) throws IOException {
        this();
        this.input(is);
    }

    public PKCS12(String passwd, InputStream is) throws IOException {
        this();
        this.setPassword(passwd);
        this.input(is);
    }

    public PKCS12(String passwd, ASN1Sequence s2) throws IOException {
        this();
        this.setPassword(passwd);
        this.input(s2);
    }

    void reset() {
        this.contents = null;
        this.macBytes = null;
        this.toBeMacedData = null;
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.reset();
        ASN1SequenceInputStream pfxIS = new ASN1SequenceInputStream(is);
        int ver = ASN1Integer.inputValue(pfxIS).intValue();
        if (ver != 3) {
            throw new ASN1FormatException("Expecting version 3, got version " + ver);
        }
        ASN1SequenceInputStream ciIS = new ASN1SequenceInputStream(pfxIS);
        ASN1ObjectID ct = new ASN1ObjectID(ciIS);
        if (ct.equals(ASN1Utils.pkcsID, 7, 1)) {
            if (ciIS.hasMoreData()) {
                ASN1ConstructedInputStream cIS = new ASN1ConstructedInputStream((InputStream)ciIS, 0);
                byte[] data = ASN1OctetString.inputValue(cIS);
                cIS.terminate();
                ASN1SequenceInputStream asIS = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(data));
                while (asIS.hasMoreData()) {
                    this.addAuthSafe(new PKCS12Safe(this, new ASN1Sequence(asIS)));
                }
                this.toBeMacedData = data;
                asIS.terminate();
            }
        } else {
            if (ct.equals(ASN1Utils.pkcsID, 7, 2)) {
                throw new ASN1FormatException("Public-key integrity mode not supported");
            }
            throw new ASN1FormatException("Invalid integrity mode OID " + ct.toStringCompact());
        }
        ciIS.terminate();
        if (pfxIS.hasMoreData()) {
            ASN1SequenceInputStream mdIS = new ASN1SequenceInputStream(pfxIS);
            DigestInfo mac = new DigestInfo(mdIS);
            this.macAlg = mac.getDigestAlgID();
            this.macBytes = mac.getDigest();
            this.macSalt = ASN1OctetString.inputValue(mdIS);
            this.iterations = mdIS.hasMoreData() ? ASN1Integer.inputValue(mdIS) : BigInteger.valueOf(1L);
            mdIS.terminate();
        } else {
            this.macAlg = null;
            this.macBytes = null;
            this.macSalt = null;
            this.iterations = null;
        }
        pfxIS.terminate();
    }

    public void input(ASN1Sequence s2) throws IOException {
        this.input(Utils.toStream(s2));
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    private ASN1Sequence toASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s2 = new ASN1Sequence();
        s2.addElement(new ASN1Integer(3L));
        ASN1Sequence ci = new ASN1Sequence();
        ci.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
        byte[] data = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.authSafes));
        ci.addElement(new ASN1GenericConstructed(new ASN1OctetString(data), 0));
        s2.addElement(ci);
        ASN1Sequence md = new ASN1Sequence();
        if (this.macBytes == null) {
            try {
                this.computeMAC();
            }
            catch (NoSuchAlgorithmException ex) {
                StreamableOutputException ex1 = new StreamableOutputException(ex.toString());
                ex1.initCause(ex);
                throw ex1;
            }
            catch (InvalidKeyException ex) {
                StreamableOutputException ex1 = new StreamableOutputException(ex.toString());
                ex1.initCause(ex);
                throw ex1;
            }
            catch (CipherException ex) {
                StreamableOutputException ex1 = new StreamableOutputException(ex.toString());
                ex1.initCause(ex);
                throw ex1;
            }
        }
        md.addElement(new DigestInfo(this.macAlg, this.macBytes));
        md.addElement(new ASN1OctetString(this.macSalt));
        if (this.iterations.intValue() != 1) {
            md.addElement(new ASN1Integer(this.iterations));
        }
        s2.addElement(md);
        this.contents = s2;
        return s2;
    }

    private void computeMAC() throws NoSuchAlgorithmException, InvalidKeyException, CipherException {
        if (this.macAlg == null) {
            this.macAlg = AlgID.sha_1;
        }
        if (this.macSalt == null) {
            SecureRandom sr = JCEUtil.getSecureRandom();
            this.macSalt = new byte[8];
            sr.nextBytes(this.macSalt);
        }
        String hmacAlg = CryptoUtils.getHmacAlg(this.macAlg);
        Mac hmac = JCEUtil.getMacInstance(hmacAlg);
        if (this.iterations == null) {
            this.iterations = BigInteger.valueOf(10000L);
        }
        byte[] macKey = PKCS12.pbkdf12(CryptoUtils.getDigestAlg(this.macAlg), this.passwd, this.macSalt, this.iterations.intValue(), (byte)3, hmac.getMacLength());
        hmac.init(new SecretKeySpec(macKey, hmacAlg));
        this.toBeMacedData = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.authSafes));
        this.macBytes = hmac.doFinal(this.toBeMacedData);
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    public String getPassword() {
        return this.passwd == null ? null : new String(this.passwd);
    }

    public char[] getPasswd() {
        return this.passwd;
    }

    public void setPassword(String pw) {
        if (this.passwd != null && !Arrays.equals(this.passwd, pw.toCharArray())) {
            this.reset();
        }
        this.passwd = pw.toCharArray();
    }

    public void setPasswd(char[] pw) {
        if (this.passwd != null && !Arrays.equals(this.passwd, pw)) {
            this.reset();
        }
        this.passwd = pw;
    }

    public Vector<PKCS12Safe> getAuthSafes() {
        return this.authSafes == null ? null : new VectorOverArrayList<PKCS12Safe>(this.authSafes);
    }

    public ArrayList<PKCS12Safe> getAuthSafesAsList() {
        return this.authSafes;
    }

    public void setAuthSafes(Vector<PKCS12Safe> authSafes) {
        this.setAuthSafes((List<PKCS12Safe>)authSafes);
    }

    public void setAuthSafes(List<PKCS12Safe> authSafes) {
        this.authSafes = authSafes == null ? null : (authSafes instanceof ArrayList ? (ArrayList<Object>)authSafes : new ArrayList<PKCS12Safe>(authSafes));
        this.reset();
    }

    public void addAuthSafe(PKCS12Safe s2) {
        this.authSafes.add(s2);
        this.reset();
    }

    public boolean verify() throws AuthenticationException {
        try {
            if (this.macBytes == null) {
                this.computeMAC();
                return true;
            }
            String hmacAlg = CryptoUtils.getHmacAlg(this.macAlg);
            Mac hmac = JCEUtil.getMacInstance(hmacAlg);
            if (this.iterations == null) {
                this.iterations = BigInteger.valueOf(10000L);
            }
            byte[] macKey = PKCS12.pbkdf12(CryptoUtils.getDigestAlg(this.macAlg), this.passwd, this.macSalt, this.iterations.intValue(), (byte)3, hmac.getMacLength());
            hmac.init(new SecretKeySpec(macKey, hmacAlg));
            byte[] newMacBytes = hmac.doFinal(this.toBeMacedData);
            return Utils.areEqual(this.macBytes, newMacBytes);
        }
        catch (CipherException ex) {
            AuthenticationException ex1 = new AuthenticationException(ex.toString());
            ex1.initCause(ex);
            throw ex1;
        }
        catch (InvalidKeyException ex) {
            AuthenticationException ex1 = new AuthenticationException(ex.toString());
            ex1.initCause(ex);
            throw ex1;
        }
        catch (NoSuchAlgorithmException ex) {
            AuthenticationException ex1 = new AuthenticationException(ex.toString());
            ex1.initCause(ex);
            throw ex1;
        }
    }

    static byte[] pbkdf12(String digestAlg, char[] pwd, byte[] salt, int iterationCount, byte id, int keyLength) throws NoSuchAlgorithmException {
        int off;
        if (pwd == null) {
            throw new NullPointerException("Password not set");
        }
        MessageDigest md = JCEUtil.getMessageDigestInstance(digestAlg);
        int u2 = md.getDigestLength();
        int v2 = digestAlg.contains("512") || digestAlg.contains("384") ? 128 : 64;
        byte[] D = new byte[v2];
        Utils.setArray(D, id);
        byte[] pwd2 = new byte[pwd.length * 2];
        Utils.charsToBytes(pwd, pwd2);
        byte[] password = new byte[pwd2.length + 2];
        System.arraycopy(pwd2, 0, password, 0, pwd2.length);
        password[password.length - 1] = 0;
        password[password.length - 2] = 0;
        int Slen = salt.length == 0 ? 0 : ((salt.length - 1) / v2 + 1) * v2;
        int Plen = password.length == 0 ? 0 : ((password.length - 1) / v2 + 1) * v2;
        byte[] I = new byte[Slen + Plen];
        for (off = 0; off < Slen; off += salt.length) {
            System.arraycopy(salt, 0, I, off, Math.min(Slen - off, salt.length));
        }
        int size = I.length;
        for (off = Slen; off < size; off += password.length) {
            System.arraycopy(password, 0, I, off, Math.min(I.length - off, password.length));
        }
        Utils.setArray(password, (byte)0);
        Utils.setArray(pwd2, (byte)0);
        byte[] A = new byte[keyLength];
        byte[] digest = null;
        for (int i2 = 0; i2 < keyLength; i2 += u2) {
            md.update(D);
            md.update(I);
            digest = md.digest();
            int size2 = iterationCount - 1;
            for (int j2 = 0; j2 < size2; ++j2) {
                md.update(digest);
                digest = md.digest();
            }
            byte[] B = new byte[v2];
            for (int off2 = 0; off2 < v2; off2 += u2) {
                System.arraycopy(digest, 0, B, off2, Math.min(v2 - off2, u2));
            }
            BigInt B2 = new BigInt(1, B).add(BigInt.ONE);
            BigInt mask = BigInt.ONE.shiftLeft(v2 * 8).subtract(BigInt.ONE);
            int size3 = I.length;
            for (int j3 = 0; j3 < size3; j3 += v2) {
                byte[] Ij = new byte[v2];
                System.arraycopy(I, j3, Ij, 0, v2);
                BigInt Ij2 = new BigInt(1, Ij).add(B2).and(mask);
                Utils.toByteArray(Ij2, I, j3, v2);
            }
            System.arraycopy(digest, 0, A, i2, Math.min(keyLength - i2, u2));
        }
        Utils.setArray(digest, (byte)0);
        md = null;
        return A;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer();
        s2.append('{');
        boolean mid = false;
        Iterator<PKCS12Safe> i2 = this.authSafes.iterator();
        while (i2.hasNext()) {
            if (mid) {
                s2.append(", ");
            }
            s2.append('[');
            s2.append(i2.next().toString());
            s2.append(']');
            mid = true;
        }
        s2.append('}');
        return s2.toString();
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

