/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class GeneralNames
implements ASN1Object,
Externalizable {
    private ArrayList<GeneralName> gns = new ArrayList();
    private ASN1Sequence contents;

    public GeneralNames() {
    }

    public GeneralNames(Vector<GeneralName> generalNames) {
        this((List<GeneralName>)generalNames);
    }

    public GeneralNames(List<GeneralName> generalNames) {
        this.addGeneralNames(generalNames);
    }

    public GeneralNames(GeneralName generalName) {
        this.addGeneralName(generalName);
    }

    public GeneralNames(X500Name directoryName) {
        this(directoryName, null);
    }

    public GeneralNames(String rfc822Name) {
        this(null, rfc822Name);
    }

    public GeneralNames(X500Name directoryName, String rfc822Name) {
        if (directoryName != null) {
            this.addGeneralName(directoryName);
        }
        if (rfc822Name != null) {
            this.addGeneralName(rfc822Name);
        }
    }

    public GeneralNames(InputStream is) throws IOException {
        this.input(is);
    }

    public void addGeneralName(X500Name directoryName) {
        if (directoryName != null) {
            this.addGeneralName(new GeneralName(directoryName));
        }
    }

    public void addGeneralName(String rfc822Name) {
        if (rfc822Name != null) {
            this.addGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, rfc822Name));
        }
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.gns.add(generalName);
            this.clearContents();
        }
    }

    public void addGeneralNames(Vector<GeneralName> generalNames) {
        this.addGeneralNames((List<GeneralName>)generalNames);
    }

    public void addGeneralNames(List<GeneralName> generalNames) {
        if (generalNames != null) {
            int j2 = generalNames.size();
            for (int i2 = 0; i2 < j2; ++i2) {
                this.gns.add(generalNames.get(i2));
            }
            this.clearContents();
        }
    }

    public boolean removeGeneralName(X500Name directoryName) {
        if (directoryName != null) {
            return this.removeGeneralName(new GeneralName(directoryName));
        }
        return false;
    }

    public boolean removeGeneralName(String rfc822Name) {
        if (rfc822Name != null) {
            return this.removeGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, rfc822Name));
        }
        return false;
    }

    public boolean removeGeneralName(GeneralName generalName) {
        boolean rv = false;
        if (generalName != null) {
            rv = this.gns.remove(generalName);
            if (rv) {
                // empty if block
            }
            this.clearContents();
        }
        return rv;
    }

    public GeneralName removeGeneralName(int index) {
        GeneralName rv = this.gns.get(index);
        this.gns.remove(index);
        this.clearContents();
        return rv;
    }

    public boolean removeGeneralNames(Vector<GeneralName> generalNames) {
        return this.removeGeneralNames((List<GeneralName>)generalNames);
    }

    public boolean removeGeneralNames(List<GeneralName> generalNames) {
        boolean rv = false;
        if (generalNames != null && generalNames.size() != 0) {
            boolean res = false;
            int j2 = generalNames.size();
            for (int i2 = 0; i2 < j2; ++i2) {
                res = this.gns.remove(generalNames.get(i2));
                if (rv) continue;
                rv = res;
            }
        }
        if (rv) {
            this.clearContents();
        }
        return rv;
    }

    public GeneralName generalNameAt(int index) {
        return this.gns.get(index);
    }

    public int size() {
        return this.gns.size();
    }

    public boolean containsGeneralName(GeneralName gn) {
        if (gn == null || this.gns == null || this.gns.size() < 1) {
            return false;
        }
        return this.gns.contains(gn);
    }

    public String toString() {
        if (this.gns == null || this.gns.size() < 1) {
            return "General Names: 0 Elements\n";
        }
        StringBuffer sb = new StringBuffer("GeneralNames: " + this.gns.size() + " Elements\n");
        int j2 = this.gns.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            sb.append(i2 + ". " + this.gns.get(i2) + "\n");
        }
        return sb.toString();
    }

    @Deprecated
    public Vector<GeneralName> getGeneralNames() {
        return this.gns == null ? null : new VectorOverArrayList<GeneralName>(this.gns);
    }

    public ArrayList<GeneralName> getGeneralNamesAsList() {
        return this.gns;
    }

    public Enumeration<GeneralName> generalNames() {
        if (this.gns == null) {
            return new Vector().elements();
        }
        return new VectorOverArrayList<GeneralName>(this.gns).elements();
    }

    public ArrayList<String> getRFC822NamesAsList() {
        if (this.gns == null || this.gns.size() < 1) {
            return null;
        }
        ArrayList<String> em = null;
        int j2 = this.gns.size();
        for (int i2 = 0; i2 < j2; ++i2) {
            GeneralName gn = this.gns.get(i2);
            if (!gn.getType().equals(GeneralName.Type.RFC822_NAME)) continue;
            if (em == null) {
                em = new ArrayList<String>();
            }
            em.add(((ASN1String)gn.getValue()).getValue());
        }
        return em;
    }

    @Deprecated
    public Vector<String> getRFC822Names() {
        ArrayList<String> l2 = this.getRFC822NamesAsList();
        return l2 == null ? null : new VectorOverArrayList<String>(l2);
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.clearContents();
        ASN1SequenceInputStream seq = new ASN1SequenceInputStream(is);
        if (seq.hasMoreData()) {
            this.gns = new ArrayList();
            while (seq.hasMoreData()) {
                this.gns.add(new GeneralName(seq));
            }
        }
        seq.terminate();
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names can not be Empty");
        }
    }

    @Override
    public void output(OutputStream os) throws IOException {
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names is Empty");
        }
        this.toASN1Sequence().output(os);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence((List<? extends ASN1Object>)this.gns);
        }
        return this.contents;
    }

    private void clearContents() {
        this.contents = null;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

