/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Header;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1TaggedObject;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.util.FixedByteArrayOutputStream;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class ASN1GenericPrimitive
implements ASN1TaggedObject {
    private ASN1Header a;
    private byte[] b;

    public ASN1GenericPrimitive(byte[] byArray, int n2) {
        this(byArray, n2, 128);
    }

    public ASN1GenericPrimitive(byte[] byArray, int n2, int n3) {
        this.a(byArray, n2, n3);
    }

    public ASN1GenericPrimitive(ASN1Object aSN1Object, int n2) {
        this(aSN1Object, n2, 128);
    }

    public ASN1GenericPrimitive(ASN1Object aSN1Object, int n2, int n3) {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(Utils.toBytes(aSN1Object));
        try {
            ASN1Header aSN1Header = new ASN1Header(unsyncByteArrayInputStream);
            this.a(aSN1Header.readBody(unsyncByteArrayInputStream), n2, n3);
        }
        catch (IOException iOException) {
            throw new StreamableInputException(iOException.toString());
        }
    }

    public ASN1GenericPrimitive(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1GenericPrimitive(InputStream inputStream, int n2) throws IOException {
        this(inputStream, n2, 128);
    }

    public ASN1GenericPrimitive(InputStream inputStream, int n2, int n3) throws IOException {
        this.input(inputStream);
        this.a.checkTag(n2);
        this.a.checkTagClass(n3);
    }

    private void a(byte[] byArray, int n2, int n3) {
        this.b = byArray;
        this.a = new ASN1Header(n2, n3, 0, byArray.length);
    }

    @Override
    public ASN1Header getHeader() {
        return this.a;
    }

    public int getTag() {
        return this.a.getTag();
    }

    public int getTagClass() {
        return this.a.getTagClass();
    }

    public byte[] getBody() {
        return this.b;
    }

    public ASN1Object withTag(int n2) throws IOException {
        return this.withTag(n2, 0);
    }

    public ASN1Object withTag(int n2, int n3) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(n2, n3, 0, this.b.length);
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(aSN1Header.length() + this.b.length);
        aSN1Header.output(fixedByteArrayOutputStream);
        fixedByteArrayOutputStream.write(this.b);
        return ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(fixedByteArrayOutputStream.getBytes()));
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkEncodingMethod(0);
        this.a(aSN1Header.readBody(inputStream), aSN1Header.getTag(), aSN1Header.getTagClass());
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.a.output(outputStream);
        outputStream.write(this.b);
    }

    @Override
    public int length() {
        return this.a.totalLength();
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

