/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.ons.Message;
import oracle.ons.MessageReader;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.NotificationManager;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.ServerError;
import oracle.ons.SubscriptionProxy;
import oracle.ons.spi.ONSSocket;
import oracle.ons.spi.SocketCallback;

class Node
implements SocketCallback {
    static long PING_TIMEOUT = 20000L;
    private final NodeAddress address;
    private final NotificationManager master;
    private final ONSConfiguration conf;
    private ONSSocket socket;
    private volatile long lastMessageTime = 0L;
    private volatile long pingTime = 0L;
    private int protocolVersion = 0;
    private final AtomicBoolean pinged = new AtomicBoolean(false);
    private final AtomicBoolean waitersAreWaiting = new AtomicBoolean(false);
    private final List<BlockingQueue<Node>> waiters = new ArrayList<BlockingQueue<Node>>();
    private static AtomicInteger globalId = new AtomicInteger(1);
    private final MessageReader messageReader = new MessageReader();
    private final Map<String, ServerSubscriptionProxy> subscriberIndex = new ConcurrentHashMap<String, ServerSubscriptionProxy>();
    private final Map<String, ServerSubscriptionProxy> subscriptionToProxy = new HashMap<String, ServerSubscriptionProxy>();
    private static final int STATE_NOT_CONNECTED = 0;
    private static final int STATE_NOT_INITIALIZED = 1;
    private static final int STATE_INITIALIZED = 2;
    private static final int STATE_SHUTDOWN = 3;
    private AtomicInteger state = new AtomicInteger(0);
    private Set<NotificationNetwork> userSet = new HashSet<NotificationNetwork>();

    public NodeAddress getAddress() {
        return this.address;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    private void sendPingMessage(long time) {
        if (this.pinged.compareAndSet(false, true)) {
            this.master.logger.finest(this.address.toString() + " : Pinging");
            if (this.protocolVersion >= 5) {
                this.send(new Message("echo"));
            } else {
                this.send(new Message("subscribe").put("Subscription", "[").put("SubscriberID", "99"));
            }
            this.pingTime = System.currentTimeMillis();
        } else if (time - this.pingTime > this.conf.getSocketTimeout()) {
            this.master.logger.warning(this.address.toString() + " : Not answered to the ping request");
            this.close(true);
        }
    }

    void checkConnection(long time) {
        if (time - this.lastMessageTime <= PING_TIMEOUT) {
            this.pinged.set(false);
            return;
        }
        this.sendPingMessage(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(BlockingQueue<Node> waiter) {
        if (waiter != null) {
            List<BlockingQueue<Node>> list = this.waiters;
            synchronized (list) {
                this.waiters.add(waiter);
                this.waitersAreWaiting.set(true);
            }
        }
    }

    Node(NotificationManager man, NodeAddress address, ONSConfiguration conf) throws ONSException {
        this.master = man;
        this.conf = conf;
        this.address = address;
    }

    private boolean connect() throws ONSException {
        if (this.state.compareAndSet(0, 1)) {
            this.master.logger.log(Level.FINE, "Creating connection to node " + this.address.toString());
            this.master.getWorkloadManager().schedule(new NodeConnectAction());
            return true;
        }
        return this.state.get() != 3;
    }

    private void close(boolean immediate) {
        if (this.state.compareAndSet(2, 3) || this.state.compareAndSet(1, 3)) {
            if (!immediate) {
                this.onNodeDown();
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    this.master.logger.fine(this.address.toString() + e2.toString());
                }
            }
            if (immediate) {
                this.onNodeDown();
            }
        }
        this.state.set(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean register(NotificationNetwork network) {
        boolean callNodeUp = false;
        Node node = this;
        synchronized (node) {
            if (this.state.get() == 3) {
                return false;
            }
            this.master.logger.finest(String.format("Network %s is registering at node %s", network.toString(), this.toString()));
            if (this.userSet.add(network)) {
                if (this.isConnected()) {
                    callNodeUp = true;
                } else {
                    return this.connect();
                }
            }
        }
        if (callNodeUp) {
            try {
                network.onNodeUp(this);
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(NotificationNetwork network) {
        boolean noUsersLeft;
        Node node = this;
        synchronized (node) {
            this.userSet.remove(network);
            noUsersLeft = this.userSet.isEmpty();
        }
        if (noUsersLeft) {
            this.close(false);
        }
    }

    public boolean isConnected() {
        return this.state.get() == 2;
    }

    public boolean isGarbage() {
        return this.state.get() == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Message m2) throws ONSException {
        try {
            Node node = this;
            synchronized (node) {
                m2.ready().send(this.socket.getOutputStream()).flush();
            }
        }
        catch (IOException e2) {
            this.close(true);
            throw new ServerError(e2.getLocalizedMessage(), m2.dump());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessage(Notification n2) {
        boolean successNotification;
        boolean isStatusMessage = n2.verb.equals("status");
        if (isStatusMessage) {
            if (n2.hasProperty("SubscriberID") && n2.get("SubscriberID").equals("99")) {
                this.master.logger.finest("Answer to ping from " + this.address.toString());
                return;
            }
        } else if (n2.verb.equals("echoresponse")) {
            this.master.logger.finest("Answer to ping from " + this.address.toString());
            return;
        }
        this.master.logger.finer("Notification message on node " + this.address.toString() + " of type " + n2.verb);
        this.master.logger.finest("Message : " + n2.toString());
        if (isStatusMessage) {
            this.master.logger.fine(String.format("Status message : %s", n2.get("Message")));
        }
        boolean bl = successNotification = isStatusMessage && n2.getResult() == 1;
        if (isStatusMessage && this.state.get() == 1) {
            Node node = this;
            synchronized (node) {
                if (successNotification) {
                    this.conf.setInstanceId(n2.get("instanceId"));
                    try {
                        this.protocolVersion = Integer.parseInt(n2.get("Version"));
                        if (this.protocolVersion < 3) {
                            this.master.logger.warning("Server " + this.toString() + " version " + String.valueOf(this.protocolVersion) + " is not supported");
                            this.close(true);
                            return;
                        }
                    }
                    catch (NumberFormatException nex) {
                        this.protocolVersion = 0;
                    }
                    if (this.state.compareAndSet(1, 2)) {
                        this.onNodeUp();
                    }
                } else {
                    this.state.compareAndSet(1, 3);
                }
            }
        }
        if (this.state.get() != 2) {
            this.close(true);
            return;
        }
        if (n2.hasProperty("SubscriberID")) {
            for (String sid : n2.getSubscribers()) {
                ServerSubscriptionProxy subscriber = this.subscriberIndex.get(sid);
                if (subscriber == null) {
                    this.master.logger.log(Level.WARNING, String.format("Unknown subscriber ID : %s", sid));
                    continue;
                }
                if (isStatusMessage && n2.getResult() == 1) {
                    subscriber.setStatus(n2);
                }
                try {
                    subscriber.populate(n2);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataAvailable(byte[] input, int start, int len) {
        try {
            this.messageReader.feedBuffer(input, start, len);
        }
        catch (Exception e2) {
            throw new ServerError(e2.getLocalizedMessage());
        }
        this.lastMessageTime = System.currentTimeMillis();
        if (this.waitersAreWaiting.get()) {
            List<BlockingQueue<Node>> list = this.waiters;
            synchronized (list) {
                while (!this.waiters.isEmpty()) {
                    this.waiters.remove(this.waiters.size() - 1).add(this);
                }
                this.waitersAreWaiting.set(false);
            }
        }
        while (this.messageReader.available() && this.state.get() != 3) {
            this.processMessage(this.messageReader.remove());
        }
    }

    private synchronized void onNodeUp() {
        this.master.onNodeUp(this);
        for (NotificationNetwork network : this.userSet) {
            network.onNodeUp(this);
        }
    }

    private synchronized void onNodeDown() {
        this.master.onNodeDown(this);
        for (NotificationNetwork network : this.userSet) {
            network.onNodeDown(this);
        }
    }

    void publish(Message m2) throws ONSException {
        this.send(m2);
    }

    public synchronized void addSubscriber(SubscriptionProxy subscriber) {
        String key = subscriber.getSubscriptionKey();
        ServerSubscriptionProxy proxy = this.subscriptionToProxy.get(key);
        if (proxy == null) {
            proxy = new ServerSubscriptionProxy(subscriber);
            this.master.logger.log(Level.FINEST, "new proxy: fakeId=" + proxy.fakeId);
            this.subscriptionToProxy.put(key, proxy);
            this.subscriberIndex.put(proxy.fakeId, proxy);
            proxy.register();
        } else {
            this.master.logger.log(Level.FINEST, "adding subscriber to proxy");
            proxy.addSubscriber(subscriber);
        }
    }

    public synchronized void removeSubscriber(SubscriptionProxy subscriber) {
        String key = subscriber.getSubscriptionKey();
        ServerSubscriptionProxy proxy = this.subscriptionToProxy.get(key);
        if (proxy != null) {
            proxy.proxies.remove(subscriber);
            if (proxy.proxies.isEmpty()) {
                if (proxy.registered) {
                    this.send(new Message("unsubscribe").put("SubscriberID", proxy.fakeId));
                }
                this.subscriptionToProxy.remove(key);
                this.subscriberIndex.remove(proxy.fakeId);
            }
        }
    }

    public String toString() {
        return "{address: " + this.address.toString() + "}";
    }

    @Override
    public void hasException(Throwable exception) {
        this.master.logger.warning(exception.getClass().getName() + " : " + exception.getLocalizedMessage());
        this.close(true);
    }

    private class NodeConnectAction
    implements Runnable {
        private NodeConnectAction() {
        }

        @Override
        public void run() {
            try {
                if (Node.this.conf.hasSecureConnection()) {
                    ((Node)Node.this).master.logger.log(Level.FINE, "Creating SSL connection");
                    Node.this.socket = Node.this.master.getSocketManager().createSocket(((Node)Node.this).address.hostname, ((Node)Node.this).address.port, (int)Node.this.conf.getSocketTimeout(), Node.this, Node.this.conf.getSSLSocketFactory());
                } else {
                    Node.this.socket = Node.this.master.getSocketManager().createSocket(((Node)Node.this).address.hostname, ((Node)Node.this).address.port, (int)Node.this.conf.getSocketTimeout(), Node.this);
                }
                if (Node.this.state.get() != 1) {
                    Node.this.socket.close();
                    throw new ONSException(String.format("Race condition with node %s: already initialized", Node.this.address.toString()));
                }
                Message builder = new Message("connect");
                builder.put("Version", Integer.toString(Node.this.conf.getProtocolVersion())).put("FormFactor", Node.this.conf.getFormFactor()).put("SelfId", "java; Home=" + Node.this.conf.getOracleHome()).ready();
                Node.this.send(builder);
            }
            catch (Exception e2) {
                ((Node)Node.this).master.logger.warning(Node.this.address.toString() + " : " + e2.getLocalizedMessage());
                Node.this.close(true);
            }
        }
    }

    private class ServerSubscriptionProxy {
        private final Collection<SubscriptionProxy> proxies = new ConcurrentLinkedQueue<SubscriptionProxy>();
        private final String fakeId;
        private final Message subscriptionMessage;
        private Notification statusNotification = null;
        private volatile boolean registered = false;

        public ServerSubscriptionProxy(SubscriptionProxy subscriber) {
            String id;
            while ((id = Integer.toString(globalId.getAndIncrement())).equals("99")) {
            }
            this.fakeId = id;
            ((Node)Node.this).master.logger.log(Level.FINEST, "creating proxy: fakeId=" + this.fakeId);
            this.proxies.add(subscriber);
            this.subscriptionMessage = new Message(subscriber.subscriptionMessage);
            this.subscriptionMessage.put("SubscriberID", this.fakeId).ready();
        }

        void populate(Notification n2) throws InterruptedException {
            for (SubscriptionProxy sp : this.proxies) {
                sp.populate(n2);
            }
        }

        private void notifySubscriber(SubscriptionProxy sp) {
            if (this.statusNotification != null) {
                sp.setRegistrationNotification(this.statusNotification);
                sp.setServerSubscriberInfo(Node.this, this.fakeId);
            }
        }

        void addSubscriber(SubscriptionProxy sp) {
            this.proxies.add(sp);
            this.notifySubscriber(sp);
        }

        void setStatus(Notification n2) {
            this.registered = true;
            this.statusNotification = n2;
            for (SubscriptionProxy sp : this.proxies) {
                this.notifySubscriber(sp);
            }
        }

        void register() {
            Node.this.send(this.subscriptionMessage);
        }
    }
}

