/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.LinkedList;
import java.util.Queue;
import java.util.StringTokenizer;
import oracle.ons.Notification;
import oracle.ons.ONSConfiguration;
import oracle.ons.ServerError;

class MessageReader {
    private byte[] buffer = null;
    private Queue<Notification> messageList = new LinkedList<Notification>();
    private int bend;
    private int pos;
    private int bodypos;
    private int token_state = 0;
    private StringBuilder line;
    private Notification msg = null;
    private String headerName = null;
    private final byte[] saveBuffer = new byte[4096];
    private int tokenStart = 0;
    private int saveEnd = 0;
    private static final int TOKEN_END = 100;
    private static final int TOKEN_CONTENT = 10;
    private static final int TOKEN_HEADER = 4;
    private static final int TOKEN_INIT = 0;
    private static final int ST_REQUEST = 0;
    private static final int ST_HEADER = 2;
    private static final int ST_BODY_INIT = 3;
    private static final int ST_BODY_READ = 4;
    private static final int LS_NONE = 0;
    private static final int LS_CHECK_LF = 1;
    private static final int LS_CONTINUE = 2;
    private int line_state = 0;

    MessageReader() {
    }

    public boolean feedBuffer(byte[] buf, int start, int len) {
        this.buffer = buf;
        this.pos = start;
        this.bend = start + len;
        boolean hasMessages = false;
        while (this.pos < this.bend && this.readMessageFast()) {
            this.msg.deliveryTime = System.currentTimeMillis();
            this.messageList.add(this.msg);
            this.msg = null;
            hasMessages = true;
        }
        this.buffer = null;
        return hasMessages;
    }

    private void saveBuffer() {
        int len = this.pos - this.tokenStart;
        System.arraycopy(this.buffer, this.tokenStart, this.saveBuffer, this.saveEnd, len);
        this.saveEnd += len;
    }

    private String getLastToken() {
        if (this.saveEnd == 0) {
            String x2 = new String(this.buffer, this.tokenStart, this.pos - this.tokenStart - 1, ONSConfiguration.ONS_CHARSET);
            return x2;
        }
        return new String(this.saveBuffer, 0, this.saveEnd, ONSConfiguration.ONS_CHARSET) + new String(this.buffer, this.tokenStart, this.pos - this.tokenStart - 1, ONSConfiguration.ONS_CHARSET);
    }

    private void startToken() {
        this.saveEnd = 0;
        this.tokenStart = this.pos;
    }

    private boolean readMessageFast() {
        if (this.msg == null) {
            this.msg = new Notification();
            this.token_state = 0;
        }
        this.tokenStart = this.pos;
        block13: while (this.pos < this.bend) {
            switch (this.token_state) {
                case 0: {
                    this.startToken();
                    ++this.token_state;
                }
                case 1: {
                    if (!this.skipTo(' ')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    this.msg.method = this.getLastToken();
                    this.startToken();
                    ++this.token_state;
                }
                case 2: {
                    if (!this.skipTo(' ')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    this.msg.verb = this.getLastToken().substring(1);
                    this.startToken();
                    ++this.token_state;
                }
                case 3: {
                    if (!this.skipTo('\r')) continue block13;
                    this.token_state = 4;
                }
                case 4: {
                    if (this.pos >= this.bend) continue block13;
                    ++this.pos;
                    ++this.token_state;
                }
                case 5: {
                    if (this.pos == this.bend) continue block13;
                    if (this.buffer[this.pos] == 13) {
                        ++this.pos;
                        this.token_state = 10;
                        continue block13;
                    }
                    this.startToken();
                    ++this.token_state;
                }
                case 6: {
                    if (!this.skipTo(':')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    this.headerName = this.getLastToken();
                    this.startToken();
                    ++this.token_state;
                }
                case 7: {
                    if (!this.skipTo('\r')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    String headerValue = this.getLastToken();
                    this.msg.put(this.headerName.trim(), headerValue.trim());
                    this.token_state = 4;
                    continue block13;
                }
                case 10: {
                    if (this.pos >= this.bend) continue block13;
                    ++this.pos;
                    if (this.msg.readHelperContentLength > 0) {
                        this.msg.body = new byte[this.msg.readHelperContentLength];
                        this.bodypos = 0;
                        ++this.token_state;
                    } else {
                        this.token_state = 100;
                        return true;
                    }
                }
                case 11: {
                    if (this.pos == this.bend) continue block13;
                    int toRead = Math.min(this.msg.body.length - this.bodypos, this.bend - this.pos);
                    System.arraycopy(this.buffer, this.pos, this.msg.body, this.bodypos, toRead);
                    this.bodypos += toRead;
                    this.pos += toRead;
                    if (this.bodypos != this.msg.body.length) continue block13;
                    this.token_state = 100;
                    return true;
                }
                case 100: {
                    return true;
                }
            }
            throw new ServerError("Message parsing error");
        }
        return false;
    }

    private boolean readMessage() {
        if (this.msg == null) {
            this.msg = new Notification();
        }
        if (this.token_state < 3) {
            if (this.readHeader()) {
                this.token_state = 3;
            } else {
                return false;
            }
        }
        if (this.token_state == 3) {
            String cl = this.msg.internalProperties[19];
            if (cl != null) {
                try {
                    int cln = Integer.parseInt(cl);
                    if (cln > 0) {
                        this.msg.body = new byte[cln];
                        this.bodypos = 0;
                        this.token_state = 4;
                    }
                }
                catch (Exception e2) {
                    throw new ServerError("Mailformed ONS message", this.buffer);
                }
            }
            if (this.token_state != 4) {
                this.token_state = 0;
                return true;
            }
        }
        if (this.token_state == 4) {
            int toRead = Math.min(this.msg.body.length - this.bodypos, this.bend - this.pos);
            System.arraycopy(this.buffer, this.pos, this.msg.body, this.bodypos, toRead);
            this.bodypos += toRead;
            this.pos += toRead;
            if (this.bodypos == this.msg.body.length) {
                this.token_state = 0;
                return true;
            }
        }
        return false;
    }

    private int lineEnd() {
        int i2;
        for (i2 = this.pos; i2 < this.bend && this.buffer[i2] != 13; ++i2) {
        }
        return i2;
    }

    private String tryReadLine() {
        if (this.line_state == 1 && this.pos < this.bend) {
            ++this.pos;
            this.line_state = 0;
        }
        if (this.line_state == 0) {
            this.line = new StringBuilder();
        }
        int lep = this.lineEnd();
        this.line.append(new String(this.buffer, this.pos, lep - this.pos, ONSConfiguration.ONS_CHARSET));
        this.pos = lep;
        if (lep == this.bend) {
            this.line_state = 2;
            return null;
        }
        if (lep == this.bend - 1) {
            ++this.pos;
            this.line_state = 1;
        } else {
            this.pos += 2;
            this.line_state = 0;
        }
        return this.line.toString();
    }

    private void parse(String s2) {
        if (this.token_state == 0) {
            StringTokenizer t2 = new StringTokenizer(s2, " ", false);
            this.msg.method = t2.nextToken();
            this.msg.verb = t2.nextToken().substring(1);
            this.token_state = 2;
        } else {
            int i2 = s2.indexOf(58);
            if (i2 > 0) {
                this.msg.put(s2.substring(0, i2).trim(), s2.substring(i2 + 1, s2.length()).trim());
            }
        }
    }

    private boolean skipTo(char x2) {
        while (this.pos < this.bend && this.buffer[this.pos] != x2) {
            ++this.pos;
        }
        if (this.pos != this.bend) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private boolean readHeader() {
        String s2;
        while (this.pos < this.bend && (s2 = this.tryReadLine()) != null) {
            if (s2.isEmpty()) {
                return true;
            }
            this.parse(s2);
        }
        return false;
    }

    public boolean available() {
        return !this.messageList.isEmpty();
    }

    public Notification peek() {
        return this.messageList.peek();
    }

    public Notification remove() {
        return this.messageList.remove();
    }
}

