/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSocketFactory;
import oracle.ons.spi.ONSSocket;
import oracle.ons.spi.SocketCallback;
import oracle.ons.spi.SocketManager;

public class DefaultSocketManager
implements SocketManager {
    @Override
    public ONSSocket createSocket(String hostname, int port, int timeout, SocketCallback callback) throws IOException {
        DefaultSocket s2 = new DefaultSocket(new Socket());
        s2.socket.connect(new InetSocketAddress(hostname, port), timeout);
        s2.socket.setSoTimeout(timeout);
        new ListeningThread(s2, callback, String.format("ONS Listener Thread to %s:%d", hostname, port)).start();
        return s2;
    }

    @Override
    public ONSSocket createSocket(String hostname, int port, int timeout, SocketCallback callback, SSLSocketFactory sslSocketFactory) throws IOException {
        Socket inS = new Socket();
        inS.connect(new InetSocketAddress(hostname, port), timeout);
        DefaultSocket s2 = new DefaultSocket(sslSocketFactory.createSocket(inS, hostname, port, true));
        new ListeningThread(s2, callback, String.format("ONS Listener Thread to %s:%d (SSL)", hostname, port)).start();
        return s2;
    }

    private static class ListeningThread
    extends Thread {
        static final int BUFFER_SIZE = 4000;
        private final byte[] buffer = new byte[4000];
        private final DefaultSocket socket;
        private final SocketCallback callback;
        private int data_len;

        public ListeningThread(DefaultSocket socket, SocketCallback callback, String name) {
            super(name);
            this.socket = socket;
            this.callback = callback;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block6: {
                try {
                    InputStream is = this.socket.socket.getInputStream();
                    while (this.socket.socket.isConnected()) {
                        try {
                            this.data_len = is.read(this.buffer);
                        }
                        catch (SocketTimeoutException e2) {
                            continue;
                        }
                        if (this.data_len == -1) {
                            throw new EOFException("Socket closed by remote side");
                        }
                        this.callback.onDataAvailable(this.buffer, 0, this.data_len);
                    }
                }
                catch (Exception e3) {
                    if (this.socket.shuttingDown) break block6;
                    this.callback.hasException(e3);
                }
            }
        }
    }

    private static class DefaultSocket
    implements ONSSocket {
        public Socket socket;
        public volatile boolean shuttingDown = false;

        public DefaultSocket(Socket socket) {
            this.socket = socket;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.socket.getOutputStream();
        }

        @Override
        public void close() throws IOException {
            if (!this.socket.isClosed()) {
                this.socket.close();
                this.shuttingDown = true;
            }
        }
    }
}

