/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.ThreadSafe;
import io.debezium.document.Document;
import io.debezium.document.JacksonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

@ThreadSafe
public interface DocumentWriter {
    public static DocumentWriter defaultWriter() {
        return JacksonWriter.INSTANCE;
    }

    public static DocumentWriter prettyWriter() {
        return JacksonWriter.PRETTY_WRITER;
    }

    default public byte[] writeAsBytes(Document document) {
        byte[] byArray;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.write(document, stream);
            byArray = stream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return new byte[0];
            }
        }
        stream.close();
        return byArray;
    }

    public void write(Document var1, OutputStream var2) throws IOException;

    public void write(Document var1, Writer var2) throws IOException;

    public String write(Document var1) throws IOException;
}

