/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.document.Array;
import io.debezium.document.BasicDocument;
import io.debezium.document.BasicField;
import io.debezium.document.Path;
import io.debezium.document.Value;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@NotThreadSafe
public interface Document
extends Iterable<Field>,
Comparable<Document> {
    public static Field field(String name, Value value) {
        return new BasicField(name, value);
    }

    public static Field field(String name, Object value) {
        return new BasicField(name, Value.create(value));
    }

    public static Document create() {
        return new BasicDocument();
    }

    public static Document create(CharSequence fieldName, Object value) {
        return new BasicDocument().set(fieldName, value);
    }

    public static Document create(CharSequence fieldName1, Object value1, CharSequence fieldName2, Object value2) {
        return new BasicDocument().set(fieldName1, value1).set(fieldName2, value2);
    }

    public static Document create(CharSequence fieldName1, Object value1, CharSequence fieldName2, Object value2, CharSequence fieldName3, Object value3) {
        return new BasicDocument().set(fieldName1, value1).set(fieldName2, value2).set(fieldName3, value3);
    }

    public static Document create(CharSequence fieldName1, Object value1, CharSequence fieldName2, Object value2, CharSequence fieldName3, Object value3, CharSequence fieldName4, Object value4) {
        return new BasicDocument().set(fieldName1, value1).set(fieldName2, value2).set(fieldName3, value3).set(fieldName4, value4);
    }

    public static Document create(CharSequence fieldName1, Object value1, CharSequence fieldName2, Object value2, CharSequence fieldName3, Object value3, CharSequence fieldName4, Object value4, CharSequence fieldName5, Object value5) {
        return new BasicDocument().set(fieldName1, value1).set(fieldName2, value2).set(fieldName3, value3).set(fieldName4, value4).set(fieldName5, value5);
    }

    public static Document create(CharSequence fieldName1, Object value1, CharSequence fieldName2, Object value2, CharSequence fieldName3, Object value3, CharSequence fieldName4, Object value4, CharSequence fieldName5, Object value5, CharSequence fieldName6, Object value6) {
        return new BasicDocument().set(fieldName1, value1).set(fieldName2, value2).set(fieldName3, value3).set(fieldName4, value4).set(fieldName5, value5).set(fieldName6, value6);
    }

    public int size();

    public boolean isEmpty();

    public void clear();

    public boolean has(CharSequence var1);

    public boolean hasAll(Document var1);

    default public Optional<Value> set(Path path, boolean addIntermediaries, Value value, Consumer<Path> invalid) {
        if (path == null) {
            return Optional.empty();
        }
        if (path.isRoot()) {
            invalid.accept(path);
            return Optional.empty();
        }
        if (path.isSingle()) {
            this.set(path.lastSegment().get(), value);
            return Optional.ofNullable(value);
        }
        Path parentPath = path.parent().get();
        Optional<Object> parent = Optional.empty();
        parent = !addIntermediaries ? this.find(parentPath, (missingPath, missingIndex) -> {
            invalid.accept((Path)missingPath);
            return Optional.empty();
        }, invalid) : this.find(parentPath, (missingPath, missingIndex) -> {
            String nextSegment = path.segment(missingIndex + 1);
            if (Path.Segments.isArrayIndex(nextSegment)) {
                return Optional.of(Value.create(Array.create()));
            }
            return Optional.of(Value.create(Document.create()));
        }, invalid);
        if (!parent.isPresent()) {
            return Optional.empty();
        }
        String lastSegment = path.lastSegment().get();
        Value parentValue = (Value)parent.get();
        if (parentValue.isDocument()) {
            parentValue.asDocument().set(lastSegment, value);
        } else if (parentValue.isArray()) {
            Array array = parentValue.asArray();
            if (Path.Segments.isAfterLastIndex(lastSegment)) {
                array.add(value);
            } else {
                int index = Path.Segments.asInteger(lastSegment).get();
                array.setValue(index, value);
            }
        } else {
            invalid.accept(path);
            return Optional.empty();
        }
        return Optional.of(value);
    }

    default public Optional<Value> find(Path path) {
        return this.find(path, (missingPath, missingIndex) -> Optional.empty(), invalidPath -> {});
    }

    /*
     * Enabled aggressive block sorting
     */
    default public Optional<Value> find(Path path, BiFunction<Path, Integer, Optional<Value>> missingSegment, Consumer<Path> invalid) {
        if (path == null) {
            return Optional.empty();
        }
        if (path.isRoot()) {
            return Optional.of(Value.create(this));
        }
        Value value = Value.create(this);
        int i2 = 0;
        Iterator iterator = path.iterator();
        while (iterator.hasNext()) {
            Optional<Value> newValue;
            String segment = (String)iterator.next();
            if (value.isDocument()) {
                Value existingValue = value.asDocument().get(segment);
                if (Value.isNull(existingValue)) {
                    newValue = missingSegment.apply(path, i2);
                    if (!newValue.isPresent()) {
                        return Optional.empty();
                    }
                    Document doc = value.asDocument();
                    doc.set(segment, newValue.get());
                    value = doc.get(segment);
                } else {
                    value = existingValue;
                }
            } else {
                if (!value.isArray()) {
                    invalid.accept(path.subpath(i2));
                    return Optional.empty();
                }
                Array array = value.asArray();
                if (Path.Segments.isAfterLastIndex(segment)) {
                    newValue = missingSegment.apply(path, i2);
                    if (!newValue.isPresent()) {
                        return Optional.empty();
                    }
                    value = newValue.get();
                    array.add(value);
                } else {
                    Optional<Integer> index = Path.Segments.asInteger(segment);
                    if (!index.isPresent()) {
                        invalid.accept(path.subpath(i2));
                        return Optional.empty();
                    }
                    if (array.has(index.get())) {
                        value = array.get(index.get());
                    } else {
                        if (array.size() != index.get().intValue()) {
                            invalid.accept(path.subpath(i2));
                            return Optional.empty();
                        }
                        Optional<Value> newValue2 = missingSegment.apply(path, i2);
                        if (!newValue2.isPresent()) {
                            return Optional.empty();
                        }
                        array.add(newValue2.get());
                    }
                }
            }
            ++i2;
        }
        return Optional.of(value);
    }

    default public Stream<Field> children(Path path) {
        Value parent = this.find(path).orElse(Value.create(Document.create()));
        if (!parent.isDocument()) {
            return Stream.empty();
        }
        return parent.asDocument().stream();
    }

    default public Stream<Field> children(String fieldName) {
        Document doc = this.getDocument(fieldName);
        if (doc == null) {
            return Stream.empty();
        }
        return doc.stream();
    }

    default public Field getField(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value != null ? new BasicField(fieldName, value) : null;
    }

    default public Value get(CharSequence fieldName) {
        return this.get(fieldName, null);
    }

    public Value get(CharSequence var1, Comparable<?> var2);

    default public Boolean getBoolean(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value != null && value.isBoolean() ? value.asBoolean() : null;
    }

    default public boolean getBoolean(CharSequence fieldName, boolean defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isBoolean() ? value.asBoolean() : defaultValue;
    }

    default public Integer getInteger(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value != null && value.isInteger() ? value.asInteger() : null;
    }

    default public int getInteger(CharSequence fieldName, int defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isInteger() ? value.asInteger() : defaultValue;
    }

    default public Long getLong(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value != null && value.isLong() ? value.asLong() : null;
    }

    default public long getLong(CharSequence fieldName, long defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isLong() ? value.asLong() : defaultValue;
    }

    default public Double getDouble(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value != null && value.isDouble() ? value.asDouble() : null;
    }

    default public double getDouble(CharSequence fieldName, double defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isDouble() ? value.asDouble() : defaultValue;
    }

    default public Float getFloat(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value != null && value.isFloat() ? value.asFloat() : null;
    }

    default public float getFloat(CharSequence fieldName, float defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isFloat() ? value.asFloat().floatValue() : defaultValue;
    }

    default public Number getNumber(CharSequence fieldName) {
        return this.getNumber(fieldName, null);
    }

    default public Number getNumber(CharSequence fieldName, Number defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isNumber() ? (Number)value.asNumber() : (Number)defaultValue;
    }

    default public BigInteger getBigInteger(CharSequence fieldName) {
        return this.getBigInteger(fieldName, null);
    }

    default public BigInteger getBigInteger(CharSequence fieldName, BigInteger defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isBigInteger() ? value.asBigInteger() : defaultValue;
    }

    default public BigDecimal getBigDecimal(CharSequence fieldName) {
        return this.getBigDecimal(fieldName, null);
    }

    default public BigDecimal getBigDecimal(CharSequence fieldName, BigDecimal defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isBigDecimal() ? value.asBigDecimal() : defaultValue;
    }

    default public String getString(CharSequence fieldName) {
        return this.getString(fieldName, null);
    }

    default public String getString(CharSequence fieldName, String defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isString() ? value.asString() : defaultValue;
    }

    default public byte[] getBytes(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value != null && value.isBinary() ? value.asBytes() : null;
    }

    default public Array getArray(CharSequence fieldName) {
        return this.getArray(fieldName, null);
    }

    default public Array getArray(CharSequence fieldName, Array defaultValue) {
        Value value = this.get(fieldName);
        return value != null && value.isArray() ? value.asArray() : defaultValue;
    }

    default public Array getOrCreateArray(CharSequence fieldName) {
        Value value = this.get(fieldName);
        if (value == null || value.isNull()) {
            return this.setArray(fieldName, null);
        }
        return value.asArray();
    }

    default public Document getDocument(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value != null && value.isDocument() ? value.asDocument() : null;
    }

    default public Document getOrCreateDocument(CharSequence fieldName) {
        Value value = this.get(fieldName);
        if (value == null || value.isNull()) {
            return this.setDocument(fieldName, null);
        }
        return value.asDocument();
    }

    default public boolean isNull(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value != null && value.isNull();
    }

    default public boolean isNullOrMissing(CharSequence fieldName) {
        Value value = this.get(fieldName);
        return value == null || value.isNull();
    }

    public Iterable<CharSequence> keySet();

    public Document clone();

    public Value remove(CharSequence var1);

    default public Value remove(Optional<? extends CharSequence> name) {
        return name.isPresent() ? this.remove(name.get()) : null;
    }

    public Document removeAll();

    default public Document putAll(Iterator<Field> fields) {
        while (fields.hasNext()) {
            Field field = fields.next();
            this.setValue(field.getName(), field.getValue());
        }
        return this;
    }

    default public Document putAll(Iterable<Field> fields) {
        for (Field field : fields) {
            this.setValue(field.getName(), field.getValue());
        }
        return this;
    }

    default public Document putAll(Iterable<Field> fields, Predicate<CharSequence> acceptableFieldNames) {
        for (Field field : fields) {
            if (!acceptableFieldNames.test(field.getName())) continue;
            this.setValue(field.getName(), field.getValue());
        }
        return this;
    }

    default public Document putAll(Map<? extends CharSequence, ?> fields) {
        if (fields != null) {
            for (Map.Entry<CharSequence, ?> entry : fields.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    default public Stream<Field> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public void forEach(BiConsumer<Path, Value> consumer) {
        Path root = Path.root();
        this.stream().forEach((? super T field) -> {
            Path path = root.append(field.getName().toString());
            Value value = field.getValue();
            if (value.isDocument()) {
                value.asDocument().forEach((Path p2, Value v2) -> consumer.accept(path.append((Path)p2), (Value)v2));
            } else if (value.isArray()) {
                value.asArray().forEach((? super T entry) -> consumer.accept(path.append(Integer.toString(entry.getIndex())), entry.getValue()));
            } else {
                consumer.accept(path, value);
            }
        });
    }

    default public Document transform(BiFunction<CharSequence, Value, Value> transformer) {
        for (Field field : this) {
            Value existing = this.get(field.getName());
            Value updated = transformer.apply(field.getName(), existing);
            if (updated == null) {
                updated = Value.nullValue();
            }
            if (updated == existing) continue;
            this.setValue(field.getName(), updated);
        }
        return this;
    }

    default public Document set(CharSequence name, Object value) {
        if (value instanceof Value) {
            this.setValue(name, (Value)value);
            return this;
        }
        Value wrapped = Value.create(value);
        this.setValue(name, wrapped);
        return this;
    }

    default public Document setNull(CharSequence name) {
        this.setValue(name, Value.nullValue());
        return this;
    }

    default public Document setBoolean(CharSequence name, boolean value) {
        this.setValue(name, Value.create(value));
        return this;
    }

    default public Document setNumber(CharSequence name, int value) {
        this.setValue(name, Value.create(value));
        return this;
    }

    default public Document setNumber(CharSequence name, long value) {
        this.setValue(name, Value.create(value));
        return this;
    }

    default public Document setNumber(CharSequence name, float value) {
        this.setValue(name, Value.create(value));
        return this;
    }

    default public Document setNumber(CharSequence name, double value) {
        this.setValue(name, Value.create(value));
        return this;
    }

    default public Document setNumber(CharSequence name, BigInteger value) {
        this.setValue(name, Value.create(value));
        return this;
    }

    default public Document setNumber(CharSequence name, BigDecimal value) {
        this.setValue(name, Value.create(value));
        return this;
    }

    default public Document setString(CharSequence name, String value) {
        this.setValue(name, Value.create(value));
        return this;
    }

    default public Document increment(CharSequence name, int increment) {
        return this.increment(name, Value.create(increment));
    }

    default public Document increment(CharSequence name, long increment) {
        return this.increment(name, Value.create(increment));
    }

    default public Document increment(CharSequence name, double increment) {
        return this.increment(name, Value.create(increment));
    }

    default public Document increment(CharSequence name, float increment) {
        return this.increment(name, Value.create(increment));
    }

    public Document increment(CharSequence var1, Value var2);

    default public Document setBinary(CharSequence name, byte[] data) {
        this.setValue(name, Value.create(data));
        return this;
    }

    public Document setValue(CharSequence var1, Value var2);

    default public Document setValue(Field field) {
        return this.setValue(field.getName(), field.getValue());
    }

    default public Document setDocument(CharSequence name) {
        return this.setDocument(name, Document.create());
    }

    default public Document setDocument(CharSequence name, Document document) {
        if (document == null) {
            document = Document.create();
        }
        this.setValue(name, Value.create(document));
        return this.getDocument(name);
    }

    default public Array setArray(CharSequence name) {
        return this.setArray(name, Array.create());
    }

    default public Array setArray(CharSequence name, Array array) {
        if (array == null) {
            array = Array.create();
        }
        this.setValue(name, Value.create(array));
        return this.getArray(name);
    }

    default public Array setArray(CharSequence name, Object ... values) {
        return this.setArray(name, Array.create(values));
    }

    @Override
    public int compareTo(Document var1);

    public int compareToWithoutFieldOrder(Document var1);

    public int compareToUsingSimilarFields(Document var1);

    public int compareTo(Document var1, boolean var2);

    public static interface Field
    extends Comparable<Field> {
        public CharSequence getName();

        public Value getValue();

        default public boolean isNull() {
            Value v2 = this.getValue();
            return v2 == null || v2.isNull();
        }

        default public boolean isNotNull() {
            return !this.isNull();
        }

        @Override
        default public int compareTo(Field that) {
            if (that == null) {
                return 1;
            }
            int diff = this.getName().toString().compareTo(that.getName().toString());
            if (diff != 0) {
                return diff;
            }
            return this.getValue().compareTo(that.getValue());
        }
    }
}

