/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleSchemaChangeEventEmitter;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.xstream.ChunkColumnValues;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.connector.oracle.xstream.XStreamChangeRecordEmitter;
import io.debezium.connector.oracle.xstream.XstreamStreamingChangeEventSource;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.streams.ChunkColumnValue;
import oracle.streams.DDLLCR;
import oracle.streams.LCR;
import oracle.streams.RowLCR;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LcrEventHandler
implements XStreamLCRCallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LcrEventHandler.class);
    private final OracleConnectorConfig connectorConfig;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<TableId> dispatcher;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final OracleOffsetContext offsetContext;
    private final boolean tablenameCaseInsensitive;
    private final XstreamStreamingChangeEventSource eventSource;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private final Map<String, ChunkColumnValues> columnChunks;
    private RowLCR currentRow;

    public LcrEventHandler(OracleConnectorConfig connectorConfig, ErrorHandler errorHandler, EventDispatcher<TableId> dispatcher, Clock clock, OracleDatabaseSchema schema, OracleOffsetContext offsetContext, boolean tablenameCaseInsensitive, XstreamStreamingChangeEventSource eventSource, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.connectorConfig = connectorConfig;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.offsetContext = offsetContext;
        this.tablenameCaseInsensitive = tablenameCaseInsensitive;
        this.eventSource = eventSource;
        this.streamingMetrics = streamingMetrics;
        this.columnChunks = new LinkedHashMap<String, ChunkColumnValues>();
    }

    public void processLCR(LCR lcr) throws StreamsException {
        LOGGER.trace("Received LCR {}", (Object)lcr);
        this.setWatermark();
        this.columnChunks.clear();
        LcrPosition lcrPosition = new LcrPosition(lcr.getPosition());
        LcrPosition offsetLcrPosition = LcrPosition.valueOf(this.offsetContext.getLcrPosition());
        if (lcrPosition.compareTo(offsetLcrPosition) <= 0) {
            if (LOGGER.isDebugEnabled()) {
                LcrPosition recPosition = offsetLcrPosition;
                LOGGER.debug("Ignoring change event with already processed SCN/LCR Position {}/{}, last recorded {}/{}", new Object[]{lcrPosition, lcrPosition.getScn(), recPosition != null ? recPosition : "none", recPosition != null ? recPosition.getScn() : "none"});
            }
            return;
        }
        this.offsetContext.setScn(lcrPosition.getScn());
        this.offsetContext.setLcrPosition(lcrPosition.toString());
        this.offsetContext.setTransactionId(lcr.getTransactionId());
        this.offsetContext.tableEvent(new TableId(lcr.getSourceDatabaseName(), lcr.getObjectOwner(), lcr.getObjectName()), lcr.getSourceTime().timestampValue().toInstant());
        try {
            if (lcr instanceof RowLCR) {
                this.processRowLCR((RowLCR)lcr);
            } else if (lcr instanceof DDLLCR) {
                this.dispatchSchemaChangeEvent((DDLLCR)lcr);
            }
        }
        catch (InterruptedException e2) {
            Thread.interrupted();
            LOGGER.info("Received signal to stop, event loop will halt");
        }
        catch (Exception e3) {
            this.errorHandler.setProducerThrowable(e3);
        }
    }

    private void processRowLCR(RowLCR row) throws InterruptedException {
        if (row.getCommandType().equals("LOB ERASE")) {
            LOGGER.warn("LOB_ERASE for table '{}' is not supported, use DML operations to manipulate LOB columns only.", (Object)row.getObjectName());
            return;
        }
        if (row.hasChunkData()) {
            this.currentRow = row;
        } else {
            this.dispatchDataChangeEvent(row, Collections.emptyMap());
        }
    }

    private void dispatchDataChangeEvent(RowLCR lcr, Map<String, Object> chunkValues) throws InterruptedException {
        LOGGER.debug("Processing DML event {}", (Object)lcr);
        if ("COMMIT".equals(lcr.getCommandType())) {
            this.dispatcher.dispatchTransactionCommittedEvent(this.offsetContext);
            return;
        }
        TableId tableId = this.getTableId((LCR)lcr);
        Table table = this.schema.tableFor(tableId);
        if (table == null && this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
            LOGGER.info("Table {} is new and will be captured.", (Object)tableId);
            this.dispatcher.dispatchSchemaChangeEvent(tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.connectorConfig, this.offsetContext, tableId, tableId.catalog(), tableId.schema(), this.getTableMetadataDdl(tableId), this.schema, Instant.now(), this.streamingMetrics));
            table = this.schema.tableFor(tableId);
        }
        this.dispatcher.dispatchDataChangeEvent(tableId, new XStreamChangeRecordEmitter(this.offsetContext, lcr, chunkValues, this.schema.tableFor(tableId), this.clock));
    }

    private void dispatchSchemaChangeEvent(DDLLCR ddlLcr) throws InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing DDL event {}", (Object)ddlLcr.getDDLText());
        }
        TableId tableId = this.getTableId((LCR)ddlLcr);
        this.dispatcher.dispatchSchemaChangeEvent(tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.connectorConfig, this.offsetContext, tableId, ddlLcr.getSourceDatabaseName(), ddlLcr.getObjectOwner(), ddlLcr.getDDLText(), this.schema, ddlLcr.getSourceTime().timestampValue().toInstant(), this.streamingMetrics));
    }

    private TableId getTableId(LCR lcr) {
        if (!this.tablenameCaseInsensitive) {
            return new TableId(lcr.getSourceDatabaseName(), lcr.getObjectOwner(), lcr.getObjectName());
        }
        return new TableId(lcr.getSourceDatabaseName(), lcr.getObjectOwner(), lcr.getObjectName().toLowerCase());
    }

    private String getTableMetadataDdl(TableId tableId) {
        String string;
        String pdbName = this.connectorConfig.getPdbName();
        OracleConnection connection = new OracleConnection(this.connectorConfig.getJdbcConfig(), () -> this.getClass().getClassLoader());
        try {
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            string = connection.getTableMetadataDdl(tableId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e2) {
                throw new DebeziumException("Failed to get table DDL metadata for: " + tableId, e2);
            }
        }
        connection.close();
        return string;
    }

    private void setWatermark() {
        if (this.eventSource.getXsOut() == null) {
            return;
        }
        try {
            XstreamStreamingChangeEventSource.PositionAndScn message = this.eventSource.receivePublishedPosition();
            if (message == null) {
                return;
            }
            LOGGER.debug("Recording offsets to Oracle");
            if (message.position != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Recording position {}", (Object)message.position);
                }
                this.eventSource.getXsOut().setProcessedLowWatermark(message.position.getRawPosition(), 0);
            } else if (message.scn != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Recording position with SCN {}", (Object)message.scn);
                }
                this.eventSource.getXsOut().setProcessedLowWatermark(message.scn, 0);
            } else {
                LOGGER.warn("Nothing in offsets could be recorded to Oracle");
                return;
            }
            LOGGER.trace("Offsets recorded to Oracle");
        }
        catch (StreamsException e2) {
            throw new DebeziumException("Couldn't set processed low watermark", e2);
        }
    }

    public void processChunk(ChunkColumnValue chunk) throws StreamsException {
        if (this.connectorConfig.isLobEnabled()) {
            this.columnChunks.computeIfAbsent(chunk.getColumnName(), v2 -> new ChunkColumnValues()).add(chunk);
        }
        if (chunk.isEndOfRow()) {
            try {
                HashMap<String, Object> resolvedChunkValues = new HashMap<String, Object>();
                block7: for (Map.Entry<String, ChunkColumnValues> entry : this.columnChunks.entrySet()) {
                    String columnName = entry.getKey();
                    ChunkColumnValues chunkValues = entry.getValue();
                    if (chunkValues.isEmpty()) {
                        LOGGER.trace("Column '{}' has no chunk values.", (Object)columnName);
                        continue;
                    }
                    int type = chunkValues.getChunkType();
                    switch (type) {
                        case 1: 
                        case 3: {
                            resolvedChunkValues.put(columnName, chunkValues.getStringValue());
                            continue block7;
                        }
                        case 2: {
                            resolvedChunkValues.put(columnName, chunkValues.getByteArray());
                            continue block7;
                        }
                    }
                    LOGGER.trace("Received an unsupported chunk type '{}' for column '{}', ignored.", (Object)type, (Object)columnName);
                }
                this.columnChunks.clear();
                this.dispatchDataChangeEvent(this.currentRow, resolvedChunkValues);
            }
            catch (InterruptedException e2) {
                Thread.interrupted();
                LOGGER.info("Received signal to stop, event loop will halt");
            }
            catch (SQLException e3) {
                throw new DebeziumException("Failed to process chunk data", e3);
            }
        }
    }

    public LCR createLCR() throws StreamsException {
        throw new UnsupportedOperationException("Should never be called");
    }

    public ChunkColumnValue createChunk() throws StreamsException {
        throw new UnsupportedOperationException("Should never be called");
    }
}

