/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.HistoryRecorder;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.LogMinerQueryBuilder;
import io.debezium.connector.oracle.logminer.LogMinerQueryResultProcessor;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.TransactionalBuffer;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Stopwatch;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerStreamingChangeEventSource
implements StreamingChangeEventSource<OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerStreamingChangeEventSource.class);
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<TableId> dispatcher;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final boolean isRac;
    private final Set<String> racHosts = new HashSet<String>();
    private final JdbcConfiguration jdbcConfiguration;
    private final OracleConnectorConfig.LogMiningStrategy strategy;
    private final ErrorHandler errorHandler;
    private final boolean isContinuousMining;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private final OracleConnectorConfig connectorConfig;
    private final Duration archiveLogRetention;
    private final boolean archiveLogOnlyMode;
    private final String archiveDestinationName;
    private Scn startScn;
    private Scn endScn;
    private List<BigInteger> currentRedoLogSequences;

    public LogMinerStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, Configuration jdbcConfig, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.connectorConfig = connectorConfig;
        this.strategy = connectorConfig.getLogMiningStrategy();
        this.isContinuousMining = connectorConfig.isContinuousMining();
        this.errorHandler = errorHandler;
        this.streamingMetrics = streamingMetrics;
        this.jdbcConfiguration = JdbcConfiguration.adapt(jdbcConfig);
        this.isRac = connectorConfig.isRacSystem();
        if (this.isRac) {
            this.racHosts.addAll(connectorConfig.getRacNodes().stream().map(String::toUpperCase).collect(Collectors.toSet()));
            LogMinerHelper.instantiateFlushConnections(this.jdbcConfiguration, this.racHosts);
        }
        this.archiveLogRetention = connectorConfig.getLogMiningArchiveLogRetention();
        this.archiveLogOnlyMode = connectorConfig.isArchiveLogOnlyMode();
        this.archiveDestinationName = connectorConfig.getLogMiningArchiveDestinationName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ChangeEventSource.ChangeEventSourceContext context, OracleOffsetContext offsetContext) {
        block61: {
            try (TransactionalBuffer transactionalBuffer = new TransactionalBuffer(this.connectorConfig, this.schema, this.clock, this.errorHandler, this.streamingMetrics);){
                block58: {
                    this.startScn = offsetContext.getScn();
                    if (!this.isContinuousMining && this.startScn.compareTo(LogMinerHelper.getFirstOnlineLogScn(this.jdbcConnection, this.archiveLogRetention, this.archiveDestinationName)) < 0) {
                        throw new DebeziumException("Online REDO LOG files or archive log files do not contain the offset scn " + this.startScn + ".  Please perform a new snapshot.");
                    }
                    LogMinerHelper.setNlsSessionParameters(this.jdbcConnection);
                    LogMinerHelper.checkSupplementalLogging(this.jdbcConnection, this.connectorConfig.getPdbName(), this.schema);
                    if (!this.archiveLogOnlyMode || this.waitForStartScnInArchiveLogs(context, this.startScn)) break block58;
                    LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, offsetContext.getScn()});
                    LOGGER.info("Transactional buffer dump: {}", (Object)transactionalBuffer.toString());
                    LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
                    return;
                }
                try {
                    this.initializeRedoLogsForMining(this.jdbcConnection, false, this.startScn);
                    try (HistoryRecorder historyRecorder = this.connectorConfig.getLogMiningHistoryRecorder();){
                        historyRecorder.prepare(this.streamingMetrics, this.jdbcConfiguration, this.connectorConfig.getLogMinerHistoryRetentionHours());
                        LogMinerQueryResultProcessor processor = new LogMinerQueryResultProcessor(context, this.connectorConfig, this.streamingMetrics, transactionalBuffer, offsetContext, this.schema, this.dispatcher, historyRecorder);
                        String query = LogMinerQueryBuilder.build(this.connectorConfig, this.schema, this.jdbcConnection.username());
                        try (PreparedStatement miningView = this.jdbcConnection.connection().prepareStatement(query, 1003, 1007, 1);){
                            this.currentRedoLogSequences = this.getCurrentRedoLogSequences();
                            Stopwatch stopwatch = Stopwatch.reusable();
                            while (context.isRunning()) {
                                this.streamingMetrics.calculateTimeDifference(LogMinerHelper.getSystime(this.jdbcConnection));
                                if (this.archiveLogOnlyMode && !this.waitForStartScnInArchiveLogs(context, this.startScn)) {
                                    break;
                                }
                                Instant start = Instant.now();
                                this.endScn = LogMinerHelper.getEndScn(this.jdbcConnection, this.startScn, this.endScn, this.streamingMetrics, this.connectorConfig.getLogMiningBatchSizeDefault(), this.connectorConfig.isLobEnabled(), this.connectorConfig.isArchiveLogOnlyMode(), this.connectorConfig.getLogMiningArchiveDestinationName());
                                if (this.archiveLogOnlyMode && this.startScn.equals(this.endScn)) {
                                    this.pauseBetweenMiningSessions();
                                    continue;
                                }
                                if (this.hasLogSwitchOccurred()) {
                                    LOGGER.trace("Ending log mining startScn={}, endScn={}, offsetContext.getScn={}, strategy={}, continuous={}", new Object[]{this.startScn, this.endScn, offsetContext.getScn(), this.strategy, this.isContinuousMining});
                                    LogMinerHelper.endMining(this.jdbcConnection);
                                    this.initializeRedoLogsForMining(this.jdbcConnection, true, this.startScn);
                                    this.abandonOldTransactionsIfExist(this.jdbcConnection, offsetContext, transactionalBuffer);
                                    this.currentRedoLogSequences = this.getCurrentRedoLogSequences();
                                }
                                LogMinerHelper.startLogMining(this.jdbcConnection, this.startScn, this.endScn, this.strategy, this.isContinuousMining, this.streamingMetrics);
                                LOGGER.trace("Fetching LogMiner view results SCN {} to {}", (Object)this.startScn, (Object)this.endScn);
                                stopwatch.start();
                                miningView.setFetchSize(this.connectorConfig.getMaxQueueSize());
                                miningView.setFetchDirection(1000);
                                miningView.setString(1, this.startScn.toString());
                                miningView.setString(2, this.endScn.toString());
                                try (ResultSet rs = miningView.executeQuery();){
                                    Duration lastDurationOfBatchCapturing = stopwatch.stop().durations().statistics().getTotal();
                                    this.streamingMetrics.setLastDurationOfBatchCapturing(lastDurationOfBatchCapturing);
                                    processor.processResult(rs);
                                    if (this.connectorConfig.isLobEnabled()) {
                                        this.startScn = transactionalBuffer.updateOffsetContext(offsetContext, this.dispatcher);
                                    } else {
                                        Scn lastProcessedScn = processor.getLastProcessedScn();
                                        if (!lastProcessedScn.isNull() && lastProcessedScn.compareTo(this.endScn) < 0) {
                                            this.endScn = lastProcessedScn;
                                        }
                                        if (transactionalBuffer.isEmpty()) {
                                            LOGGER.debug("Buffer is empty, updating offset SCN to {}", (Object)this.endScn);
                                            offsetContext.setScn(this.endScn);
                                        } else {
                                            Scn minStartScn = transactionalBuffer.getMinimumScn();
                                            if (!minStartScn.isNull()) {
                                                offsetContext.setScn(minStartScn.subtract(Scn.valueOf(1)));
                                                this.dispatcher.dispatchHeartbeatEvent(offsetContext);
                                            }
                                        }
                                        this.startScn = this.endScn;
                                    }
                                }
                                this.afterHandleScn(offsetContext);
                                this.streamingMetrics.setCurrentBatchProcessingTime(Duration.between(start, Instant.now()));
                                this.pauseBetweenMiningSessions();
                            }
                        }
                    }
                }
                catch (Throwable t2) {
                    try {
                        LogMinerHelper.logError(this.streamingMetrics, "Mining session stopped due to the {}", t2);
                        this.errorHandler.setProducerThrowable(t2);
                    }
                    catch (Throwable throwable) {
                        LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, offsetContext.getScn()});
                        LOGGER.info("Transactional buffer dump: {}", (Object)transactionalBuffer.toString());
                        LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
                        throw throwable;
                    }
                    LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, offsetContext.getScn()});
                    LOGGER.info("Transactional buffer dump: {}", (Object)transactionalBuffer.toString());
                    LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
                    break block61;
                }
                LOGGER.info("startScn={}, endScn={}, offsetContext.getScn()={}", new Object[]{this.startScn, this.endScn, offsetContext.getScn()});
                LOGGER.info("Transactional buffer dump: {}", (Object)transactionalBuffer.toString());
                LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
            }
        }
    }

    protected void afterHandleScn(OracleOffsetContext offsetContext) {
    }

    private void abandonOldTransactionsIfExist(OracleConnection connection, OracleOffsetContext offsetContext, TransactionalBuffer transactionalBuffer) {
        Duration transactionRetention = this.connectorConfig.getLogMiningTransactionRetention();
        if (!Duration.ZERO.equals(transactionRetention)) {
            Scn offsetScn = offsetContext.getScn();
            Optional<Scn> lastScnToAbandonTransactions = LogMinerHelper.getLastScnToAbandon(connection, offsetScn, transactionRetention);
            lastScnToAbandonTransactions.ifPresent(thresholdScn -> {
                transactionalBuffer.abandonLongTransactions((Scn)thresholdScn, offsetContext);
                offsetContext.setScn((Scn)thresholdScn);
                this.startScn = this.endScn;
            });
        }
    }

    private void initializeRedoLogsForMining(OracleConnection connection, boolean postEndMiningSession, Scn startScn) throws SQLException {
        if (!postEndMiningSession) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals(this.strategy)) {
                LogMinerHelper.buildDataDictionary(connection);
            }
            if (!this.isContinuousMining) {
                LogMinerHelper.setLogFilesForMining(connection, startScn, this.archiveLogRetention, this.archiveLogOnlyMode, this.archiveDestinationName);
            }
        } else if (!this.isContinuousMining) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals(this.strategy)) {
                LogMinerHelper.buildDataDictionary(connection);
            }
            LogMinerHelper.setLogFilesForMining(connection, startScn, this.archiveLogRetention, this.archiveLogOnlyMode, this.archiveDestinationName);
        }
    }

    private boolean hasLogSwitchOccurred() throws SQLException {
        List<BigInteger> newSequences = this.getCurrentRedoLogSequences();
        if (!newSequences.equals(this.currentRedoLogSequences)) {
            LOGGER.debug("Current log sequence(s) is now {}, was {}", newSequences, this.currentRedoLogSequences);
            this.currentRedoLogSequences = newSequences;
            Map logStatuses = this.jdbcConnection.queryAndMap(SqlUtils.redoLogStatusQuery(), rs -> {
                LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
                while (rs.next()) {
                    results.put(rs.getString(1), rs.getString(2));
                }
                return results;
            });
            int logSwitchCount = this.jdbcConnection.queryAndMap(SqlUtils.switchHistoryQuery(this.archiveDestinationName), rs -> {
                if (rs.next()) {
                    return rs.getInt(2);
                }
                return 0;
            });
            Set<String> fileNames = LogMinerHelper.getCurrentRedoLogFiles(this.jdbcConnection);
            this.streamingMetrics.setRedoLogStatus(logStatuses);
            this.streamingMetrics.setSwitchCount(logSwitchCount);
            this.streamingMetrics.setCurrentLogFileName(fileNames);
            return true;
        }
        return false;
    }

    private List<BigInteger> getCurrentRedoLogSequences() throws SQLException {
        return this.jdbcConnection.queryAndMap(SqlUtils.currentRedoLogSequenceQuery(), rs -> {
            ArrayList<BigInteger> sequences = new ArrayList<BigInteger>();
            while (rs.next()) {
                sequences.add(new BigInteger(rs.getString(1)));
            }
            return sequences;
        });
    }

    private void pauseBetweenMiningSessions() throws InterruptedException {
        Duration period = Duration.ofMillis(this.streamingMetrics.getMillisecondToSleepBetweenMiningQuery());
        Metronome.sleeper(period, this.clock).pause();
    }

    private boolean waitForStartScnInArchiveLogs(ChangeEventSource.ChangeEventSourceContext context, Scn startScn) throws SQLException, InterruptedException {
        boolean showStartScnNotInArchiveLogs = true;
        while (context.isRunning() && !this.isStartScnInArchiveLogs(startScn)) {
            if (!showStartScnNotInArchiveLogs) continue;
            LOGGER.warn("Starting SCN {} is not yet in archive logs, waiting for archive log switch.", (Object)startScn);
            showStartScnNotInArchiveLogs = false;
            Metronome.sleeper(this.connectorConfig.getArchiveLogOnlyScnPollTime(), this.clock).pause();
        }
        if (!context.isRunning()) {
            return false;
        }
        if (!showStartScnNotInArchiveLogs) {
            LOGGER.info("Starting SCN {} is now available in archive logs, log mining unpaused.", (Object)startScn);
        }
        return true;
    }

    private boolean isStartScnInArchiveLogs(Scn startScn) throws SQLException {
        List<LogFile> logs = LogMinerHelper.getLogFilesForOffsetScn(this.jdbcConnection, startScn, this.archiveLogRetention, this.archiveLogOnlyMode, this.archiveDestinationName);
        return logs.stream().anyMatch(l2 -> l2.getFirstScn().compareTo(startScn) <= 0 && l2.getNextScn().compareTo(startScn) > 0 && l2.getType().equals((Object)LogFile.Type.ARCHIVE));
    }

    @Override
    public void commitOffset(Map<String, ?> offset) {
    }
}

