/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.converters;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import io.debezium.function.Predicates;
import io.debezium.spi.converter.CustomConverter;
import io.debezium.spi.converter.RelationalColumn;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Predicate;
import oracle.sql.NUMBER;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberOneToBooleanConverter
implements CustomConverter<SchemaBuilder, RelationalColumn> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberOneToBooleanConverter.class);
    private static final Boolean FALLBACK = Boolean.FALSE;
    public static final String SELECTOR_PROPERTY = "selector";
    private Predicate<RelationalColumn> selector = x2 -> true;

    @Override
    public void configure(Properties props) {
        String selectorConfig = props.getProperty(SELECTOR_PROPERTY);
        if (Strings.isNullOrEmpty(selectorConfig)) {
            return;
        }
        this.selector = Predicates.includes(selectorConfig.trim(), x2 -> x2.dataCollection() + "." + x2.name());
    }

    @Override
    public void converterFor(RelationalColumn field, CustomConverter.ConverterRegistration<SchemaBuilder> registration) {
        if (!"NUMBER".equalsIgnoreCase(field.typeName()) || field.length().orElse(-1) != 1 || !this.selector.test(field)) {
            return;
        }
        registration.register(SchemaBuilder.bool(), x2 -> {
            if (x2 == null) {
                if (field.isOptional()) {
                    return null;
                }
                if (field.hasDefaultValue()) {
                    return field.defaultValue();
                }
                return FALLBACK;
            }
            if (x2 instanceof Boolean) {
                return x2;
            }
            if (x2 instanceof Number) {
                return ((Number)x2).intValue() > 0;
            }
            if (x2 instanceof NUMBER) {
                try {
                    return ((NUMBER)x2).intValue() > 0;
                }
                catch (SQLException sQLException) {
                }
            } else if (x2 instanceof String) {
                try {
                    return Integer.parseInt((String)x2) > 0;
                }
                catch (NumberFormatException e2) {
                    return Boolean.parseBoolean((String)x2);
                }
            }
            LOGGER.warn("Cannot convert '{}' to boolean", x2.getClass());
            return FALLBACK;
        });
    }
}

