/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@NotThreadSafe
public class SourceInfo
extends BaseSourceInfo {
    public static final String TXID_KEY = "txId";
    public static final String SCN_KEY = "scn";
    public static final String COMMIT_SCN_KEY = "commit_scn";
    public static final String LCR_POSITION_KEY = "lcr_position";
    public static final String SNAPSHOT_KEY = "snapshot";
    private Scn scn;
    private Scn commitScn;
    private String lcrPosition;
    private String transactionId;
    private Instant sourceTime;
    private Set<TableId> tableIds;

    protected SourceInfo(OracleConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    public Scn getScn() {
        return this.scn;
    }

    public Scn getCommitScn() {
        return this.commitScn;
    }

    public void setScn(Scn scn) {
        this.scn = scn;
    }

    public void setCommitScn(Scn commitScn) {
        this.commitScn = commitScn;
    }

    public String getLcrPosition() {
        return this.lcrPosition;
    }

    public void setLcrPosition(String lcrPosition) {
        this.lcrPosition = lcrPosition;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Instant getSourceTime() {
        return this.sourceTime;
    }

    public void setSourceTime(Instant sourceTime) {
        this.sourceTime = sourceTime;
    }

    public String tableSchema() {
        return this.tableIds.isEmpty() ? null : this.tableIds.stream().filter(x2 -> x2 != null).map(TableId::schema).distinct().collect(Collectors.joining(","));
    }

    public String table() {
        return this.tableIds.isEmpty() ? null : this.tableIds.stream().filter(x2 -> x2 != null).map(TableId::table).collect(Collectors.joining(","));
    }

    public void tableEvent(Set<TableId> tableIds) {
        this.tableIds = new HashSet<TableId>(tableIds);
    }

    public void tableEvent(TableId tableId) {
        this.tableIds = Collections.singleton(tableId);
    }

    @Override
    protected Instant timestamp() {
        return this.sourceTime;
    }

    @Override
    protected String database() {
        return this.tableIds.iterator().next().catalog();
    }
}

