/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.util.Clock;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSnapshotChangeEventSource
extends RelationalSnapshotChangeEventSource<OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleSnapshotChangeEventSource.class);
    private final OracleConnectorConfig connectorConfig;
    private final OracleConnection jdbcConnection;

    public OracleSnapshotChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, OracleDatabaseSchema schema, EventDispatcher<TableId> dispatcher, Clock clock, SnapshotProgressListener snapshotProgressListener) {
        super(connectorConfig, jdbcConnection, schema, dispatcher, clock, snapshotProgressListener);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = jdbcConnection;
    }

    @Override
    protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(OracleOffsetContext previousOffset) {
        boolean snapshotSchema = true;
        boolean snapshotData = true;
        if (previousOffset != null && !previousOffset.isSnapshotRunning()) {
            snapshotSchema = false;
            snapshotData = false;
        } else {
            snapshotData = this.connectorConfig.getSnapshotMode().includeData();
        }
        return new AbstractSnapshotChangeEventSource.SnapshottingTask(snapshotSchema, snapshotData);
    }

    @Override
    protected AbstractSnapshotChangeEventSource.SnapshotContext<OracleOffsetContext> prepare(ChangeEventSource.ChangeEventSourceContext context) throws Exception {
        if (this.connectorConfig.getPdbName() != null) {
            this.jdbcConnection.setSessionToPdb(this.connectorConfig.getPdbName());
        }
        return new OracleSnapshotContext(this.connectorConfig.getCatalogName());
    }

    @Override
    protected Set<TableId> getAllTableIds(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> ctx) throws Exception {
        return this.jdbcConnection.getAllTableIds(ctx.catalogName);
    }

    @Override
    protected void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> snapshotContext) throws SQLException, InterruptedException {
        if (this.connectorConfig.getSnapshotLockingMode().usesLocking()) {
            ((OracleSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint = this.jdbcConnection.connection().setSavepoint("dbz_schema_snapshot");
            try (Statement statement = this.jdbcConnection.connection().createStatement();){
                for (TableId tableId : snapshotContext.capturedTables) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while locking table " + tableId);
                    }
                    LOGGER.debug("Locking table {}", (Object)tableId);
                    statement.execute("LOCK TABLE " + OracleSnapshotChangeEventSource.quote(tableId) + " IN ROW SHARE MODE");
                }
            }
        }
    }

    @Override
    protected void releaseSchemaSnapshotLocks(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> snapshotContext) throws SQLException {
        if (this.connectorConfig.getSnapshotLockingMode().usesLocking()) {
            this.jdbcConnection.connection().rollback(((OracleSnapshotContext)snapshotContext).preSchemaSnapshotSavepoint);
        }
    }

    @Override
    protected void determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> ctx, OracleOffsetContext previousOffset) throws Exception {
        Scn currentScn;
        Optional<Scn> latestTableDdlScn = this.getLatestTableDdlScn(ctx);
        do {
            currentScn = this.getCurrentScn(ctx);
        } while (this.areSameTimestamp(latestTableDdlScn.orElse(null), currentScn));
        ctx.offset = OracleOffsetContext.create().logicalName(this.connectorConfig).scn(currentScn).transactionContext(new TransactionContext()).build();
    }

    private Scn getCurrentScn(AbstractSnapshotChangeEventSource.SnapshotContext<OracleOffsetContext> ctx) throws SQLException {
        return this.jdbcConnection.getCurrentScn();
    }

    private boolean areSameTimestamp(Scn scn1, Scn scn2) throws SQLException {
        if (scn1 == null) {
            return false;
        }
        try (Statement statement = this.jdbcConnection.connection().createStatement();){
            boolean bl;
            block13: {
                ResultSet rs = statement.executeQuery("SELECT 1 FROM DUAL WHERE SCN_TO_TIMESTAMP(" + scn1 + ") = SCN_TO_TIMESTAMP(" + scn2 + ")");
                try {
                    bl = rs.next();
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<Scn> getLatestTableDdlScn(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> ctx) throws SQLException {
        if (ctx.capturedTables.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder lastDdlScnQuery = new StringBuilder("SELECT TIMESTAMP_TO_SCN(MAX(last_ddl_time))").append(" FROM all_objects").append(" WHERE");
        for (TableId table : ctx.capturedTables) {
            lastDdlScnQuery.append(" (owner = '" + table.schema() + "' AND object_name = '" + table.table() + "') OR");
        }
        String query = lastDdlScnQuery.substring(0, lastDdlScnQuery.length() - 3).toString();
        try (Statement statement = this.jdbcConnection.connection().createStatement();){
            Optional<Scn> optional;
            block22: {
                String latestDdlTime;
                ResultSet rs;
                block20: {
                    Optional<Scn> optional2;
                    block21: {
                        rs = statement.executeQuery(query);
                        try {
                            if (!rs.next()) {
                                throw new IllegalStateException("Couldn't get latest table DDL SCN");
                            }
                            latestDdlTime = rs.getString(1);
                            if (!"0".equals(latestDdlTime)) break block20;
                            optional2 = Optional.empty();
                            if (rs == null) break block21;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return optional2;
                }
                optional = Optional.of(Scn.valueOf(latestDdlTime));
                if (rs == null) break block22;
                rs.close();
            }
            return optional;
        }
        catch (SQLException e2) {
            if (e2.getErrorCode() == 8180) {
                LOGGER.info("No latest table SCN could be resolved, defaulting to current SCN");
                return Optional.empty();
            }
            throw e2;
        }
    }

    @Override
    protected void readTableStructure(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> snapshotContext, OracleOffsetContext offsetContext) throws SQLException, InterruptedException {
        Set schemas = snapshotContext.capturedTables.stream().map(TableId::schema).collect(Collectors.toSet());
        for (String schema : schemas) {
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while reading structure of schema " + schema);
            }
            this.jdbcConnection.readSchema(snapshotContext.tables, snapshotContext.catalogName, schema, this.connectorConfig.getTableFilters().dataCollectionFilter(), null, false);
        }
    }

    @Override
    protected String enhanceOverriddenSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> snapshotContext, String overriddenSelect, TableId tableId) {
        String snapshotOffset = (String)((OracleOffsetContext)snapshotContext.offset).getOffset().get("scn");
        String token = this.connectorConfig.getTokenToReplaceInSnapshotPredicate();
        if (token != null) {
            return overriddenSelect.replaceAll(token, " AS OF SCN " + snapshotOffset);
        }
        return overriddenSelect;
    }

    @Override
    protected SchemaChangeEvent getCreateTableEvent(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> snapshotContext, Table table) throws SQLException {
        return new SchemaChangeEvent(((OracleOffsetContext)snapshotContext.offset).getPartition(), ((OracleOffsetContext)snapshotContext.offset).getOffset(), ((OracleOffsetContext)snapshotContext.offset).getSourceInfo(), snapshotContext.catalogName, table.id().schema(), this.jdbcConnection.getTableMetadataDdl(table.id()), table, SchemaChangeEvent.SchemaChangeEventType.CREATE, true);
    }

    @Override
    protected Optional<String> getSnapshotSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> snapshotContext, TableId tableId) {
        OracleOffsetContext offset = (OracleOffsetContext)snapshotContext.offset;
        String snapshotOffset = offset.getScn().toString();
        assert (snapshotOffset != null);
        return Optional.of("SELECT * FROM " + OracleSnapshotChangeEventSource.quote(tableId) + " AS OF SCN " + snapshotOffset);
    }

    @Override
    protected void complete(AbstractSnapshotChangeEventSource.SnapshotContext<OracleOffsetContext> snapshotContext) {
        if (this.connectorConfig.getPdbName() != null) {
            this.jdbcConnection.resetSessionToCdb();
        }
    }

    private static String quote(TableId tableId) {
        return TableId.parse(tableId.schema() + "." + tableId.table(), true).toDoubleQuotedString();
    }

    private static class OracleSnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OracleOffsetContext> {
        private Savepoint preSchemaSnapshotSavepoint;

        public OracleSnapshotContext(String catalogName) throws SQLException {
            super(catalogName);
        }
    }
}

