/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.SourceInfo;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionId;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OracleOffsetContext
implements OffsetContext {
    public static final String SERVER_PARTITION_KEY = "server";
    public static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    private final Schema sourceInfoSchema;
    private final Map<String, String> partition;
    private final SourceInfo sourceInfo;
    private final TransactionContext transactionContext;
    private boolean snapshotCompleted;

    public OracleOffsetContext(OracleConnectorConfig connectorConfig, Scn scn, Scn commitScn, String lcrPosition, boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext) {
        this(connectorConfig, scn, lcrPosition, snapshot, snapshotCompleted, transactionContext);
        this.sourceInfo.setCommitScn(commitScn);
    }

    public OracleOffsetContext(OracleConnectorConfig connectorConfig, Scn scn, String lcrPosition, boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext) {
        this.partition = Collections.singletonMap(SERVER_PARTITION_KEY, connectorConfig.getLogicalName());
        this.sourceInfo = new SourceInfo(connectorConfig);
        this.sourceInfo.setScn(scn);
        this.sourceInfo.setLcrPosition(lcrPosition);
        this.sourceInfoSchema = this.sourceInfo.schema();
        this.transactionContext = transactionContext;
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            this.sourceInfo.setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
    }

    public static Builder create() {
        return new Builder();
    }

    @Override
    public Map<String, ?> getPartition() {
        return this.partition;
    }

    @Override
    public Map<String, ?> getOffset() {
        if (this.sourceInfo.isSnapshot()) {
            HashMap<String, Object> offset = new HashMap<String, Object>();
            Scn scn = this.sourceInfo.getScn();
            offset.put("scn", scn != null ? scn.toString() : scn);
            offset.put("snapshot", true);
            offset.put(SNAPSHOT_COMPLETED_KEY, this.snapshotCompleted);
            return offset;
        }
        HashMap<String, Object> offset = new HashMap<String, Object>();
        if (this.sourceInfo.getLcrPosition() != null) {
            offset.put("lcr_position", this.sourceInfo.getLcrPosition());
        } else {
            Scn scn = this.sourceInfo.getScn();
            Scn commitScn = this.sourceInfo.getCommitScn();
            offset.put("scn", scn != null ? scn.toString() : null);
            offset.put("commit_scn", commitScn != null ? commitScn.toString() : null);
        }
        return this.transactionContext.store(offset);
    }

    @Override
    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    @Override
    public Struct getSourceInfo() {
        return this.sourceInfo.struct();
    }

    public void setScn(Scn scn) {
        this.sourceInfo.setScn(scn);
    }

    public void setCommitScn(Scn commitScn) {
        this.sourceInfo.setCommitScn(commitScn);
    }

    public Scn getScn() {
        return this.sourceInfo.getScn();
    }

    public Scn getCommitScn() {
        return this.sourceInfo.getCommitScn();
    }

    public void setLcrPosition(String lcrPosition) {
        this.sourceInfo.setLcrPosition(lcrPosition);
    }

    public String getLcrPosition() {
        return this.sourceInfo.getLcrPosition();
    }

    public void setTransactionId(String transactionId) {
        this.sourceInfo.setTransactionId(transactionId);
    }

    public void setSourceTime(Instant instant) {
        this.sourceInfo.setSourceTime(instant);
    }

    public void setTableId(TableId tableId) {
        this.sourceInfo.tableEvent(tableId);
    }

    @Override
    public boolean isSnapshotRunning() {
        return this.sourceInfo.isSnapshot() && !this.snapshotCompleted;
    }

    @Override
    public void preSnapshotStart() {
        this.sourceInfo.setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    @Override
    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    @Override
    public void postSnapshotCompletion() {
        this.sourceInfo.setSnapshot(SnapshotRecord.FALSE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OracleOffsetContext [scn=").append(this.getScn());
        if (this.sourceInfo.isSnapshot()) {
            sb.append(", snapshot=").append(this.sourceInfo.isSnapshot());
            sb.append(", snapshot_completed=").append(this.snapshotCompleted);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void markLastSnapshotRecord() {
        this.sourceInfo.setSnapshot(SnapshotRecord.LAST);
    }

    @Override
    public void event(DataCollectionId tableId, Instant timestamp) {
        this.sourceInfo.tableEvent((TableId)tableId);
        this.sourceInfo.setSourceTime(timestamp);
    }

    public void tableEvent(TableId tableId, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.tableEvent(tableId);
    }

    public void tableEvent(Set<TableId> tableIds, Instant timestamp) {
        this.sourceInfo.setSourceTime(timestamp);
        this.sourceInfo.tableEvent(tableIds);
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public static Scn getScnFromOffsetMapByKey(Map<String, ?> offset, String key) {
        Object scn = offset.get(key);
        if (scn instanceof String) {
            return Scn.valueOf((String)scn);
        }
        if (scn != null) {
            return Scn.valueOf((Long)scn);
        }
        return null;
    }

    public static class Builder {
        private OracleConnectorConfig connectorConfig;
        private Scn scn;
        private String lcrPosition;
        private boolean snapshot;
        private boolean snapshotCompleted;
        private TransactionContext transactionContext;

        public Builder logicalName(OracleConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
            return this;
        }

        public Builder scn(Scn scn) {
            this.scn = scn;
            return this;
        }

        public Builder lcrPosition(String lcrPosition) {
            this.lcrPosition = lcrPosition;
            return this;
        }

        public Builder snapshot(boolean snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        public Builder snapshotCompleted(boolean snapshotCompleted) {
            this.snapshotCompleted = snapshotCompleted;
            return this;
        }

        public Builder transactionContext(TransactionContext transactionContext) {
            this.transactionContext = transactionContext;
            return this;
        }

        OracleOffsetContext build() {
            return new OracleOffsetContext(this.connectorConfig, this.scn, this.lcrPosition, this.snapshot, this.snapshotCompleted, this.transactionContext);
        }
    }
}

