/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.workload;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.NewTopic;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartitionsSpec
extends Message {
    private static final short DEFAULT_REPLICATION_FACTOR = 3;
    private static final short DEFAULT_NUM_PARTITIONS = 1;
    private final int numPartitions;
    private final short replicationFactor;
    private final Map<Integer, List<Integer>> partitionAssignments;
    private final Map<String, String> configs;

    @JsonCreator
    public PartitionsSpec(@JsonProperty(value="numPartitions") int numPartitions, @JsonProperty(value="replicationFactor") short replicationFactor, @JsonProperty(value="partitionAssignments") Map<Integer, List<Integer>> partitionAssignments, @JsonProperty(value="configs") Map<String, String> configs) {
        this.numPartitions = numPartitions;
        this.replicationFactor = replicationFactor;
        HashMap partMap = new HashMap();
        if (partitionAssignments != null) {
            for (Map.Entry<Integer, List<Integer>> entry : partitionAssignments.entrySet()) {
                int partition = entry.getKey() == null ? 0 : entry.getKey();
                ArrayList<Integer> assignments = new ArrayList<Integer>();
                if (entry.getValue() != null) {
                    for (Integer brokerId : entry.getValue()) {
                        assignments.add(brokerId == null ? Integer.valueOf(0) : brokerId);
                    }
                }
                partMap.put(partition, Collections.unmodifiableList(assignments));
            }
        }
        this.partitionAssignments = Collections.unmodifiableMap(partMap);
        this.configs = configs == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(configs));
    }

    @JsonProperty
    public int numPartitions() {
        return this.numPartitions;
    }

    public List<Integer> partitionNumbers() {
        if (this.partitionAssignments.isEmpty()) {
            ArrayList<Integer> partitionNumbers = new ArrayList<Integer>();
            int effectiveNumPartitions = this.numPartitions <= 0 ? 1 : this.numPartitions;
            for (int i2 = 0; i2 < effectiveNumPartitions; ++i2) {
                partitionNumbers.add(i2);
            }
            return partitionNumbers;
        }
        return new ArrayList<Integer>(this.partitionAssignments.keySet());
    }

    @JsonProperty
    public short replicationFactor() {
        return this.replicationFactor;
    }

    @JsonProperty
    public Map<Integer, List<Integer>> partitionAssignments() {
        return this.partitionAssignments;
    }

    @JsonProperty
    public Map<String, String> configs() {
        return this.configs;
    }

    public NewTopic newTopic(String topicName) {
        NewTopic newTopic;
        if (this.partitionAssignments.isEmpty()) {
            int effectiveNumPartitions = this.numPartitions <= 0 ? 1 : this.numPartitions;
            short effectiveReplicationFactor = this.replicationFactor <= 0 ? (short)3 : (short)this.replicationFactor;
            newTopic = new NewTopic(topicName, effectiveNumPartitions, effectiveReplicationFactor);
        } else {
            newTopic = new NewTopic(topicName, this.partitionAssignments);
        }
        if (!this.configs.isEmpty()) {
            newTopic.configs(this.configs);
        }
        return newTopic;
    }
}

