/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.InvalidRequestException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.ErrorResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.rest.RequestConflictException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionMapper.class);

    public Response toResponse(Throwable e2) {
        if (log.isDebugEnabled()) {
            log.debug("Uncaught exception in REST call: ", e2);
        } else if (log.isInfoEnabled()) {
            log.info("Uncaught exception in REST call: {}", (Object)e2.getMessage());
        }
        if (e2 instanceof NotFoundException) {
            return this.buildResponse(Response.Status.NOT_FOUND, e2);
        }
        if (e2 instanceof InvalidRequestException) {
            return this.buildResponse(Response.Status.BAD_REQUEST, e2);
        }
        if (e2 instanceof InvalidTypeIdException) {
            return this.buildResponse(Response.Status.NOT_IMPLEMENTED, e2);
        }
        if (e2 instanceof JsonMappingException) {
            return this.buildResponse(Response.Status.BAD_REQUEST, e2);
        }
        if (e2 instanceof ClassNotFoundException) {
            return this.buildResponse(Response.Status.NOT_IMPLEMENTED, e2);
        }
        if (e2 instanceof SerializationException) {
            return this.buildResponse(Response.Status.BAD_REQUEST, e2);
        }
        if (e2 instanceof RequestConflictException) {
            return this.buildResponse(Response.Status.CONFLICT, e2);
        }
        return this.buildResponse(Response.Status.INTERNAL_SERVER_ERROR, e2);
    }

    public static Exception toException(int code, String msg) throws Exception {
        if (code == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new NotFoundException(msg);
        }
        if (code == Response.Status.NOT_IMPLEMENTED.getStatusCode()) {
            throw new ClassNotFoundException(msg);
        }
        if (code == Response.Status.BAD_REQUEST.getStatusCode()) {
            throw new InvalidRequestException(msg);
        }
        if (code == Response.Status.CONFLICT.getStatusCode()) {
            throw new RequestConflictException(msg);
        }
        throw new RuntimeException(msg);
    }

    private Response buildResponse(Response.Status code, Throwable e2) {
        return Response.status((Response.Status)code).entity((Object)new ErrorResponse(code.getStatusCode(), e2.getMessage())).build();
    }
}

