/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.PluginUtils;
import java.net.URL;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);
    private final URL pluginLocation;

    public PluginClassLoader(URL pluginLocation, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.pluginLocation = pluginLocation;
    }

    public PluginClassLoader(URL pluginLocation, URL[] urls) {
        super(urls);
        this.pluginLocation = pluginLocation;
    }

    public String location() {
        return this.pluginLocation.toString();
    }

    public String toString() {
        return "PluginClassLoader{pluginLocation=" + this.pluginLocation + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> klass = this.findLoadedClass(name);
            if (klass == null) {
                try {
                    if (PluginUtils.shouldLoadInIsolation(name)) {
                        klass = this.findClass(name);
                    }
                }
                catch (ClassNotFoundException e2) {
                    log.trace("Class '{}' not found. Delegating to parent", (Object)name);
                }
            }
            if (klass == null) {
                klass = super.loadClass(name, false);
            }
            if (resolve) {
                this.resolveClass(klass);
            }
            return klass;
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

