/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.converters;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.Deserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.Serializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.converters.NumberConverterConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.Converter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.ConverterType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.HeaderConverter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

abstract class NumberConverter<T extends Number>
implements Converter,
HeaderConverter {
    private final Serializer<T> serializer;
    private final Deserializer<T> deserializer;
    private final String typeName;
    private final Schema schema;

    protected NumberConverter(String typeName, Schema schema, Serializer<T> serializer, Deserializer<T> deserializer) {
        this.typeName = typeName;
        this.schema = schema;
        this.serializer = serializer;
        this.deserializer = deserializer;
        assert (this.serializer != null);
        assert (this.deserializer != null);
        assert (this.typeName != null);
        assert (this.schema != null);
    }

    @Override
    public ConfigDef config() {
        return NumberConverterConfig.configDef();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        NumberConverterConfig conf = new NumberConverterConfig(configs);
        boolean isKey = conf.type() == ConverterType.KEY;
        this.serializer.configure(configs, isKey);
        this.deserializer.configure(configs, isKey);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        HashMap conf = new HashMap(configs);
        conf.put("converter.type", isKey ? ConverterType.KEY.getName() : ConverterType.VALUE.getName());
        this.configure(conf);
    }

    protected T cast(Object value) {
        return (T)((Number)value);
    }

    @Override
    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        try {
            return this.serializer.serialize(topic, value == null ? null : (Object)this.cast(value));
        }
        catch (ClassCastException e2) {
            throw new DataException("Failed to serialize to " + this.typeName + " (was " + value.getClass() + "): ", e2);
        }
        catch (SerializationException e3) {
            throw new DataException("Failed to serialize to " + this.typeName + ": ", e3);
        }
    }

    @Override
    public SchemaAndValue toConnectData(String topic, byte[] value) {
        try {
            return new SchemaAndValue(this.schema, this.deserializer.deserialize(topic, value));
        }
        catch (SerializationException e2) {
            throw new DataException("Failed to deserialize " + this.typeName + ": ", e2);
        }
    }

    @Override
    public byte[] fromConnectHeader(String topic, String headerKey, Schema schema, Object value) {
        return this.fromConnectData(topic, schema, value);
    }

    @Override
    public SchemaAndValue toConnectHeader(String topic, String headerKey, byte[] value) {
        return this.toConnectData(topic, value);
    }

    @Override
    public void close() throws IOException {
    }
}

