/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Checksums;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Java;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.PureJavaCrc32C;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;

public final class Crc32C {
    private static final ChecksumFactory CHECKSUM_FACTORY = Java.IS_JAVA9_COMPATIBLE ? new Java9ChecksumFactory() : new PureJavaChecksumFactory();

    private Crc32C() {
    }

    public static long compute(byte[] bytes, int offset, int size) {
        Checksum crc = Crc32C.create();
        crc.update(bytes, offset, size);
        return crc.getValue();
    }

    public static long compute(ByteBuffer buffer, int offset, int size) {
        Checksum crc = Crc32C.create();
        Checksums.update(crc, buffer, offset, size);
        return crc.getValue();
    }

    public static Checksum create() {
        return CHECKSUM_FACTORY.create();
    }

    private static class PureJavaChecksumFactory
    implements ChecksumFactory {
        private PureJavaChecksumFactory() {
        }

        @Override
        public Checksum create() {
            return new PureJavaCrc32C();
        }
    }

    private static class Java9ChecksumFactory
    implements ChecksumFactory {
        private static final MethodHandle CONSTRUCTOR;

        private Java9ChecksumFactory() {
        }

        @Override
        public Checksum create() {
            try {
                return CONSTRUCTOR.invoke();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        static {
            try {
                Class<?> cls = Class.forName("java.util.zip.CRC32C");
                CONSTRUCTOR = MethodHandles.publicLookup().findConstructor(cls, MethodType.methodType(Void.TYPE));
            }
            catch (ReflectiveOperationException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static interface ChecksumFactory {
        public Checksum create();
    }
}

