/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class Bytes
implements Comparable<Bytes> {
    public static final byte[] EMPTY = new byte[0];
    private static final char[] HEX_CHARS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final byte[] bytes;
    private int hashCode;
    public static final ByteArrayComparator BYTES_LEXICO_COMPARATOR = new LexicographicByteArrayComparator();

    public static Bytes wrap(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new Bytes(bytes);
    }

    public Bytes(byte[] bytes) {
        this.bytes = bytes;
        this.hashCode = 0;
    }

    public byte[] get() {
        return this.bytes;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.bytes);
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (other instanceof Bytes) {
            return Arrays.equals(this.bytes, ((Bytes)other).get());
        }
        return false;
    }

    @Override
    public int compareTo(Bytes that) {
        return BYTES_LEXICO_COMPARATOR.compare(this.bytes, that.bytes);
    }

    public String toString() {
        return Bytes.toString(this.bytes, 0, this.bytes.length);
    }

    private static String toString(byte[] b2, int off, int len) {
        StringBuilder result = new StringBuilder();
        if (b2 == null) {
            return result.toString();
        }
        if (off >= b2.length) {
            return result.toString();
        }
        if (off + len > b2.length) {
            len = b2.length - off;
        }
        for (int i2 = off; i2 < off + len; ++i2) {
            int ch = b2[i2] & 0xFF;
            if (ch >= 32 && ch <= 126 && ch != 92) {
                result.append((char)ch);
                continue;
            }
            result.append("\\x");
            result.append(HEX_CHARS_UPPER[ch / 16]);
            result.append(HEX_CHARS_UPPER[ch % 16]);
        }
        return result.toString();
    }

    public static Bytes increment(Bytes input) throws IndexOutOfBoundsException {
        byte[] inputArr = input.get();
        byte[] ret = new byte[inputArr.length];
        byte carry = 1;
        for (int i2 = inputArr.length - 1; i2 >= 0; --i2) {
            if (inputArr[i2] == -1 && carry == 1) {
                ret[i2] = 0;
                continue;
            }
            ret[i2] = (byte)(inputArr[i2] + carry);
            carry = 0;
        }
        if (carry == 0) {
            return Bytes.wrap(ret);
        }
        throw new IndexOutOfBoundsException();
    }

    private static class LexicographicByteArrayComparator
    implements ByteArrayComparator {
        private LexicographicByteArrayComparator() {
        }

        @Override
        public int compare(byte[] buffer1, byte[] buffer2) {
            return this.compare(buffer1, 0, buffer1.length, buffer2, 0, buffer2.length);
        }

        @Override
        public int compare(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
            if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
                return 0;
            }
            int end1 = offset1 + length1;
            int end2 = offset2 + length2;
            int i2 = offset1;
            for (int j2 = offset2; i2 < end1 && j2 < end2; ++i2, ++j2) {
                int a2 = buffer1[i2] & 0xFF;
                int b2 = buffer2[j2] & 0xFF;
                if (a2 == b2) continue;
                return a2 - b2;
            }
            return length1 - length2;
        }
    }

    public static interface ByteArrayComparator
    extends Comparator<byte[]>,
    Serializable {
        public int compare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);
    }
}

