/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.SaslHandshakeRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.SaslHandshakeResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ApiError;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.SaslHandshakeResponse;
import java.nio.ByteBuffer;

public class SaslHandshakeRequest
extends AbstractRequest {
    private final SaslHandshakeRequestData data;

    public SaslHandshakeRequest(SaslHandshakeRequestData data) {
        this(data, ApiKeys.SASL_HANDSHAKE.latestVersion());
    }

    public SaslHandshakeRequest(SaslHandshakeRequestData data, short version) {
        super(ApiKeys.SASL_HANDSHAKE, version);
        this.data = data;
    }

    public SaslHandshakeRequest(Struct struct, short version) {
        super(ApiKeys.SASL_HANDSHAKE, version);
        this.data = new SaslHandshakeRequestData(struct, version);
    }

    public SaslHandshakeRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        SaslHandshakeResponseData response = new SaslHandshakeResponseData();
        response.setErrorCode(ApiError.fromThrowable(e2).error().code());
        return new SaslHandshakeResponse(response);
    }

    public static SaslHandshakeRequest parse(ByteBuffer buffer, short version) {
        return new SaslHandshakeRequest(ApiKeys.SASL_HANDSHAKE.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<SaslHandshakeRequest> {
        private final SaslHandshakeRequestData data;

        public Builder(SaslHandshakeRequestData data) {
            super(ApiKeys.SASL_HANDSHAKE);
            this.data = data;
        }

        @Override
        public SaslHandshakeRequest build(short version) {
            return new SaslHandshakeRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

