/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.EndQuorumEpochRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.EndQuorumEpochResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.EndQuorumEpochResponse;
import java.util.Collections;
import java.util.List;

public class EndQuorumEpochRequest
extends AbstractRequest {
    public final EndQuorumEpochRequestData data;

    private EndQuorumEpochRequest(EndQuorumEpochRequestData data, short version) {
        super(ApiKeys.END_QUORUM_EPOCH, version);
        this.data = data;
    }

    public EndQuorumEpochRequest(Struct struct, short version) {
        super(ApiKeys.END_QUORUM_EPOCH, version);
        this.data = new EndQuorumEpochRequestData(struct, version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    @Override
    public EndQuorumEpochResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        return new EndQuorumEpochResponse(new EndQuorumEpochResponseData().setErrorCode(Errors.forException(e2).code()));
    }

    public static EndQuorumEpochRequestData singletonRequest(TopicPartition topicPartition, int replicaId, int leaderEpoch, int leaderId, List<Integer> preferredSuccessors) {
        return EndQuorumEpochRequest.singletonRequest(topicPartition, null, replicaId, leaderEpoch, leaderId, preferredSuccessors);
    }

    public static EndQuorumEpochRequestData singletonRequest(TopicPartition topicPartition, String clusterId, int replicaId, int leaderEpoch, int leaderId, List<Integer> preferredSuccessors) {
        return new EndQuorumEpochRequestData().setClusterId(clusterId).setTopics(Collections.singletonList(new EndQuorumEpochRequestData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new EndQuorumEpochRequestData.PartitionData().setPartitionIndex(topicPartition.partition()).setReplicaId(replicaId).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setPreferredSuccessors(preferredSuccessors)))));
    }

    public static class Builder
    extends AbstractRequest.Builder<EndQuorumEpochRequest> {
        private final EndQuorumEpochRequestData data;

        public Builder(EndQuorumEpochRequestData data) {
            super(ApiKeys.END_QUORUM_EPOCH);
            this.data = data;
        }

        @Override
        public EndQuorumEpochRequest build(short version) {
            return new EndQuorumEpochRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

