/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.metrics.stats;

public class Histogram {
    private final BinScheme binScheme;
    private final float[] hist;
    private double count;

    public Histogram(BinScheme binScheme) {
        this.hist = new float[binScheme.bins()];
        this.count = 0.0;
        this.binScheme = binScheme;
    }

    public void record(double value) {
        int n2 = this.binScheme.toBin(value);
        this.hist[n2] = this.hist[n2] + 1.0f;
        this.count += 1.0;
    }

    public double value(double quantile) {
        if (this.count == 0.0) {
            return Double.NaN;
        }
        if (quantile > 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (quantile < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        float sum = 0.0f;
        float quant = (float)quantile;
        for (int i2 = 0; i2 < this.hist.length - 1; ++i2) {
            if (!((double)(sum += this.hist[i2]) / this.count > (double)quant)) continue;
            return this.binScheme.fromBin(i2);
        }
        return this.binScheme.fromBin(this.hist.length - 1);
    }

    public float[] counts() {
        return this.hist;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.hist.length; ++i2) {
            this.hist[i2] = 0.0f;
        }
        this.count = 0.0;
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder("{");
        for (int i2 = 0; i2 < this.hist.length - 1; ++i2) {
            b2.append(String.format("%.10f", this.binScheme.fromBin(i2)));
            b2.append(':');
            b2.append(String.format("%.0f", Float.valueOf(this.hist[i2])));
            b2.append(',');
        }
        b2.append(Float.POSITIVE_INFINITY);
        b2.append(':');
        b2.append(String.format("%.0f", Float.valueOf(this.hist[this.hist.length - 1])));
        b2.append('}');
        return b2.toString();
    }

    public static class LinearBinScheme
    implements BinScheme {
        private final int bins;
        private final double max;
        private final double scale;

        public LinearBinScheme(int numBins, double max) {
            if (numBins < 2) {
                throw new IllegalArgumentException("Must have at least 2 bins.");
            }
            this.bins = numBins;
            this.max = max;
            double denom = (double)numBins * ((double)numBins - 1.0) / 2.0;
            this.scale = max / denom;
        }

        @Override
        public int bins() {
            return this.bins;
        }

        @Override
        public double fromBin(int b2) {
            if (b2 > this.bins - 1) {
                return Double.POSITIVE_INFINITY;
            }
            if ((double)b2 < 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return this.scale * ((double)b2 * ((double)b2 + 1.0)) / 2.0;
        }

        @Override
        public int toBin(double x2) {
            if (x2 < 0.0) {
                throw new IllegalArgumentException("Values less than 0.0 not accepted.");
            }
            if (x2 > this.max) {
                return this.bins - 1;
            }
            return (int)(-0.5 + 0.5 * Math.sqrt(1.0 + 8.0 * x2 / this.scale));
        }
    }

    public static class ConstantBinScheme
    implements BinScheme {
        private static final int MIN_BIN_NUMBER = 0;
        private final double min;
        private final double max;
        private final int bins;
        private final double bucketWidth;
        private final int maxBinNumber;

        public ConstantBinScheme(int bins, double min, double max) {
            if (bins < 2) {
                throw new IllegalArgumentException("Must have at least 2 bins.");
            }
            this.min = min;
            this.max = max;
            this.bins = bins;
            this.bucketWidth = (max - min) / (double)bins;
            this.maxBinNumber = bins - 1;
        }

        @Override
        public int bins() {
            return this.bins;
        }

        @Override
        public double fromBin(int b2) {
            if (b2 < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (b2 > this.maxBinNumber) {
                return Double.POSITIVE_INFINITY;
            }
            return this.min + (double)b2 * this.bucketWidth;
        }

        @Override
        public int toBin(double x2) {
            int binNumber = (int)((x2 - this.min) / this.bucketWidth);
            if (binNumber < 0) {
                return 0;
            }
            return Math.min(binNumber, this.maxBinNumber);
        }
    }

    public static interface BinScheme {
        public int bins();

        public int toBin(double var1);

        public double fromBin(int var1);
    }
}

