/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiMessage;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Message;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Readable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class AlterClientQuotasRequestData
implements ApiMessage {
    List<EntryData> entries;
    boolean validateOnly;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("entries", new ArrayOf(EntryData.SCHEMA_0), "The quota configuration entries to alter."), new Field("validate_only", Type.BOOLEAN, "Whether the alteration should be validated, but not performed."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterClientQuotasRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AlterClientQuotasRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public AlterClientQuotasRequestData() {
        this.entries = new ArrayList<EntryData>(0);
        this.validateOnly = false;
    }

    @Override
    public short apiKey() {
        return 49;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field entries was serialized as null");
        }
        ArrayList<EntryData> newCollection = new ArrayList<EntryData>(arrayLength);
        for (int i2 = 0; i2 < arrayLength; ++i2) {
            newCollection.add(new EntryData(_readable, _version));
        }
        this.entries = newCollection;
        this.validateOnly = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.entries.size());
        for (EntryData entriesElement : this.entries) {
            entriesElement.write(_writable, _cache, _version);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("entries");
        this.entries = new ArrayList<EntryData>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.entries.add(new EntryData((Struct)nestedObject, _version));
        }
        this.validateOnly = struct.getBoolean("validate_only");
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.entries.size()];
        int i2 = 0;
        for (EntryData element : this.entries) {
            _nestedObjects[i2++] = element.toStruct(_version);
        }
        struct.set("entries", (Object)_nestedObjects);
        struct.set("validate_only", (Object)this.validateOnly);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        for (EntryData entriesElement : this.entries) {
            _arraySize += entriesElement.size(_cache, _version);
        }
        _size += _arraySize;
        ++_size;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterClientQuotasRequestData)) {
            return false;
        }
        AlterClientQuotasRequestData other = (AlterClientQuotasRequestData)obj;
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.entries == null ? 0 : this.entries.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public AlterClientQuotasRequestData duplicate() {
        AlterClientQuotasRequestData _duplicate = new AlterClientQuotasRequestData();
        ArrayList<EntryData> newEntries = new ArrayList<EntryData>(this.entries.size());
        for (EntryData _element : this.entries) {
            newEntries.add(_element.duplicate());
        }
        _duplicate.entries = newEntries;
        _duplicate.validateOnly = this.validateOnly;
        return _duplicate;
    }

    public String toString() {
        return "AlterClientQuotasRequestData(entries=" + MessageUtil.deepToString(this.entries.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public List<EntryData> entries() {
        return this.entries;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterClientQuotasRequestData setEntries(List<EntryData> v2) {
        this.entries = v2;
        return this;
    }

    public AlterClientQuotasRequestData setValidateOnly(boolean v2) {
        this.validateOnly = v2;
        return this;
    }

    public static class OpData
    implements Message {
        String key;
        double value;
        boolean remove;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("key", Type.STRING, "The quota configuration key."), new Field("value", Type.FLOAT64, "The value to set, otherwise ignored if the value is to be removed."), new Field("remove", Type.BOOLEAN, "Whether the quota configuration value should be removed, otherwise set."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public OpData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OpData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public OpData() {
            this.key = "";
            this.value = 0.0;
            this.remove = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OpData");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _readable.readString(length);
            this.value = _readable.readDouble();
            this.remove = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.key);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeDouble(this.value);
            _writable.writeByte(this.remove ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OpData");
            }
            this._unknownTaggedFields = null;
            this.key = struct.getString("key");
            this.value = struct.getDouble("value");
            this.remove = struct.getBoolean("remove");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OpData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("key", (Object)this.key);
            struct.set("value", (Object)this.value);
            struct.set("remove", (Object)this.remove);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OpData");
            }
            byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.key, _stringBytes);
            _size += _stringBytes.length + 2;
            _size += 8;
            ++_size;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OpData)) {
                return false;
            }
            OpData other = (OpData)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.value != other.value) {
                return false;
            }
            if (this.remove != other.remove) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
            hashCode = 31 * hashCode + Double.hashCode(this.value);
            hashCode = 31 * hashCode + (this.remove ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public OpData duplicate() {
            OpData _duplicate = new OpData();
            _duplicate.key = this.key;
            _duplicate.value = this.value;
            _duplicate.remove = this.remove;
            return _duplicate;
        }

        public String toString() {
            return "OpData(key=" + (this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + this.value + ", remove=" + (this.remove ? "true" : "false") + ")";
        }

        public String key() {
            return this.key;
        }

        public double value() {
            return this.value;
        }

        public boolean remove() {
            return this.remove;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OpData setKey(String v2) {
            this.key = v2;
            return this;
        }

        public OpData setValue(double v2) {
            this.value = v2;
            return this;
        }

        public OpData setRemove(boolean v2) {
            this.remove = v2;
            return this;
        }
    }

    public static class EntityData
    implements Message {
        String entityType;
        String entityName;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("entity_type", Type.STRING, "The entity type."), new Field("entity_name", Type.NULLABLE_STRING, "The name of the entity, or null if the default."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public EntityData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public EntityData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public EntityData() {
            this.entityType = "";
            this.entityName = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntityData");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field entityType was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field entityType had invalid length " + length);
            }
            this.entityType = _readable.readString(length);
            length = _readable.readShort();
            if (length < 0) {
                this.entityName = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field entityName had invalid length " + length);
                }
                this.entityName = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.entityType);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            if (this.entityName == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.entityName);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntityData");
            }
            this._unknownTaggedFields = null;
            this.entityType = struct.getString("entity_type");
            this.entityName = struct.getString("entity_name");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of EntityData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("entity_type", (Object)this.entityType);
            struct.set("entity_name", (Object)this.entityName);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntityData");
            }
            byte[] _stringBytes = this.entityType.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'entityType' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.entityType, _stringBytes);
            _size += _stringBytes.length + 2;
            if (this.entityName == null) {
                _size += 2;
            } else {
                _stringBytes = this.entityName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'entityName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.entityName, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntityData)) {
                return false;
            }
            EntityData other = (EntityData)obj;
            if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
                return false;
            }
            if (this.entityName == null ? other.entityName != null : !this.entityName.equals(other.entityName)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.entityType == null ? 0 : this.entityType.hashCode());
            hashCode = 31 * hashCode + (this.entityName == null ? 0 : this.entityName.hashCode());
            return hashCode;
        }

        @Override
        public EntityData duplicate() {
            EntityData _duplicate = new EntityData();
            _duplicate.entityType = this.entityType;
            _duplicate.entityName = this.entityName == null ? null : this.entityName;
            return _duplicate;
        }

        public String toString() {
            return "EntityData(entityType=" + (this.entityType == null ? "null" : "'" + this.entityType.toString() + "'") + ", entityName=" + (this.entityName == null ? "null" : "'" + this.entityName.toString() + "'") + ")";
        }

        public String entityType() {
            return this.entityType;
        }

        public String entityName() {
            return this.entityName;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntityData setEntityType(String v2) {
            this.entityType = v2;
            return this;
        }

        public EntityData setEntityName(String v2) {
            this.entityName = v2;
            return this;
        }
    }

    public static class EntryData
    implements Message {
        List<EntityData> entity;
        List<OpData> ops;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("entity", new ArrayOf(EntityData.SCHEMA_0), "The quota entity to alter."), new Field("ops", new ArrayOf(OpData.SCHEMA_0), "An individual quota configuration entry to alter."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public EntryData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public EntryData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public EntryData() {
            this.entity = new ArrayList<EntityData>(0);
            this.ops = new ArrayList<OpData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i2;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field entity was serialized as null");
            }
            ArrayList<EntityData> newCollection = new ArrayList<EntityData>(arrayLength);
            for (i2 = 0; i2 < arrayLength; ++i2) {
                newCollection.add(new EntityData(_readable, _version));
            }
            this.entity = newCollection;
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field ops was serialized as null");
            }
            newCollection = new ArrayList(arrayLength);
            for (i2 = 0; i2 < arrayLength; ++i2) {
                newCollection.add((EntityData)((Object)new OpData(_readable, _version)));
            }
            this.ops = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.entity.size());
            for (EntityData entityElement : this.entity) {
                entityElement.write(_writable, _cache, _version);
            }
            _writable.writeInt(this.ops.size());
            for (OpData opsElement : this.ops) {
                opsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            this._unknownTaggedFields = null;
            Object[] _nestedObjects = struct.getArray("entity");
            this.entity = new ArrayList<EntityData>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.entity.add(new EntityData((Struct)nestedObject, _version));
            }
            _nestedObjects = struct.getArray("ops");
            this.ops = new ArrayList<OpData>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.ops.add(new OpData((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of EntryData");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            Struct[] _nestedObjects = new Struct[this.entity.size()];
            int i2 = 0;
            for (EntityData entityData : this.entity) {
                _nestedObjects[i2++] = entityData.toStruct(_version);
            }
            struct.set("entity", (Object)_nestedObjects);
            _nestedObjects = new Struct[this.ops.size()];
            int i3 = 0;
            for (OpData opData : this.ops) {
                _nestedObjects[i3++] = opData.toStruct(_version);
            }
            struct.set("ops", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntryData");
            }
            int _arraySize = 0;
            _arraySize += 4;
            for (EntityData entityElement : this.entity) {
                _arraySize += entityElement.size(_cache, _version);
            }
            _size += _arraySize;
            _arraySize = 0;
            _arraySize += 4;
            for (OpData opsElement : this.ops) {
                _arraySize += opsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryData)) {
                return false;
            }
            EntryData other = (EntryData)obj;
            if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
                return false;
            }
            if (this.ops == null ? other.ops != null : !this.ops.equals(other.ops)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.entity == null ? 0 : this.entity.hashCode());
            hashCode = 31 * hashCode + (this.ops == null ? 0 : this.ops.hashCode());
            return hashCode;
        }

        @Override
        public EntryData duplicate() {
            EntryData _duplicate = new EntryData();
            ArrayList<EntityData> newEntity = new ArrayList<EntityData>(this.entity.size());
            for (EntityData _element : this.entity) {
                newEntity.add(_element.duplicate());
            }
            _duplicate.entity = newEntity;
            ArrayList<OpData> newOps = new ArrayList<OpData>(this.ops.size());
            for (OpData _element : this.ops) {
                newOps.add(_element.duplicate());
            }
            _duplicate.ops = newOps;
            return _duplicate;
        }

        public String toString() {
            return "EntryData(entity=" + MessageUtil.deepToString(this.entity.iterator()) + ", ops=" + MessageUtil.deepToString(this.ops.iterator()) + ")";
        }

        public List<EntityData> entity() {
            return this.entity;
        }

        public List<OpData> ops() {
            return this.ops;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntryData setEntity(List<EntityData> v2) {
            this.entity = v2;
            return this;
        }

        public EntryData setOps(List<OpData> v2) {
            this.ops = v2;
            return this;
        }
    }
}

