/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.internals;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Cluster;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Configurable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionAssignorAdapter
implements ConsumerPartitionAssignor {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionAssignorAdapter.class);
    private final PartitionAssignor oldAssignor;

    PartitionAssignorAdapter(PartitionAssignor oldAssignor) {
        this.oldAssignor = oldAssignor;
    }

    @Override
    public ByteBuffer subscriptionUserData(Set<String> topics) {
        return this.oldAssignor.subscription(topics).userData();
    }

    @Override
    public ConsumerPartitionAssignor.GroupAssignment assign(Cluster metadata, ConsumerPartitionAssignor.GroupSubscription groupSubscription) {
        return PartitionAssignorAdapter.toNewGroupAssignment(this.oldAssignor.assign(metadata, PartitionAssignorAdapter.toOldGroupSubscription(groupSubscription)));
    }

    @Override
    public void onAssignment(ConsumerPartitionAssignor.Assignment assignment, ConsumerGroupMetadata metadata) {
        this.oldAssignor.onAssignment(PartitionAssignorAdapter.toOldAssignment(assignment), metadata.generationId());
    }

    @Override
    public String name() {
        return this.oldAssignor.name();
    }

    private static PartitionAssignor.Assignment toOldAssignment(ConsumerPartitionAssignor.Assignment newAssignment) {
        return new PartitionAssignor.Assignment(newAssignment.partitions(), newAssignment.userData());
    }

    private static Map<String, PartitionAssignor.Subscription> toOldGroupSubscription(ConsumerPartitionAssignor.GroupSubscription newSubscriptions) {
        HashMap<String, PartitionAssignor.Subscription> oldSubscriptions = new HashMap<String, PartitionAssignor.Subscription>();
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> entry : newSubscriptions.groupSubscription().entrySet()) {
            String member = entry.getKey();
            ConsumerPartitionAssignor.Subscription newSubscription = entry.getValue();
            oldSubscriptions.put(member, new PartitionAssignor.Subscription(newSubscription.topics(), newSubscription.userData()));
        }
        return oldSubscriptions;
    }

    private static ConsumerPartitionAssignor.GroupAssignment toNewGroupAssignment(Map<String, PartitionAssignor.Assignment> oldAssignments) {
        HashMap<String, ConsumerPartitionAssignor.Assignment> newAssignments = new HashMap<String, ConsumerPartitionAssignor.Assignment>();
        for (Map.Entry<String, PartitionAssignor.Assignment> entry : oldAssignments.entrySet()) {
            String member = entry.getKey();
            PartitionAssignor.Assignment oldAssignment = entry.getValue();
            newAssignments.put(member, new ConsumerPartitionAssignor.Assignment(oldAssignment.partitions(), oldAssignment.userData()));
        }
        return new ConsumerPartitionAssignor.GroupAssignment(newAssignments);
    }

    /*
     * WARNING - void declaration
     */
    public static List<ConsumerPartitionAssignor> getAssignorInstances(List<String> assignorClasses, Map<String, Object> configs) {
        ArrayList<ConsumerPartitionAssignor> assignors = new ArrayList<ConsumerPartitionAssignor>();
        if (assignorClasses == null) {
            return assignors;
        }
        for (String string : assignorClasses) {
            void var4_4;
            if (string instanceof String) {
                try {
                    Class<?> clazz = Class.forName(string, true, Utils.getContextOrKafkaClassLoader());
                }
                catch (ClassNotFoundException classNotFound) {
                    throw new KafkaException(string + " ClassNotFoundException exception occurred", classNotFound);
                }
            }
            if (var4_4 instanceof Class) {
                Object assignor = Utils.newInstance((Class)var4_4);
                if (assignor instanceof Configurable) {
                    ((Configurable)assignor).configure(configs);
                }
                if (assignor instanceof ConsumerPartitionAssignor) {
                    assignors.add((ConsumerPartitionAssignor)assignor);
                    continue;
                }
                if (assignor instanceof PartitionAssignor) {
                    assignors.add(new PartitionAssignorAdapter((PartitionAssignor)assignor));
                    LOG.warn("The PartitionAssignor interface has been deprecated, please implement the ConsumerPartitionAssignor interface instead.");
                    continue;
                }
                throw new KafkaException(var4_4 + " is not an instance of " + PartitionAssignor.class.getName() + " or an instance of " + ConsumerPartitionAssignor.class.getName());
            }
            throw new KafkaException("List contains element of type " + var4_4.getClass().getName() + ", expected String or Class");
        }
        return assignors;
    }
}

