/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer;

import java.util.Objects;
import java.util.Optional;

public final class OffsetAndTimestamp {
    private final long timestamp;
    private final long offset;
    private final Optional<Integer> leaderEpoch;

    public OffsetAndTimestamp(long offset, long timestamp) {
        this(offset, timestamp, Optional.empty());
    }

    public OffsetAndTimestamp(long offset, long timestamp, Optional<Integer> leaderEpoch) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Invalid negative offset");
        }
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Invalid negative timestamp");
        }
        this.offset = offset;
        this.timestamp = timestamp;
        this.leaderEpoch = leaderEpoch;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long offset() {
        return this.offset;
    }

    public Optional<Integer> leaderEpoch() {
        return this.leaderEpoch;
    }

    public String toString() {
        return "(timestamp=" + this.timestamp + ", leaderEpoch=" + this.leaderEpoch.orElse(null) + ", offset=" + this.offset + ")";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        OffsetAndTimestamp that = (OffsetAndTimestamp)o2;
        return this.timestamp == that.timestamp && this.offset == that.offset && Objects.equals(this.leaderEpoch, that.leaderEpoch);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.offset, this.leaderEpoch);
    }
}

