/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.misc;

import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.misc.MurmurHash;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.misc.ObjectEqualityComparator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Array2DHashSet<T>
implements Set<T> {
    public static final int INITAL_CAPACITY = 16;
    public static final int INITAL_BUCKET_CAPACITY = 8;
    public static final double LOAD_FACTOR = 0.75;
    protected final AbstractEqualityComparator<? super T> comparator;
    protected T[][] buckets;
    protected int n = 0;
    protected int threshold = (int)Math.floor(12.0);
    protected int currentPrime = 1;
    protected int initialBucketCapacity = 8;

    public Array2DHashSet() {
        this(null, 16, 8);
    }

    public Array2DHashSet(AbstractEqualityComparator<? super T> comparator) {
        this(comparator, 16, 8);
    }

    public Array2DHashSet(AbstractEqualityComparator<? super T> comparator, int initialCapacity, int initialBucketCapacity) {
        if (comparator == null) {
            comparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = comparator;
        this.buckets = this.createBuckets(initialCapacity);
        this.initialBucketCapacity = initialBucketCapacity;
    }

    public final T getOrAdd(T o2) {
        if (this.n > this.threshold) {
            this.expand();
        }
        return this.getOrAddImpl(o2);
    }

    protected T getOrAddImpl(T o2) {
        int b2 = this.getBucket(o2);
        T[] bucket = this.buckets[b2];
        if (bucket == null) {
            bucket = this.createBucket(this.initialBucketCapacity);
            bucket[0] = o2;
            this.buckets[b2] = bucket;
            ++this.n;
            return o2;
        }
        for (int i2 = 0; i2 < bucket.length; ++i2) {
            T existing = bucket[i2];
            if (existing == null) {
                bucket[i2] = o2;
                ++this.n;
                return o2;
            }
            if (!this.comparator.equals(existing, o2)) continue;
            return existing;
        }
        int oldLength = bucket.length;
        bucket = Arrays.copyOf(bucket, bucket.length * 2);
        this.buckets[b2] = bucket;
        bucket[oldLength] = o2;
        ++this.n;
        return o2;
    }

    public T get(T o2) {
        if (o2 == null) {
            return o2;
        }
        int b2 = this.getBucket(o2);
        T[] bucket = this.buckets[b2];
        if (bucket == null) {
            return null;
        }
        for (T e2 : bucket) {
            if (e2 == null) {
                return null;
            }
            if (!this.comparator.equals(e2, o2)) continue;
            return e2;
        }
        return null;
    }

    protected final int getBucket(T o2) {
        int hash = this.comparator.hashCode(o2);
        int b2 = hash & this.buckets.length - 1;
        return b2;
    }

    @Override
    public int hashCode() {
        int hash = MurmurHash.initialize();
        for (T[] bucket : this.buckets) {
            if (bucket == null) continue;
            for (T o2 : bucket) {
                if (o2 == null) break;
                hash = MurmurHash.update(hash, this.comparator.hashCode(o2));
            }
        }
        hash = MurmurHash.finish(hash, this.size());
        return hash;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Array2DHashSet)) {
            return false;
        }
        Array2DHashSet other = (Array2DHashSet)o2;
        if (other.size() != this.size()) {
            return false;
        }
        boolean same = this.containsAll(other);
        return same;
    }

    protected void expand() {
        T[][] old = this.buckets;
        this.currentPrime += 4;
        int newCapacity = this.buckets.length * 2;
        T[][] newTable = this.createBuckets(newCapacity);
        int[] newBucketLengths = new int[newTable.length];
        this.buckets = newTable;
        this.threshold = (int)((double)newCapacity * 0.75);
        int oldSize = this.size();
        for (T[] bucket : old) {
            if (bucket == null) continue;
            for (T o2 : bucket) {
                T[] newBucket;
                if (o2 == null) break;
                int b2 = this.getBucket(o2);
                int bucketLength = newBucketLengths[b2];
                if (bucketLength == 0) {
                    newBucket = this.createBucket(this.initialBucketCapacity);
                    newTable[b2] = newBucket;
                } else {
                    newBucket = newTable[b2];
                    if (bucketLength == newBucket.length) {
                        newBucket = Arrays.copyOf(newBucket, newBucket.length * 2);
                        newTable[b2] = newBucket;
                    }
                }
                newBucket[bucketLength] = o2;
                int n2 = b2;
                newBucketLengths[n2] = newBucketLengths[n2] + 1;
            }
        }
        assert (this.n == oldSize);
    }

    @Override
    public final boolean add(T t2) {
        T existing = this.getOrAdd(t2);
        return existing == t2;
    }

    @Override
    public final int size() {
        return this.n;
    }

    @Override
    public final boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public final boolean contains(Object o2) {
        return this.containsFast(this.asElementType(o2));
    }

    public boolean containsFast(T obj) {
        if (obj == null) {
            return false;
        }
        return this.get(obj) != null;
    }

    @Override
    public Iterator<T> iterator() {
        return new SetIterator(this.toArray());
    }

    @Override
    public T[] toArray() {
        T[] a2 = this.createBucket(this.size());
        int i2 = 0;
        for (T[] bucket : this.buckets) {
            if (bucket == null) continue;
            for (T o2 : bucket) {
                if (o2 == null) break;
                a2[i2++] = o2;
            }
        }
        return a2;
    }

    @Override
    public <U> U[] toArray(U[] a2) {
        if (a2.length < this.size()) {
            a2 = Arrays.copyOf(a2, this.size());
        }
        int i2 = 0;
        for (T[] bucket : this.buckets) {
            if (bucket == null) continue;
            for (T o2 : bucket) {
                if (o2 == null) break;
                T targetElement = o2;
                a2[i2++] = targetElement;
            }
        }
        return a2;
    }

    @Override
    public final boolean remove(Object o2) {
        return this.removeFast(this.asElementType(o2));
    }

    public boolean removeFast(T obj) {
        if (obj == null) {
            return false;
        }
        int b2 = this.getBucket(obj);
        T[] bucket = this.buckets[b2];
        if (bucket == null) {
            return false;
        }
        for (int i2 = 0; i2 < bucket.length; ++i2) {
            T e2 = bucket[i2];
            if (e2 == null) {
                return false;
            }
            if (!this.comparator.equals(e2, obj)) continue;
            System.arraycopy(bucket, i2 + 1, bucket, i2, bucket.length - i2 - 1);
            bucket[bucket.length - 1] = null;
            --this.n;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof Array2DHashSet) {
            Array2DHashSet s2 = (Array2DHashSet)collection;
            for (T[] bucket : s2.buckets) {
                if (bucket == null) continue;
                for (T o2 : bucket) {
                    if (o2 == null) break;
                    if (this.containsFast(this.asElementType(o2))) continue;
                    return false;
                }
            }
        } else {
            for (Object o3 : collection) {
                if (this.containsFast(this.asElementType(o3))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c2) {
        boolean changed = false;
        for (T o2 : c2) {
            T existing = this.getOrAdd(o2);
            if (existing == o2) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        int newsize = 0;
        for (T[] bucket : this.buckets) {
            int i2;
            if (bucket == null) continue;
            int j2 = 0;
            for (i2 = 0; i2 < bucket.length && bucket[i2] != null; ++i2) {
                if (!c2.contains(bucket[i2])) continue;
                if (i2 != j2) {
                    bucket[j2] = bucket[i2];
                }
                ++j2;
                ++newsize;
            }
            newsize += j2;
            while (j2 < i2) {
                bucket[j2] = null;
                ++j2;
            }
        }
        boolean changed = newsize != this.n;
        this.n = newsize;
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean changed = false;
        for (Object o2 : c2) {
            changed |= this.removeFast(this.asElementType(o2));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.buckets = this.createBuckets(16);
        this.n = 0;
        this.threshold = (int)Math.floor(12.0);
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        boolean first = true;
        for (T[] bucket : this.buckets) {
            if (bucket == null) continue;
            for (T o2 : bucket) {
                if (o2 == null) break;
                if (first) {
                    first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(o2.toString());
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public String toTableString() {
        StringBuilder buf = new StringBuilder();
        for (T[] bucket : this.buckets) {
            if (bucket == null) {
                buf.append("null\n");
                continue;
            }
            buf.append('[');
            boolean first = true;
            for (T o2 : bucket) {
                if (first) {
                    first = false;
                } else {
                    buf.append(" ");
                }
                if (o2 == null) {
                    buf.append("_");
                    continue;
                }
                buf.append(o2.toString());
            }
            buf.append("]\n");
        }
        return buf.toString();
    }

    protected T asElementType(Object o2) {
        return (T)o2;
    }

    protected T[][] createBuckets(int capacity) {
        return new Object[capacity][];
    }

    protected T[] createBucket(int capacity) {
        return new Object[capacity];
    }

    protected class SetIterator
    implements Iterator<T> {
        final T[] data;
        int nextIndex = 0;
        boolean removed = true;

        public SetIterator(T[] data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return this.data[this.nextIndex++];
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            Array2DHashSet.this.remove(this.data[this.nextIndex - 1]);
            this.removed = true;
        }
    }
}

