/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.dfa;

import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.Vocabulary;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.VocabularyImpl;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.dfa.DFA;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.dfa.DFAState;
import java.util.Arrays;
import java.util.List;

public class DFASerializer {
    private final DFA dfa;
    private final Vocabulary vocabulary;

    @Deprecated
    public DFASerializer(DFA dfa, String[] tokenNames) {
        this(dfa, VocabularyImpl.fromTokenNames(tokenNames));
    }

    public DFASerializer(DFA dfa, Vocabulary vocabulary) {
        this.dfa = dfa;
        this.vocabulary = vocabulary;
    }

    public String toString() {
        if (this.dfa.s0 == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        List<DFAState> states = this.dfa.getStates();
        for (DFAState s2 : states) {
            int n2 = 0;
            if (s2.edges != null) {
                n2 = s2.edges.length;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                DFAState t2 = s2.edges[i2];
                if (t2 == null || t2.stateNumber == Integer.MAX_VALUE) continue;
                buf.append(this.getStateString(s2));
                String label = this.getEdgeLabel(i2);
                buf.append("-").append(label).append("->").append(this.getStateString(t2)).append('\n');
            }
        }
        String output = buf.toString();
        if (output.length() == 0) {
            return null;
        }
        return output;
    }

    protected String getEdgeLabel(int i2) {
        return this.vocabulary.getDisplayName(i2 - 1);
    }

    protected String getStateString(DFAState s2) {
        int n2 = s2.stateNumber;
        String baseStateStr = (s2.isAcceptState ? ":" : "") + "s" + n2 + (s2.requiresFullContext ? "^" : "");
        if (s2.isAcceptState) {
            if (s2.predicates != null) {
                return baseStateStr + "=>" + Arrays.toString(s2.predicates);
            }
            return baseStateStr + "=>" + s2.prediction;
        }
        return baseStateStr;
    }
}

