/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn;

import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.ATN;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.ATNDeserializer;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.ATNState;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.ATNType;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.ActionTransition;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.AtomTransition;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.BlockStartState;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.DecisionState;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.LexerAction;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.LexerActionType;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.LexerChannelAction;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.LexerCustomAction;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.LexerModeAction;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.LexerPushModeAction;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.LexerTypeAction;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.LoopEndState;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.PrecedencePredicateTransition;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.PredicateTransition;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.RangeTransition;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.RuleStartState;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.RuleTransition;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.SetTransition;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.atn.Transition;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.misc.IntegerList;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.misc.Interval;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.misc.IntervalSet;
import com.ververica.cdc.connectors.shaded.org.antlr.v4.runtime.misc.Utils;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class ATNSerializer {
    public ATN atn;
    private List<String> tokenNames;

    public ATNSerializer(ATN atn) {
        assert (atn.grammarType != null);
        this.atn = atn;
    }

    public ATNSerializer(ATN atn, List<String> tokenNames) {
        assert (atn.grammarType != null);
        this.atn = atn;
        this.tokenNames = tokenNames;
    }

    public IntegerList serialize() {
        IntegerList data = new IntegerList();
        data.add(ATNDeserializer.SERIALIZED_VERSION);
        this.serializeUUID(data, ATNDeserializer.SERIALIZED_UUID);
        data.add(this.atn.grammarType.ordinal());
        data.add(this.atn.maxTokenType);
        int nedges = 0;
        LinkedHashMap<IntervalSet, Boolean> sets = new LinkedHashMap<IntervalSet, Boolean>();
        IntegerList nonGreedyStates = new IntegerList();
        IntegerList precedenceStates = new IntegerList();
        data.add(this.atn.states.size());
        for (ATNState s2 : this.atn.states) {
            if (s2 == null) {
                data.add(0);
                continue;
            }
            int stateType = s2.getStateType();
            if (s2 instanceof DecisionState && ((DecisionState)s2).nonGreedy) {
                nonGreedyStates.add(s2.stateNumber);
            }
            if (s2 instanceof RuleStartState && ((RuleStartState)s2).isLeftRecursiveRule) {
                precedenceStates.add(s2.stateNumber);
            }
            data.add(stateType);
            if (s2.ruleIndex == -1) {
                data.add(65535);
            } else {
                data.add(s2.ruleIndex);
            }
            if (s2.getStateType() == 12) {
                data.add(((LoopEndState)s2).loopBackState.stateNumber);
            } else if (s2 instanceof BlockStartState) {
                data.add(((BlockStartState)s2).endState.stateNumber);
            }
            if (s2.getStateType() != 7) {
                nedges += s2.getNumberOfTransitions();
            }
            for (int i2 = 0; i2 < s2.getNumberOfTransitions(); ++i2) {
                Transition t2 = s2.transition(i2);
                int edgeType = Transition.serializationTypes.get(t2.getClass());
                if (edgeType != 7 && edgeType != 8) continue;
                SetTransition st = (SetTransition)t2;
                sets.put(st.set, true);
            }
        }
        data.add(nonGreedyStates.size());
        for (int i2 = 0; i2 < nonGreedyStates.size(); ++i2) {
            data.add(nonGreedyStates.get(i2));
        }
        data.add(precedenceStates.size());
        for (int i3 = 0; i3 < precedenceStates.size(); ++i3) {
            data.add(precedenceStates.get(i3));
        }
        int nrules = this.atn.ruleToStartState.length;
        data.add(nrules);
        for (int r2 = 0; r2 < nrules; ++r2) {
            RuleStartState ruleStartState = this.atn.ruleToStartState[r2];
            data.add(ruleStartState.stateNumber);
            if (this.atn.grammarType != ATNType.LEXER) continue;
            if (this.atn.ruleToTokenType[r2] == -1) {
                data.add(65535);
                continue;
            }
            data.add(this.atn.ruleToTokenType[r2]);
        }
        int nmodes = this.atn.modeToStartState.size();
        data.add(nmodes);
        if (nmodes > 0) {
            for (ATNState aTNState : this.atn.modeToStartState) {
                data.add(aTNState.stateNumber);
            }
        }
        ArrayList<IntervalSet> bmpSets = new ArrayList<IntervalSet>();
        ArrayList<IntervalSet> arrayList = new ArrayList<IntervalSet>();
        for (IntervalSet set : sets.keySet()) {
            if (set.getMaxElement() <= 65535) {
                bmpSets.add(set);
                continue;
            }
            arrayList.add(set);
        }
        ATNSerializer.serializeSets(data, bmpSets, new CodePointSerializer(){

            @Override
            public void serializeCodePoint(IntegerList data, int cp) {
                data.add(cp);
            }
        });
        ATNSerializer.serializeSets(data, arrayList, new CodePointSerializer(){

            @Override
            public void serializeCodePoint(IntegerList data, int cp) {
                ATNSerializer.this.serializeInt(data, cp);
            }
        });
        HashMap<IntervalSet, Integer> setIndices = new HashMap<IntervalSet, Integer>();
        int setIndex = 0;
        for (IntervalSet bmpSet : bmpSets) {
            setIndices.put(bmpSet, setIndex++);
        }
        for (IntervalSet smpSet : arrayList) {
            setIndices.put(smpSet, setIndex++);
        }
        data.add(nedges);
        for (ATNState s3 : this.atn.states) {
            if (s3 == null || s3.getStateType() == 7) continue;
            for (int i4 = 0; i4 < s3.getNumberOfTransitions(); ++i4) {
                Transition t3 = s3.transition(i4);
                if (this.atn.states.get(t3.target.stateNumber) == null) {
                    throw new IllegalStateException("Cannot serialize a transition to a removed state.");
                }
                int src = s3.stateNumber;
                int trg = t3.target.stateNumber;
                int edgeType = Transition.serializationTypes.get(t3.getClass());
                int arg1 = 0;
                int arg2 = 0;
                int arg3 = 0;
                switch (edgeType) {
                    case 3: {
                        trg = ((RuleTransition)t3).followState.stateNumber;
                        arg1 = ((RuleTransition)t3).target.stateNumber;
                        arg2 = ((RuleTransition)t3).ruleIndex;
                        arg3 = ((RuleTransition)t3).precedence;
                        break;
                    }
                    case 10: {
                        PrecedencePredicateTransition ppt = (PrecedencePredicateTransition)t3;
                        arg1 = ppt.precedence;
                        break;
                    }
                    case 4: {
                        PredicateTransition pt = (PredicateTransition)t3;
                        arg1 = pt.ruleIndex;
                        arg2 = pt.predIndex;
                        arg3 = pt.isCtxDependent ? 1 : 0;
                        break;
                    }
                    case 2: {
                        arg1 = ((RangeTransition)t3).from;
                        arg2 = ((RangeTransition)t3).to;
                        if (arg1 != -1) break;
                        arg1 = 0;
                        arg3 = 1;
                        break;
                    }
                    case 5: {
                        arg1 = ((AtomTransition)t3).label;
                        if (arg1 != -1) break;
                        arg1 = 0;
                        arg3 = 1;
                        break;
                    }
                    case 6: {
                        ActionTransition at = (ActionTransition)t3;
                        arg1 = at.ruleIndex;
                        arg2 = at.actionIndex;
                        if (arg2 == -1) {
                            arg2 = 65535;
                        }
                        arg3 = at.isCtxDependent ? 1 : 0;
                        break;
                    }
                    case 7: {
                        arg1 = (Integer)setIndices.get(((SetTransition)t3).set);
                        break;
                    }
                    case 8: {
                        arg1 = (Integer)setIndices.get(((SetTransition)t3).set);
                        break;
                    }
                }
                data.add(src);
                data.add(trg);
                data.add(edgeType);
                data.add(arg1);
                data.add(arg2);
                data.add(arg3);
            }
        }
        int ndecisions = this.atn.decisionToState.size();
        data.add(ndecisions);
        for (DecisionState decStartState : this.atn.decisionToState) {
            data.add(decStartState.stateNumber);
        }
        if (this.atn.grammarType == ATNType.LEXER) {
            data.add(this.atn.lexerActions.length);
            block32: for (LexerAction action : this.atn.lexerActions) {
                data.add(action.getActionType().ordinal());
                switch (action.getActionType()) {
                    case CHANNEL: {
                        int channel = ((LexerChannelAction)action).getChannel();
                        data.add(channel != -1 ? channel : 65535);
                        data.add(0);
                        continue block32;
                    }
                    case CUSTOM: {
                        int ruleIndex = ((LexerCustomAction)action).getRuleIndex();
                        int actionIndex = ((LexerCustomAction)action).getActionIndex();
                        data.add(ruleIndex != -1 ? ruleIndex : 65535);
                        data.add(actionIndex != -1 ? actionIndex : 65535);
                        continue block32;
                    }
                    case MODE: {
                        int mode = ((LexerModeAction)action).getMode();
                        data.add(mode != -1 ? mode : 65535);
                        data.add(0);
                        continue block32;
                    }
                    case MORE: {
                        data.add(0);
                        data.add(0);
                        continue block32;
                    }
                    case POP_MODE: {
                        data.add(0);
                        data.add(0);
                        continue block32;
                    }
                    case PUSH_MODE: {
                        int mode = ((LexerPushModeAction)action).getMode();
                        data.add(mode != -1 ? mode : 65535);
                        data.add(0);
                        continue block32;
                    }
                    case SKIP: {
                        data.add(0);
                        data.add(0);
                        continue block32;
                    }
                    case TYPE: {
                        int type = ((LexerTypeAction)action).getType();
                        data.add(type != -1 ? type : 65535);
                        data.add(0);
                        continue block32;
                    }
                    default: {
                        String message = String.format(Locale.getDefault(), "The specified lexer action type %s is not valid.", new Object[]{action.getActionType()});
                        throw new IllegalArgumentException(message);
                    }
                }
            }
        }
        for (int i5 = 1; i5 < data.size(); ++i5) {
            if (data.get(i5) < 0 || data.get(i5) > 65535) {
                throw new UnsupportedOperationException("Serialized ATN data element " + data.get(i5) + " element " + i5 + " out of range " + 0 + ".." + 65535);
            }
            int value = data.get(i5) + 2 & 0xFFFF;
            data.set(i5, value);
        }
        return data;
    }

    private static void serializeSets(IntegerList data, Collection<IntervalSet> sets, CodePointSerializer codePointSerializer) {
        int nSets = sets.size();
        data.add(nSets);
        for (IntervalSet set : sets) {
            boolean containsEof = set.contains(-1);
            if (containsEof && set.getIntervals().get((int)0).b == -1) {
                data.add(set.getIntervals().size() - 1);
            } else {
                data.add(set.getIntervals().size());
            }
            data.add(containsEof ? 1 : 0);
            for (Interval I : set.getIntervals()) {
                if (I.a == -1) {
                    if (I.b == -1) continue;
                    codePointSerializer.serializeCodePoint(data, 0);
                } else {
                    codePointSerializer.serializeCodePoint(data, I.a);
                }
                codePointSerializer.serializeCodePoint(data, I.b);
            }
        }
    }

    public String decode(char[] data) {
        int version;
        data = (char[])data.clone();
        for (int i2 = 1; i2 < data.length; ++i2) {
            data[i2] = (char)(data[i2] - 2);
        }
        StringBuilder buf = new StringBuilder();
        int p2 = 0;
        if ((version = ATNDeserializer.toInt(data[p2++])) != ATNDeserializer.SERIALIZED_VERSION) {
            String reason = String.format("Could not deserialize ATN with version %d (expected %d).", version, ATNDeserializer.SERIALIZED_VERSION);
            throw new UnsupportedOperationException(new InvalidClassException(ATN.class.getName(), reason));
        }
        UUID uuid = ATNDeserializer.toUUID(data, p2);
        p2 += 8;
        if (!uuid.equals(ATNDeserializer.SERIALIZED_UUID)) {
            String reason = String.format(Locale.getDefault(), "Could not deserialize ATN with UUID %s (expected %s).", uuid, ATNDeserializer.SERIALIZED_UUID);
            throw new UnsupportedOperationException(new InvalidClassException(ATN.class.getName(), reason));
        }
        int n2 = ++p2;
        int maxType = ATNDeserializer.toInt(data[n2]);
        buf.append("max type ").append(maxType).append("\n");
        int n3 = ++p2;
        ++p2;
        int nstates = ATNDeserializer.toInt(data[n3]);
        for (int i3 = 0; i3 < nstates; ++i3) {
            int ruleIndex;
            int stype;
            if ((stype = ATNDeserializer.toInt(data[p2++])) == 0) continue;
            if ((ruleIndex = ATNDeserializer.toInt(data[p2++])) == 65535) {
                ruleIndex = -1;
            }
            String arg = "";
            if (stype == 12) {
                int loopBackStateNumber = ATNDeserializer.toInt(data[p2++]);
                arg = " " + loopBackStateNumber;
            } else if (stype == 4 || stype == 5 || stype == 3) {
                int endStateNumber = ATNDeserializer.toInt(data[p2++]);
                arg = " " + endStateNumber;
            }
            buf.append(i3).append(":").append(ATNState.serializationNames.get(stype)).append(" ").append(ruleIndex).append(arg).append("\n");
        }
        int numNonGreedyStates = ATNDeserializer.toInt(data[p2++]);
        for (int i4 = 0; i4 < numNonGreedyStates; ++i4) {
            int stateNumber = ATNDeserializer.toInt(data[p2++]);
        }
        int numPrecedenceStates = ATNDeserializer.toInt(data[p2++]);
        for (int i5 = 0; i5 < numPrecedenceStates; ++i5) {
            int stateNumber = ATNDeserializer.toInt(data[p2++]);
        }
        int nrules = ATNDeserializer.toInt(data[p2++]);
        for (int i6 = 0; i6 < nrules; ++i6) {
            int s2 = ATNDeserializer.toInt(data[p2++]);
            if (this.atn.grammarType == ATNType.LEXER) {
                int arg1 = ATNDeserializer.toInt(data[p2++]);
                buf.append("rule ").append(i6).append(":").append(s2).append(" ").append(arg1).append('\n');
                continue;
            }
            buf.append("rule ").append(i6).append(":").append(s2).append('\n');
        }
        int nmodes = ATNDeserializer.toInt(data[p2++]);
        for (int i7 = 0; i7 < nmodes; ++i7) {
            int s3 = ATNDeserializer.toInt(data[p2++]);
            buf.append("mode ").append(i7).append(":").append(s3).append('\n');
        }
        int numBMPSets = ATNDeserializer.toInt(data[p2++]);
        p2 = this.appendSets(buf, data, p2, numBMPSets, 0, ATNDeserializer.getUnicodeDeserializer(ATNDeserializer.UnicodeDeserializingMode.UNICODE_BMP));
        int numSMPSets = ATNDeserializer.toInt(data[p2++]);
        p2 = this.appendSets(buf, data, p2, numSMPSets, numBMPSets, ATNDeserializer.getUnicodeDeserializer(ATNDeserializer.UnicodeDeserializingMode.UNICODE_SMP));
        int nedges = ATNDeserializer.toInt(data[p2++]);
        for (int i8 = 0; i8 < nedges; ++i8) {
            int src = ATNDeserializer.toInt(data[p2]);
            int trg = ATNDeserializer.toInt(data[p2 + 1]);
            int ttype = ATNDeserializer.toInt(data[p2 + 2]);
            int arg1 = ATNDeserializer.toInt(data[p2 + 3]);
            int arg2 = ATNDeserializer.toInt(data[p2 + 4]);
            int arg3 = ATNDeserializer.toInt(data[p2 + 5]);
            buf.append(src).append("->").append(trg).append(" ").append(Transition.serializationNames.get(ttype)).append(" ").append(arg1).append(",").append(arg2).append(",").append(arg3).append("\n");
            p2 += 6;
        }
        int ndecisions = ATNDeserializer.toInt(data[p2++]);
        for (int i9 = 0; i9 < ndecisions; ++i9) {
            int s4 = ATNDeserializer.toInt(data[p2++]);
            buf.append(i9).append(":").append(s4).append("\n");
        }
        if (this.atn.grammarType == ATNType.LEXER) {
            int lexerActionCount = ATNDeserializer.toInt(data[p2++]);
            for (int i10 = 0; i10 < lexerActionCount; ++i10) {
                LexerActionType actionType = LexerActionType.values()[ATNDeserializer.toInt(data[p2++])];
                int data1 = ATNDeserializer.toInt(data[p2++]);
                int data2 = ATNDeserializer.toInt(data[p2++]);
            }
        }
        return buf.toString();
    }

    private int appendSets(StringBuilder buf, char[] data, int p2, int nsets, int setIndexOffset, ATNDeserializer.UnicodeDeserializer unicodeDeserializer) {
        for (int i2 = 0; i2 < nsets; ++i2) {
            boolean containsEof;
            int nintervals = ATNDeserializer.toInt(data[p2++]);
            buf.append(i2 + setIndexOffset).append(":");
            boolean bl = containsEof = data[p2++] != '\u0000';
            if (containsEof) {
                buf.append(this.getTokenName(-1));
            }
            for (int j2 = 0; j2 < nintervals; ++j2) {
                if (containsEof || j2 > 0) {
                    buf.append(", ");
                }
                int a2 = unicodeDeserializer.readUnicode(data, p2);
                int b2 = unicodeDeserializer.readUnicode(data, p2 += unicodeDeserializer.size());
                p2 += unicodeDeserializer.size();
                buf.append(this.getTokenName(a2)).append("..").append(this.getTokenName(b2));
            }
            buf.append("\n");
        }
        return p2;
    }

    public String getTokenName(int t2) {
        if (t2 == -1) {
            return "EOF";
        }
        if (this.atn.grammarType == ATNType.LEXER && t2 >= 0 && t2 <= 65535) {
            switch (t2) {
                case 10: {
                    return "'\\n'";
                }
                case 13: {
                    return "'\\r'";
                }
                case 9: {
                    return "'\\t'";
                }
                case 8: {
                    return "'\\b'";
                }
                case 12: {
                    return "'\\f'";
                }
                case 92: {
                    return "'\\\\'";
                }
                case 39: {
                    return "'\\''";
                }
            }
            if (Character.UnicodeBlock.of((char)t2) == Character.UnicodeBlock.BASIC_LATIN && !Character.isISOControl((char)t2)) {
                return '\'' + Character.toString((char)t2) + '\'';
            }
            String hex = Integer.toHexString(t2 | 0x10000).toUpperCase().substring(1, 5);
            String unicodeStr = "'\\u" + hex + "'";
            return unicodeStr;
        }
        if (this.tokenNames != null && t2 >= 0 && t2 < this.tokenNames.size()) {
            return this.tokenNames.get(t2);
        }
        return String.valueOf(t2);
    }

    public static String getSerializedAsString(ATN atn) {
        return new String(ATNSerializer.getSerializedAsChars(atn));
    }

    public static IntegerList getSerialized(ATN atn) {
        return new ATNSerializer(atn).serialize();
    }

    public static char[] getSerializedAsChars(ATN atn) {
        return Utils.toCharArray(ATNSerializer.getSerialized(atn));
    }

    public static String getDecoded(ATN atn, List<String> tokenNames) {
        IntegerList serialized = ATNSerializer.getSerialized(atn);
        char[] data = Utils.toCharArray(serialized);
        return new ATNSerializer(atn, tokenNames).decode(data);
    }

    private void serializeUUID(IntegerList data, UUID uuid) {
        this.serializeLong(data, uuid.getLeastSignificantBits());
        this.serializeLong(data, uuid.getMostSignificantBits());
    }

    private void serializeLong(IntegerList data, long value) {
        this.serializeInt(data, (int)value);
        this.serializeInt(data, (int)(value >> 32));
    }

    private void serializeInt(IntegerList data, int value) {
        data.add((char)value);
        data.add((char)(value >> 16));
    }

    private static interface CodePointSerializer {
        public void serializeCodePoint(IntegerList var1, int var2);
    }
}

